/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.axes;

import com.sap.jvm.profiling.ui.graph.axes.AxisLabelDimensionProvider;
import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisAdapter;
import com.sap.jvm.profiling.ui.graph.axes.RasterCalculationAdapter;

public class GraphAxisModel {
    public static final int DEFAULT_HORIZONTAL_AXIS_HEIGHT = 35;
    public static final int DEFAULT_VERTICAL_AXIS_WIDTH = 40;
    private double min = 0.0;
    private double max = 10.0;
    private double raster_start = 0.0;
    private double raster_step = 1.0;
    private boolean fixedRaster = false;
    private boolean horizontal;
    private int rasterHint = -1;
    private int preferredSize;
    private RangeLineAxisAdapter axisAdaptor = DEFAULT_AXIS_ADAPTOR;
    private static RangeLineAxisAdapter DEFAULT_AXIS_ADAPTOR = new RangeLineAxisAdapter(){

        @Override
        public double adjustMax(double currentMin, double currentMax) {
            return currentMax;
        }

        @Override
        public double adjustMin(double currentMin, double currentMax) {
            return currentMin;
        }
    };
    private RasterCalculationAdapter rasterAdapter;
    private AxisLabelDimensionProvider labelDimensionProvider;

    public GraphAxisModel(boolean horizontal) {
        this.horizontal = horizontal;
        this.rasterAdapter = new RasterCalculationAdapter(horizontal);
        this.preferredSize = horizontal ? 35 : 40;
        this.resetAxisSize();
    }

    public void setRangeAxisAdaptor(RangeLineAxisAdapter adapter) {
        this.axisAdaptor = adapter != null ? adapter : DEFAULT_AXIS_ADAPTOR;
    }

    public void adjustAxisToReadableValues() {
        double offset = (this.min - this.raster_start) % this.raster_step;
        double delta = offset >= 0.0 ? offset : offset + this.raster_step;
        this.min -= delta;
        this.max -= delta;
    }

    public void adjustAxis(double minValue, double maxValue, int pixelLength) {
        this.min = this.axisAdaptor.adjustMin(minValue, maxValue);
        this.max = this.axisAdaptor.adjustMax(minValue, maxValue);
        if (this.min == this.max) {
            this.max += this.max;
        }
        this.recalculateRaster(pixelLength, this.rasterHint);
    }

    public void setAxis(double minValue, double maxValue, int pixelLength) {
        this.min = minValue;
        this.max = maxValue;
        this.recalculateRaster(pixelLength, this.rasterHint);
    }

    public boolean isInRange(double value) {
        return value >= this.min && value <= this.max;
    }

    public int whichSide(double value) {
        return value < this.min ? -1 : (value > this.max ? 1 : 0);
    }

    public int getPosition(int length, double value) {
        return (int)Math.round((double)(length - 1) / this.getRange() * (value - this.min));
    }

    public double getValue(int length, int position) {
        return this.min + this.getRange() / (double)(length - 1) * (double)position;
    }

    public double getLength(int length, int pixels) {
        return this.getRange() / (double)length * (double)pixels;
    }

    public double getRange() {
        double range = this.max - this.min;
        return range <= 0.0 || Double.isInfinite(range) ? 1.0 : range;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    private void resetAxisSize() {
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
    }

    public void setRasterAdapter(RasterCalculationAdapter rasterAdapter) {
        this.rasterAdapter = rasterAdapter != null ? rasterAdapter : new RasterCalculationAdapter(this.horizontal);
    }

    public RasterCalculationAdapter getRasterAdapter() {
        return this.rasterAdapter;
    }

    public void setLabelDimensionProvider(AxisLabelDimensionProvider labelDimensionProvider) {
        this.labelDimensionProvider = labelDimensionProvider;
    }

    public void setFixedRaster(double value) {
        this.fixedRaster = true;
        this.raster_step = value;
        this.raster_start = 0.0;
    }

    public double getAxisRasterSize() {
        return this.raster_step;
    }

    public int getAxisRasterPixelSize(int pixelLength) {
        return (int)((double)pixelLength / this.getRange() * this.raster_step);
    }

    public double getAxisRasterStart() {
        return this.raster_start;
    }

    public void recalculateRaster(int length, int hint) {
        if (this.fixedRaster || length < 1) {
            return;
        }
        this.rasterHint = hint;
        if (this.labelDimensionProvider != null) {
            this.recalculateRasterImpl(length, hint);
            return;
        }
        double minRasterDistance = this.rasterAdapter.getInitialScaleStepSize();
        double maxRasterDistance = hint > 0 ? (double)hint : minRasterDistance * 1.2;
        double numberTicks = Math.max((double)length / minRasterDistance, 2.0);
        if (numberTicks > 7.0) {
            numberTicks = Math.max((double)length / maxRasterDistance, 7.0);
        }
        double preferredRasterSize = this.getRange() / numberTicks;
        this.raster_step = this.rasterAdapter.adaptRasterSize(preferredRasterSize, this.min, this.max);
        if (this.raster_step < 1.0) {
            this.raster_step = 1.0;
        }
        this.raster_start = this.rasterAdapter.getRasterOrigin(this.raster_step, this.min);
    }

    private void recalculateRasterImpl(int length, int hint) {
        double nextLargerRaster;
        double maxRasterStep = this.getRange() / 1.98;
        int rasterDistancePx = 10;
        if (hint > 40 && length / (hint / 4) >= 7) {
            rasterDistancePx = hint / 4;
        }
        double numberTicks = (double)length / (double)rasterDistancePx;
        double currentRasterSize = Math.min(this.getRange() / numberTicks, maxRasterStep / 2.0);
        currentRasterSize = this.rasterAdapter.adaptRasterSize(currentRasterSize, this.min, this.max);
        numberTicks = this.getRange() / currentRasterSize;
        double spacing = Math.max(1.0, numberTicks * 2.0);
        int labelSize = this.labelDimensionProvider.getLabelSize(this.max, currentRasterSize, this.min, this.max);
        double totalLabelsSize = ((double)labelSize + spacing) * numberTicks;
        this.raster_step = currentRasterSize;
        while (totalLabelsSize > (double)length && currentRasterSize < maxRasterStep && (currentRasterSize = this.rasterAdapter.adaptRasterSize(nextLargerRaster = Math.max(currentRasterSize * 1.01 + 1.0, 0.5 * this.getRange() / ((double)(length / labelSize) + 1.0)), this.min, this.max)) > this.raster_step) {
            labelSize = this.labelDimensionProvider.getLabelSize(this.max, currentRasterSize, this.min, this.max);
            numberTicks = this.getRange() / currentRasterSize;
            spacing = Math.max(1.0, numberTicks * 2.0);
            totalLabelsSize = ((double)labelSize + spacing) * numberTicks;
            if (!(numberTicks > 1.1)) continue;
            this.raster_step = currentRasterSize;
        }
        if (this.raster_step < 1.0) {
            this.raster_step = 1.0;
        }
        this.raster_start = this.rasterAdapter.getRasterOrigin(this.raster_step, this.min);
    }

    public int getPreferredDisplaySize() {
        return this.preferredSize;
    }

    public void setPreferredDisplaySize(int size) {
        this.preferredSize = size;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public String toString() {
        return "[" + this.min + ".." + this.max + "]";
    }
}

