/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.axes;

import com.sap.jvm.profiling.ui.graph.axes.AxisLabelDimensionProvider;
import com.sap.jvm.profiling.ui.graph.axes.GraphAxisModel;
import com.sap.jvm.profiling.ui.graph.axes.LineGraphAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;

public class LineGraphAxis {
    public static final int VERTICAL_ORIENTATION = 0;
    public static final int HOROZONTAL_ORIENTATION = 1;
    public static final int LABEL_LEFT = 0;
    public static final int LABEL_ONTOP = 0;
    public static final int LABEL_RIGHT = 1;
    public static final int LABEL_BELOW = 1;
    private static final int HORIZONTAL_LABEL_SPACING = 8;
    private boolean enableLableBlending = true;
    private final GraphAxisModel model;
    private LineGraphAxisCaptionProvider provider;
    private final int orientation;
    private final int labelPosition;
    private Color raster_color = Color.LIGHT_GRAY;
    private Color scale_color = Color.GRAY;
    private boolean showRasterLines = true;
    private Font titleFont;
    private int maxLabelLength = 0;
    private double modelMin = 0.0;
    private double modelRange = 0.0;

    public LineGraphAxis(GraphAxisModel model, int orientation, int labelPosition, final Renderer renderer) {
        this.model = model;
        this.raster_color = renderer.getDefaultInactiveHeaderBackground();
        this.scale_color = renderer.getDefaultForeground();
        this.orientation = orientation == 0 ? 0 : 1;
        this.labelPosition = labelPosition;
        model.setLabelDimensionProvider(new AxisLabelDimensionProvider(){

            @Override
            public int getLabelSize(double value, double rasterStep, double min, double max) {
                if (LineGraphAxis.this.orientation == 0) {
                    return renderer.getFontHeight();
                }
                String label = LineGraphAxis.this.getValueText(max, rasterStep, min, max);
                return renderer.getStringWidth(label) + 8;
            }
        });
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void enableLableBlending(boolean enable) {
        this.enableLableBlending = enable;
    }

    public void setAxisCaptionProvider(LineGraphAxisCaptionProvider caption_provider) {
        this.provider = caption_provider;
        this.maxLabelLength = 0;
        this.modelMin = 0.0;
        this.modelRange = 0.0;
    }

    public void setRasterColor(Color color) {
        this.raster_color = color;
    }

    public void enableRasterLines(boolean enable) {
        this.showRasterLines = enable;
    }

    public void repaintAxis(Rectangle graphArea, Rectangle axisArea, Rectangle axisClipArea, Renderer renderer) {
        this.repaintAxis(true, true, graphArea, axisArea, axisClipArea, renderer);
    }

    public void repaintAxis(boolean showLabels, boolean showRaster, Rectangle graphArea, Rectangle axisArea, Rectangle axisClipArea, Renderer renderer) {
        renderer.setPaintArea(axisArea);
        int length = this.orientation == 0 ? renderer.getHeight() : renderer.getWidth();
        this.repaint(this.model.getAxisRasterSize(), this.model.getAxisRasterStart(), this.model.getRange(), this.model.getMin(), length, graphArea, axisArea, axisClipArea, renderer, showLabels, showRaster);
    }

    private void repaint(double rasterSize, double rasterOrigin, double range, double min_value, int length, Rectangle graphArea, Rectangle axisArea, Rectangle axisClipArea, Renderer renderer, boolean showLabels, boolean showRaster) {
        double i;
        double offset = (min_value - rasterOrigin) % rasterSize;
        double start_value = offset >= 0.0 ? min_value - offset : min_value - offset - rasterSize;
        double raster_small = rasterSize / 5.0;
        double to = start_value <= min_value ? range + rasterSize : range;
        renderer.setForeground(this.scale_color);
        if (showLabels) {
            for (i = 0.0; i < to; i += raster_small) {
                this.drawScaleUnit(start_value + i, false, renderer);
            }
        }
        if (showLabels) {
            for (i = 0.0; i < to; i += rasterSize) {
                this.drawScaleUnit(start_value + i, true, renderer);
            }
        }
        if (showRaster) {
            renderer.setPaintArea(graphArea);
            for (i = 0.0; i < to; i += rasterSize) {
                this.drawRasterLine(start_value + i, renderer);
            }
            renderer.setForeground(this.scale_color);
        }
        renderer.setPaintArea(axisArea, axisClipArea);
        if (showLabels) {
            this.drawAxisLine(renderer);
        }
        renderer.setForeground(renderer.getDefaultForeground());
        if (showLabels) {
            this.getMaxLabelLength(renderer);
            String maxLabel = this.provider == null ? String.valueOf(to) : this.provider.provideScaleUnitCaption(to += start_value, rasterSize, min_value, min_value + range);
            this.maxLabelLength = Math.max(this.maxLabelLength, renderer.getStringWidth(maxLabel));
            int i2 = 0;
            for (double value = start_value; value < to; value += rasterSize) {
                String caption = this.provider == null ? String.valueOf(value) : this.provider.provideScaleUnitCaption(value, rasterSize, min_value, min_value + range);
                boolean force = i2++ % 2 == 0;
                this.labelScale(value, caption, force, renderer);
            }
        }
        this.labelTitle(renderer);
    }

    public String getAxisTitle() {
        if (this.provider == null) {
            return "";
        }
        return this.provider.provideAxisTitle(this.model.getMin(), this.model.getMax());
    }

    public boolean hasAxisTitle() {
        if (this.provider == null) {
            return false;
        }
        String title = this.provider.provideAxisTitle(this.model.getMin(), this.model.getMax());
        return title != null && title.length() > 0;
    }

    public int getMinDimension(Renderer renderer) {
        boolean hasTitle = this.hasAxisTitle();
        if (this.orientation == 1) {
            int distanceFromAxis = (int)Math.round((double)renderer.getFontHeight() * 0.75);
            return renderer.getFontHeight() + distanceFromAxis + 2;
        }
        return renderer.getFontHeight() * (hasTitle ? 2 : 1) + (hasTitle ? 2 : 0) + this.getMaxLabelLength(renderer);
    }

    private int getMaxLabelLength(Renderer renderer) {
        if (this.model.getMin() != this.modelMin || this.model.getRange() != this.modelRange) {
            this.maxLabelLength = 0;
        }
        if (this.maxLabelLength > 0) {
            return this.maxLabelLength;
        }
        double max = this.model.getMax();
        String maxLabel = this.provider == null ? String.valueOf(max) : this.provider.provideScaleUnitCaption(max, this.model.getAxisRasterSize(), this.model.getMin(), max);
        this.maxLabelLength = Math.max(this.maxLabelLength, renderer.getStringWidth(maxLabel));
        this.modelMin = this.model.getMin();
        this.modelRange = this.model.getRange();
        return this.maxLabelLength;
    }

    public String getAccessibeValueText(double value) {
        return this.getValueText(value, this.model.getAxisRasterSize(), this.model.getMin(), this.model.getMax());
    }

    public String getAccessibleText() {
        StringBuilder result = new StringBuilder();
        if (this.orientation == 1) {
            result.append("horizontal axis, ");
        } else {
            result.append("vertical axis, ");
        }
        double raster = this.model.getAxisRasterSize();
        double min = this.model.getMin();
        double max = this.model.getMax();
        result.append(" from ");
        result.append(this.getValueText(min, raster, min, max));
        result.append(", to ");
        result.append(this.getValueText(max, raster, min, max));
        result.append(", in ");
        result.append(this.getValueText(raster, raster, min, max));
        result.append(" steps");
        return result.toString();
    }

    private String getValueText(double value, double raster, double min, double max) {
        String result = null;
        if (this.provider != null) {
            try {
                result = this.provider.provideScaleUnitCaption(value, raster, min, max).trim();
            }
            catch (Throwable th) {
                return "UNDEFINED VALUE";
            }
        }
        if (result == null) {
            return String.valueOf(value);
        }
        if (result.length() == 0) {
            return "UNDEFINED VALUE";
        }
        return result;
    }

    private void drawRasterLine(double value, Renderer renderer) {
        if (!this.showRasterLines) {
            return;
        }
        renderer.setLineStyle(Renderer.LineType.LINE_DOT);
        renderer.setForeground(this.raster_color);
        if (this.orientation == 1) {
            int x = this.model.getPosition(renderer.getWidth(), value);
            if (x != 0) {
                renderer.drawLine(x, 0, x, renderer.getHeight());
            }
        } else {
            int y = this.model.getPosition(renderer.getHeight(), value);
            renderer.drawLine(0, y, renderer.getWidth(), y);
        }
        renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
    }

    private void drawAxisLine(Renderer renderer) {
        if (this.orientation == 1) {
            if (this.labelPosition == 1) {
                renderer.drawLine(0, renderer.getHeight() - 1, renderer.getWidth(), renderer.getHeight() - 1);
            } else {
                int h = renderer.getHeight() - renderer.getFontHeight() * 2;
                renderer.drawLine(0, h, renderer.getWidth(), h);
            }
        } else if (this.labelPosition == 0) {
            renderer.drawLine(renderer.getWidth() - 1, 0, renderer.getWidth() - 1, renderer.getHeight());
        } else {
            renderer.drawLine(0, 0, 0, renderer.getHeight());
        }
    }

    private void drawScaleUnit(double value, boolean big, Renderer renderer) {
        int offset = renderer.getFontHeight() / (big ? 2 : 4);
        if (this.orientation == 0) {
            int y = this.model.getPosition(renderer.getHeight(), value);
            if (this.labelPosition == 0) {
                renderer.drawLine(renderer.getWidth() - 1, y, renderer.getWidth() - offset, y);
            } else {
                renderer.drawLine(0, y, offset, y);
            }
        } else {
            int x = this.model.getPosition(renderer.getWidth(), value);
            if (this.labelPosition == 1) {
                renderer.drawLine(x, renderer.getHeight() - 1, x, renderer.getHeight() - offset);
            } else {
                int h = renderer.getHeight() - renderer.getFontHeight() * 2;
                renderer.drawLine(x, h, x, h + offset);
            }
        }
    }

    private void labelScale(double value, String caption, boolean force, Renderer renderer) {
        block14: {
            int valPos;
            int distanceFromAxis;
            int fontHeight;
            block15: {
                int blendEnd;
                int blendStart;
                int y;
                int startX;
                String text;
                int textSize;
                block16: {
                    fontHeight = renderer.getFontHeight();
                    distanceFromAxis = (int)Math.round((double)fontHeight * 0.75);
                    int labelLength = renderer.getStringWidth(caption);
                    if (labelLength > this.maxLabelLength) {
                        this.maxLabelLength = labelLength;
                    }
                    if (this.orientation != 1) break block15;
                    int x = this.model.getPosition(renderer.getWidth(), value);
                    textSize = labelLength + 4;
                    int rasterSize = this.model.getAxisRasterPixelSize(renderer.getWidth());
                    text = caption;
                    if (textSize > rasterSize) {
                        text = this.getShortText(renderer, text, rasterSize);
                    }
                    textSize = renderer.getStringWidth(text);
                    int halfText = textSize / 2 + 1;
                    startX = x - halfText;
                    y = this.labelPosition == 1 ? renderer.getHeight() - distanceFromAxis : renderer.getHeight() - 4;
                    Rectangle clipArea = renderer.getClippingArea();
                    Rectangle paintArea = renderer.getPainArea();
                    int leftBorder = Math.min(halfText, paintArea.x - clipArea.x);
                    blendStart = halfText - leftBorder;
                    int rightBorder = Math.min(halfText, clipArea.x_end - paintArea.x_end);
                    blendEnd = renderer.getWidth() - halfText + rightBorder;
                    if (this.enableLableBlending) break block16;
                    if (renderer.getWidth() <= x) break block14;
                    renderer.drawString(text, startX, y);
                    break block14;
                }
                if (startX > blendStart && startX + textSize < blendEnd) {
                    renderer.drawString(text, startX, y);
                } else {
                    boolean blendingLeft = startX <= blendStart;
                    double blendDistance = (double)textSize / 2.0;
                    for (int i = 0; i < text.length(); ++i) {
                        String c = text.substring(i, i + 1);
                        int endX = startX + renderer.getStringWidth(c);
                        if (blendingLeft && startX > blendStart) {
                            renderer.drawString(text.substring(i), startX, y);
                            break block14;
                        }
                        double outside = 0.0;
                        if (startX < blendStart) {
                            outside = blendStart - startX;
                        } else if (endX > blendEnd) {
                            outside = endX - blendEnd;
                        }
                        double alpha = 255.0 * (1.0 - outside / blendDistance);
                        renderer.setAlpha(Math.max(0, (int)Math.round(alpha)));
                        renderer.drawString(c, startX, y);
                        renderer.setAlpha(255);
                        startX = endX;
                    }
                }
                break block14;
            }
            int availableWidth = renderer.getWidth();
            if (this.hasAxisTitle()) {
                availableWidth -= fontHeight;
            }
            if (availableWidth - this.maxLabelLength < distanceFromAxis) {
                distanceFromAxis = Math.max(0, availableWidth - this.maxLabelLength);
            }
            if ((valPos = this.model.getPosition(renderer.getHeight(), value)) > renderer.getPainArea().height || valPos < 0) {
                return;
            }
            int[] textSize = this.getTextSize(caption, renderer);
            int rasterSize = this.model.getAxisRasterPixelSize(renderer.getHeight());
            if (!force && textSize[1] > rasterSize + 5) {
                return;
            }
            int x = 0;
            x = this.labelPosition == 0 ? renderer.getWidth() - textSize[0] - distanceFromAxis : distanceFromAxis;
            int y = valPos + textSize[1] / 2;
            for (String line : caption.split("\n")) {
                renderer.drawString(line, x, y);
                y -= renderer.getFontHeight();
            }
        }
    }

    private void labelTitle(Renderer renderer) {
        String title = this.getAxisTitle();
        if (title == null || title.length() == 0) {
            return;
        }
        Font defFont = renderer.getFont();
        if (this.titleFont == null) {
            this.titleFont = new Font(defFont.getName(), defFont.getSize() + 1, Font.Style.NORMAL);
        }
        renderer.setFont(this.titleFont);
        renderer.setAlpha(160);
        if (this.orientation == 1) {
            int fontHeight = renderer.getFontHeight();
            int availableHeight = renderer.getHeight() - fontHeight;
            if (availableHeight > fontHeight + 2) {
                int y = fontHeight + (int)Math.round((double)(availableHeight - fontHeight) * 0.2);
                int x = (renderer.getWidth() - renderer.getStringWidth(title)) / 2;
                renderer.drawString(title, x, y);
            }
        } else {
            int x = 0;
            if (this.labelPosition == 1) {
                x = renderer.getWidth() - renderer.getFontHeight();
            }
            int y = (renderer.getHeight() - renderer.getStringWidth(title)) / 2;
            renderer.drawString(title, x, y, -90.0f);
        }
        renderer.setFont(defFont);
        renderer.setAlpha(255);
    }

    public String getShortText(Renderer renderer, String text, int size) {
        String txt = "...";
        int length = text.length() - 1;
        for (int n = 1; renderer.getStringWidth(txt) < size && n < length; ++n) {
            txt = text.substring(0, n) + "...";
        }
        return txt;
    }

    private int[] getTextSize(String str, Renderer renderer) {
        String[] lines = str.split("\n");
        int max_width = 0;
        for (String line : lines) {
            int width = renderer.getStringWidth(line);
            if (max_width >= width) continue;
            max_width = width;
        }
        return new int[]{max_width, lines.length * renderer.getFontHeight()};
    }
}

