/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.axes;

import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisRasterAdapter;
import com.sap.jvm.profiling.ui.graph.dataset.RangeLineDataSet;

public class RangeLineAxisModel {
    long min;
    long max;
    long range;
    int screen_width = 1;
    double factor;
    private final RangeLineAxisRasterAdapter DEFAULT_ADAPTER;
    RangeLineAxisRasterAdapter adapter = this.DEFAULT_ADAPTER = new RangeLineAxisRasterAdapter(){

        @Override
        public long adaptRasterSize(long calculatedValue, long minV, long maxV) {
            return calculatedValue;
        }
    };
    private final double[] dec_row = new double[]{1.0, 2.0, 2.5, 4.0, 5.0, 10.0};
    private static final int MIN_STEP = 35;

    public RangeLineAxisModel() {
        this.setRange(0L, 10L);
    }

    public void setRasterAdapter(RangeLineAxisRasterAdapter adapter) {
        this.adapter = adapter == null ? this.DEFAULT_ADAPTER : adapter;
    }

    public void moveLeft(int pixels) {
        long delta = Math.round(this.toValue(pixels));
        this.moveLeft(delta);
    }

    public void moveLeft(long delta) {
        long tmpDelta = delta;
        if (tmpDelta == 0L) {
            tmpDelta = 1L;
        }
        if (this.min > 0L) {
            this.min = tmpDelta > this.min ? 0L : (this.min -= tmpDelta);
            this.max = this.min + this.range;
        }
    }

    public void moveRight(int pixels) {
        long delta = Math.round(this.toValue(pixels));
        this.moveRight(delta);
    }

    public void moveRight(long delta) {
        long tmpDelta = delta;
        if (tmpDelta == 0L) {
            tmpDelta = 1L;
        }
        this.min += tmpDelta;
        this.max = this.min + this.range;
    }

    public void zoomIn(long value) {
        if (this.range != 1L) {
            long new_min;
            long new_max;
            long d = this.min + this.range / 2L - value;
            int pd = this.toPixels(d);
            this.setRange(this.min - d, this.max - d);
            long delta = this.range / 10L;
            if (delta == 0L) {
                delta = 1L;
            }
            if ((new_max = this.max - delta) - (new_min = this.min + delta) < 1L) {
                new_max = new_min + 1L;
            }
            this.setRange(new_min, new_max);
            d = Math.round(this.toValue(pd));
            this.setRange(this.min + d, this.max + d);
        }
    }

    public void zoomOut() {
        long delta = this.range / 10L;
        if (delta == 0L) {
            delta = 1L;
        }
        long new_min = delta > this.min ? 0L : this.min - delta;
        this.setRange(new_min, this.max + delta);
    }

    public void setRange(long min, long max) {
        this.min = min;
        this.max = max;
        this.range = max - min;
        this.factor = (double)this.screen_width / (double)this.range;
    }

    public void updateRange(long minValue, long maxValue) {
        this.setRange(minValue < this.min ? minValue : this.min, maxValue > this.max ? maxValue : this.max);
    }

    public void setScreenWidth(int width) {
        this.screen_width = width;
        this.factor = (double)this.screen_width / (double)this.range;
    }

    public boolean isInAxisRange(RangeLineDataSet.Range testRange) {
        return testRange.getMinValue() < this.max && testRange.getMaxValue() > this.min;
    }

    public boolean isInAxisRange(long value) {
        return value < this.max && value > this.min;
    }

    public int toPixels(double size) {
        return (int)(size * this.factor);
    }

    public double toValue(int pixels) {
        return (double)pixels / this.factor;
    }

    public int getPixelPosition(double pos) {
        return pos < (double)this.min ? 0 : this.toPixels(pos - (double)this.min);
    }

    public int getPixelPosition(long pos, int offset) {
        if (pos < this.min) {
            return 0;
        }
        int max_pos = offset + this.toPixels(this.max - this.min);
        int my_pos = offset + this.toPixels(pos - this.min);
        return my_pos < max_pos ? my_pos : max_pos;
    }

    public long calculateRaster() {
        double row_member;
        double m;
        long res = 0L;
        double step = (double)this.range / (double)this.screen_width * 35.0;
        if (this.screen_width <= 35) {
            return this.adapter.adaptRasterSize(Math.round(step), this.min, this.max);
        }
        int n = 0;
        if (step > 1.0) {
            while (step < Math.pow(10.0, n) || step > Math.pow(10.0, n + 1)) {
                ++n;
            }
            m = Math.pow(10.0, n);
        } else {
            while (step > 1.0 / Math.pow(10.0, n) || step < 1.0 / Math.pow(10.0, n + 1)) {
                ++n;
            }
            m = 1.0 / Math.pow(10.0, n + 1);
        }
        double[] dArray = this.dec_row;
        int n2 = dArray.length;
        for (int i = 0; i < n2 && !((double)(res = Math.round(m * (row_member = dArray[i]))) >= step); ++i) {
        }
        return this.adapter.adaptRasterSize(res <= 0L ? 1L : res, this.min, this.max);
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public long getRange() {
        return this.range;
    }
}

