/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.axes;

import com.sap.jvm.profiling.ui.graph.axes.GraphAxisModel;
import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisAdapter;
import com.sap.jvm.profiling.ui.graph.axes.RasterCalculationAdapter;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxisModelListener;
import com.sap.jvm.profiling.ui.graph.dataset.Value2DSet;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.progress.RenderingAsyncProgress;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class XYGraphAxesModel {
    private GraphAxisModel xAxis = new GraphAxisModel(true);
    private GraphAxisModel yAxisPrimary = new GraphAxisModel(false);
    private GraphAxisModel yAxisSecondary = new GraphAxisModel(false);
    private Stack<StackFrame> undo_stack = new Stack();
    private ArrayList<XYGraphAxisModelListener> listeners = new ArrayList();
    private boolean listenersDisabled;

    public GraphAxisModel getXAxis() {
        return this.xAxis;
    }

    public GraphAxisModel getYAxis() {
        return this.yAxisPrimary;
    }

    public GraphAxisModel getYAxisSecondary() {
        return this.yAxisSecondary;
    }

    public void setRangeAxisAdaptor(RangeLineAxisAdapter xAdapter, RangeLineAxisAdapter yAdapter) {
        this.xAxis.setRangeAxisAdaptor(xAdapter);
        this.yAxisPrimary.setRangeAxisAdaptor(yAdapter);
    }

    public <T extends Value2DSet> void updateAxesSize(List<T> data, List<Boolean> secondary, int width, int height, RenderingAsyncProgress.Progress progress) {
        boolean empty_graphs = true;
        long size = 0L;
        for (Value2DSet graph : data) {
            if (graph.isEmpty()) continue;
            empty_graphs = false;
            size += graph.getSize();
        }
        if (empty_graphs) {
            this.xAxis.adjustAxis(0.0, 10.0, width);
            this.yAxisPrimary.adjustAxis(0.0, 10.0, height);
            this.yAxisSecondary.adjustAxis(0.0, 10.0, height);
        } else {
            if (progress != null) {
                if (progress.isCanceled()) {
                    return;
                }
                size /= 100L;
                progress.beginTask("Update Axes", 100);
            }
            this.updateAxes(data, secondary, width, height, progress, (int)size);
            if (progress != null && progress.isCanceled()) {
                return;
            }
        }
        this.notifyBothAxisAdjusted();
        this.undo_stack.clear();
    }

    public void setAxesToDefault(int width, int height) {
        this.xAxis.adjustAxis(0.0, 10.0, width);
        this.yAxisPrimary.adjustAxis(0.0, 10.0, height);
        this.yAxisSecondary.adjustAxis(0.0, 10.0, height);
        this.notifyBothAxisAdjusted();
        this.undo_stack.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends Value2DSet> void updateAxes(List<T> dataSets, List<Boolean> secondary, int width, int height, RenderingAsyncProgress.Progress progress, int tickSteps) {
        double min_x = Double.MAX_VALUE;
        double min_y = Double.MAX_VALUE;
        double min_y_sec = Double.MAX_VALUE;
        double max_x = Double.MIN_VALUE;
        double max_y = Double.MIN_VALUE;
        double max_y_sec = Double.MIN_VALUE;
        int numPrimary = 0;
        int numSecondary = 0;
        int i = 0;
        while (i < dataSets.size()) {
            Value2DSet data = (Value2DSet)dataSets.get(i);
            if (!data.isEmpty()) {
                boolean isSecondary = secondary.get(i);
                if (isSecondary) {
                    ++numSecondary;
                } else {
                    ++numPrimary;
                }
                int steps = tickSteps;
                Iterator<Value2D> iData = data.iterator();
                try {
                    while (iData.hasNext()) {
                        Value2D val = (Value2D)iData.next();
                        if (min_x > val.x) {
                            min_x = val.x;
                        }
                        if (max_x < val.x) {
                            max_x = val.x;
                        }
                        if (isSecondary) {
                            if (min_y_sec > val.y) {
                                min_y_sec = val.y;
                            }
                            if (max_y_sec < val.y) {
                                max_y_sec = val.y;
                            }
                        } else {
                            if (min_y > val.y) {
                                min_y = val.y;
                            }
                            if (max_y < val.y) {
                                max_y = val.y;
                            }
                        }
                        if (progress == null) continue;
                        if (progress.isCanceled()) {
                            return;
                        }
                        if (steps-- != 0) continue;
                        progress.incWorked();
                        steps = tickSteps;
                        progress.updateUI();
                    }
                }
                finally {
                    data.dispose(iData);
                }
            }
            this.xAxis.adjustAxis(min_x, max_x, width);
            if (numPrimary > 0) {
                this.yAxisPrimary.adjustAxis(min_y, max_y, height);
            }
            if (numSecondary > 0) {
                this.yAxisPrimary.adjustAxis(min_y_sec, max_y_sec, height);
            }
            ++i;
        }
    }

    public void adjustAxisToReadableValues() {
        this.xAxis.adjustAxisToReadableValues();
        this.yAxisPrimary.adjustAxisToReadableValues();
        this.yAxisSecondary.adjustAxisToReadableValues();
        this.notifyBothAxisAdjusted();
    }

    public void adjustXAxis(int width, double min, double max) {
        this.xAxis.adjustAxis(min, max, width);
        this.notifyXAxisAdjusted();
    }

    public void adjustYAxis(int height, double min, double max) {
        this.yAxisPrimary.adjustAxis(min, max, height);
        this.notifyYAxisAdjusted();
    }

    public void adjustSecondaryYAxis(int height, double min, double max) {
        this.yAxisSecondary.adjustAxis(min, max, height);
        this.notifyYAxisAdjusted();
    }

    public int isInVisibleXRange(Value2D value) {
        return this.xAxis.whichSide(value.x);
    }

    public int isInVisibleYRange(Value2D value) {
        return this.yAxisPrimary.whichSide(value.y);
    }

    public int getXPosition(int width, double x) {
        return this.xAxis.getPosition(width, x);
    }

    public int getYPosition(int height, double y, boolean secondary) {
        if (secondary) {
            return this.yAxisSecondary.getPosition(height, y);
        }
        return this.yAxisPrimary.getPosition(height, y);
    }

    public double getXValue(int width, int x) {
        return this.xAxis.getValue(width, x);
    }

    public double getYValue(int height, int y) {
        return this.yAxisPrimary.getValue(height, y);
    }

    public double getXLength(int width, int pixels) {
        return this.xAxis.getLength(width, pixels);
    }

    public double getXRange() {
        return this.xAxis.getRange();
    }

    public double getYRange() {
        return this.yAxisPrimary.getRange();
    }

    public double getSecondaryYRange() {
        return this.yAxisSecondary.getRange();
    }

    public double getMinX() {
        return this.xAxis.getMin();
    }

    public double getMaxX() {
        return this.xAxis.getMax();
    }

    public double getMinY() {
        return this.yAxisPrimary.getMin();
    }

    public double getSecondaryMinY() {
        return this.yAxisSecondary.getMin();
    }

    public double getMaxY() {
        return this.yAxisPrimary.getMax();
    }

    public double getSecondaryMaxY() {
        return this.yAxisSecondary.getMax();
    }

    public void refreshAxes() {
        this.notifyBothAxisAdjusted();
    }

    public byte[] exportUndoStack() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(StackFrame.HEADER, 0, StackFrame.HEADER.length);
        StackFrame.write(out, this.undo_stack.size());
        for (StackFrame frame : this.undo_stack) {
            frame.writeFrame(out);
        }
        return out.toByteArray();
    }

    public void importUndoStack(byte[] data) throws IOException {
        this.undo_stack.clear();
        if (data != null && data.length > 0) {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            StackFrame.checkHeader(in);
            int size = (int)StackFrame.read(in);
            for (int i = 0; i < size; ++i) {
                this.undo_stack.add(new StackFrame(in));
            }
        }
    }

    public boolean canUndo() {
        return !this.undo_stack.isEmpty();
    }

    public void markUndo() {
        this.undo_stack.push(new StackFrame(this.xAxis.getMin(), this.xAxis.getMax(), this.yAxisPrimary.getMin(), this.yAxisPrimary.getMax(), this.yAxisSecondary.getMin(), this.yAxisSecondary.getMax()));
        this.notifyUndoStackChanged();
    }

    public boolean unDo(int width, int height) {
        if (!this.undo_stack.empty()) {
            StackFrame frame = this.undo_stack.pop();
            this.xAxis.setAxis(frame.min_x, frame.max_x, width);
            this.yAxisPrimary.setAxis(frame.min_y, frame.max_y, height);
            this.yAxisSecondary.setAxis(frame.min_y_sec, frame.max_y_sec, height);
            this.notifyBothAxisAdjusted();
            this.notifyUndoStackChanged();
            return true;
        }
        return false;
    }

    public void setXRasterAdapter(RasterCalculationAdapter adapterX) {
        this.xAxis.setRasterAdapter(adapterX);
    }

    public void setYRasterAdapter(RasterCalculationAdapter adapterY) {
        this.yAxisPrimary.setRasterAdapter(adapterY);
    }

    public void setFixedXRaster(double value) {
        this.xAxis.setFixedRaster(value);
    }

    public void setFixedYRaster(double value) {
        this.yAxisPrimary.setFixedRaster(value);
    }

    public void recalculateAxesRaster(int width, int height) {
        this.xAxis.recalculateRaster(width, -1);
        int xRasterDistance = this.xAxis.getAxisRasterPixelSize(width);
        this.yAxisPrimary.recalculateRaster(height, xRasterDistance);
        this.yAxisSecondary.recalculateRaster(height, xRasterDistance);
    }

    public double getXAxisRasterSize() {
        return this.xAxis.getAxisRasterSize();
    }

    public int getXAxisRasterPixelSize(int width) {
        return (int)((double)width / this.getXRange() * this.getXAxisRasterSize());
    }

    public double getXAxisRasterStart() {
        return this.xAxis.getAxisRasterSize();
    }

    public double getYAxisRasterSize() {
        return this.yAxisPrimary.getAxisRasterSize();
    }

    public int getYAxisRasterPixelSize(int height) {
        return (int)((double)height / this.getYRange() * this.getYAxisRasterSize());
    }

    public double getYAxisRasterStart() {
        return this.yAxisPrimary.getAxisRasterStart();
    }

    public void addAxisListener(XYGraphAxisModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeAxisListener(XYGraphAxisModelListener listener) {
        this.listeners.remove(listener);
    }

    public void setListenersEnabled(boolean enable) {
        this.listenersDisabled = !enable;
    }

    private void notifyXAxisAdjusted() {
        if (this.listenersDisabled) {
            return;
        }
        for (XYGraphAxisModelListener listener : this.listeners) {
            listener.adjustedXAxis(this);
        }
    }

    private void notifyYAxisAdjusted() {
        if (this.listenersDisabled) {
            return;
        }
        for (XYGraphAxisModelListener listener : this.listeners) {
            listener.adjustedYAxis(this);
        }
    }

    private void notifyBothAxisAdjusted() {
        if (this.listenersDisabled) {
            return;
        }
        for (XYGraphAxisModelListener listener : this.listeners) {
            listener.adjustedBothAxis(this);
        }
    }

    private void notifyUndoStackChanged() {
        if (this.listenersDisabled) {
            return;
        }
        for (XYGraphAxisModelListener listener : this.listeners) {
            listener.undoStackChanged(this);
        }
    }

    public String toString() {
        return "X-AXIS " + this.xAxis + "\nY-AXIS " + this.yAxisPrimary + " (prim.), " + this.yAxisSecondary + " (second.)";
    }

    private static class StackFrame {
        double min_x;
        double max_x;
        double min_y;
        double max_y;
        double min_y_sec;
        double max_y_sec;
        static byte[] HEADER = new byte[]{1, 35, 69, 103};

        public StackFrame(double min_x, double max_x, double min_y, double max_y, double min_y_sec, double max_y_sec) {
            this.min_x = min_x;
            this.max_x = max_x;
            this.min_y = min_y;
            this.max_y = max_y;
            this.min_y_sec = min_y_sec;
            this.max_y_sec = max_y_sec;
        }

        private StackFrame(ByteArrayInputStream in) {
            this.min_x = StackFrame.read(in);
            this.max_x = StackFrame.read(in);
            this.min_y = StackFrame.read(in);
            this.max_y = StackFrame.read(in);
            this.min_y_sec = StackFrame.read(in);
            this.max_y_sec = StackFrame.read(in);
        }

        private void writeFrame(ByteArrayOutputStream out) {
            StackFrame.write(out, this.min_x);
            StackFrame.write(out, this.max_x);
            StackFrame.write(out, this.min_y);
            StackFrame.write(out, this.max_y);
            StackFrame.write(out, this.min_y_sec);
            StackFrame.write(out, this.max_y_sec);
        }

        private static void write(ByteArrayOutputStream stream, double value) {
            long val = Double.doubleToLongBits(value);
            stream.write((byte)(val >>> 56 & 0xFFL));
            stream.write((byte)(val >>> 48 & 0xFFL));
            stream.write((byte)(val >>> 40 & 0xFFL));
            stream.write((byte)(val >>> 32 & 0xFFL));
            stream.write((byte)(val >>> 24 & 0xFFL));
            stream.write((byte)(val >>> 16 & 0xFFL));
            stream.write((byte)(val >>> 8 & 0xFFL));
            stream.write((byte)(val >>> 0 & 0xFFL));
        }

        private static double read(ByteArrayInputStream stream) {
            long bits = ((long)stream.read() << 56) + ((long)(stream.read() & 0xFF) << 48) + ((long)(stream.read() & 0xFF) << 40) + ((long)(stream.read() & 0xFF) << 32) + ((long)(stream.read() & 0xFF) << 24) + (long)((stream.read() & 0xFF) << 16) + (long)((stream.read() & 0xFF) << 8) + (long)((stream.read() & 0xFF) << 0);
            return Double.longBitsToDouble(bits);
        }

        private static void checkHeader(ByteArrayInputStream in) throws IOException {
            for (int i = 0; i < HEADER.length; ++i) {
                if (in.read() == HEADER[i]) continue;
                throw new IOException("Invalid data format of the UnDo stack!");
            }
        }
    }
}

