/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.dataset;

import com.sap.jvm.profiling.ui.graph.dataset.BarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.DataSet;
import com.sap.jvm.profiling.ui.graph.dataset.Value2DSet;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import java.util.ArrayList;
import java.util.Iterator;

public class AccBarGraphDataSet
implements DataSet,
Value2DSet {
    private BarGraphDataSet[] sets;
    private String name;

    public AccBarGraphDataSet(String name, BarGraphDataSet[] sets) {
        this.sets = sets;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        if (this.sets == null || this.sets.length == 0) {
            return true;
        }
        for (BarGraphDataSet set : this.sets) {
            if (set.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Value2D> iterator() {
        ArrayList<Value2D> values = new ArrayList<Value2D>();
        for (BarGraphDataSet set : this.sets) {
            int i = 0;
            for (Value2D val : set.values) {
                if (i == values.size()) {
                    values.add(new Value2D(val.x, val.y));
                } else {
                    ((Value2D)values.get((int)i)).y += val.y;
                }
                ++i;
            }
        }
        return values.iterator();
    }

    @Override
    public void dispose(Iterator<Value2D> iterator) {
    }

    public BarGraphDataSet[] getDataSets() {
        return this.sets;
    }

    @Override
    public long getSize() {
        int size = 0;
        for (BarGraphDataSet set : this.sets) {
            size = (int)((long)size | set.getSize());
        }
        return size;
    }
}

