/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.dataset;

import com.sap.jvm.profiling.ui.graph.dataset.SingeBarDataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.ColorPool;
import java.util.ArrayList;
import java.util.List;

public class AccSingleBarDataSet
extends SingeBarDataSet {
    private final ColorPool colPool = new ColorPool();
    private List<AccValue> values = new ArrayList<AccValue>();
    private long total = 0L;
    private List<RangeMarker> rangeMarkers = new ArrayList<RangeMarker>();

    public AccSingleBarDataSet() {
        this.colPool.setDefinedStart(3, 0, 0, 3, 26, 12, 12);
    }

    public int addValue(long value) {
        return this.addValue(value, this.colPool.getNext(), null);
    }

    public int addValue(long value, String toolTip) {
        return this.addValue(value, this.colPool.getNext(), toolTip);
    }

    public int addValue(long value, Color color) {
        return this.addValue(value, color, null);
    }

    public int addValue(long value, Color color, String toolTip) {
        this.checkMax(value);
        this.values.add(new AccValue(value, color, toolTip));
        this.total += value;
        super.setValue(this.total);
        return this.values.size() - 1;
    }

    @Override
    public long getValue() {
        return this.total;
    }

    @Override
    public void setValue(long value) {
        throw new UnsupportedOperationException("The total value cannot be set directly, use addValue or updateValue methods.");
    }

    @Override
    public void setMaxValue(long max) {
        if (this.total > max) {
            long sum = 0L;
            for (int i = 0; i < this.values.size(); ++i) {
                AccValue entry = this.values.get(i);
                if ((sum += entry.value) <= max) continue;
                entry.value -= sum - max;
                sum = max;
            }
            this.total = max;
        }
        super.setMaxValue(max);
    }

    public void updateValue(int idx, long value) {
        AccValue oldValue = this.values.get(idx);
        this.total += value - oldValue.value;
        oldValue.value = value;
        super.setValue(this.total);
    }

    public long getValue(int idx) {
        return this.values.get((int)idx).value;
    }

    @Override
    public double getPercent() {
        double percent = 100.0 / (double)this.getMaxValue() * (double)this.total;
        if (percent > 100.0) {
            percent = 100.0;
        }
        return percent;
    }

    public String getToolTip(int idx) {
        return this.values.get((int)idx).tip;
    }

    public int getValuesCount() {
        return this.values.size();
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        if (!this.values.isEmpty()) {
            this.values.get((int)0).color = color;
        } else {
            this.values.add(new AccValue(0L, color, null));
        }
    }

    public Color getColor(int idx) {
        return this.values.isEmpty() ? null : this.values.get((int)idx).color;
    }

    @Override
    public Color getColor() {
        return this.values.isEmpty() ? super.getColor() : this.getColor(0);
    }

    @Override
    public void setToolTip(String tip) {
        super.setToolTip(tip);
        if (!this.values.isEmpty()) {
            this.values.get((int)0).tip = tip;
        } else {
            this.values.add(new AccValue(0L, COLORS.getNext(), tip));
        }
    }

    public void setRangeMarker(long from, long to, String description, Color color) {
        assert (from >= 0L && to <= this.getMaxValue() && from <= to);
        this.rangeMarkers.add(new RangeMarker(description, from, to, color));
    }

    public List<RangeMarker> getRangeMarkers() {
        return this.rangeMarkers;
    }

    private void checkMax(long value) {
        if (this.total + value > this.getMaxValue()) {
            throw new IllegalArgumentException("The specified value exeeds the possible value range!");
        }
    }

    public static class RangeMarker {
        private final String description;
        private final long from;
        private final long to;
        private final Color color;

        private RangeMarker(String description, long from, long to, Color color) {
            this.description = description;
            this.from = from;
            this.to = to;
            this.color = color;
        }

        public String getDescription() {
            return this.description;
        }

        public long getFromValue() {
            return this.from;
        }

        public long getToValue() {
            return this.to;
        }

        public Color getColor() {
            return this.color;
        }
    }

    private static class AccValue {
        long value;
        Color color;
        String tip;

        public AccValue(long value, Color color, String tip) {
            this.value = value;
            this.color = color;
            this.tip = tip;
        }
    }
}

