/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.dataset;

import com.sap.jvm.profiling.ui.graph.dataset.BarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.XYGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import java.util.HashMap;
import java.util.Map;

public class ColoredBarGraphDataSet
extends BarGraphDataSet {
    private Map<Value2D, Color> colors = new HashMap<Value2D, Color>();
    private Map<Value2D, String> texts = new HashMap<Value2D, String>();

    public ColoredBarGraphDataSet() {
        super("");
    }

    public ColoredBarGraphDataSet(String name) {
        super(name);
    }

    @Override
    public void addValue(double value, Object data) {
        this.addValue(value, String.valueOf(value), Color.getRandomColor(), data);
    }

    @Override
    public void addValue(double value) {
        this.addValue(value, String.valueOf(value), Color.getRandomColor());
    }

    public void addValue(double value, String text, Color color) {
        this.addValue(value, text, color, null);
    }

    public void addValue(double value, String text, Color color, Object data) {
        long x_index = this.getSize();
        Value2D newValue = new Value2D(x_index, value, false);
        this.colors.put(newValue, color);
        this.texts.put(newValue, text);
        this.values.add(newValue);
        if (data != null) {
            this.setData(newValue, data);
        }
    }

    public Color getColor(Value2D value) {
        return this.colors.get(value);
    }

    public String getText(Value2D value) {
        return this.texts.get(value);
    }

    @Override
    public void removeAllValues() {
        super.removeAllValues();
        this.colors.clear();
        this.texts.clear();
    }

    @Override
    public XYGraphDataSet.GraphType getType() {
        return XYGraphDataSet.GraphType.COLORED;
    }
}

