/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.dataset;

import com.sap.jvm.profiling.ui.graph.renderer.Color;

public class LineGraphAnnotation {
    private static final Color COLOR_INFO = new Color(230, 255, 230);
    private static final Color COLOR_ERROR = new Color(255, 230, 230);
    private static final Color COLOR_WARNING = new Color(255, 255, 220);
    private static final Color COLOR_INFO2 = new Color(140, 180, 20);
    private static final Color COLOR_ERROR2 = new Color(170, 0, 30);
    private static final Color COLOR_WARNING2 = new Color(200, 150, 30);
    private Severity severity;
    private double value;
    private double end;
    private String msg;
    private boolean range;
    private Object data;
    private Color fillColor;
    private Color borderColor;

    public LineGraphAnnotation(Severity severity, String msg, double value) {
        this.severity = severity;
        this.value = value;
        this.end = -1.0;
        this.msg = msg;
    }

    public LineGraphAnnotation(Severity severity, String msg, double value, double end) {
        this(severity, msg, value);
        this.end = end;
        this.range = true;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.msg;
    }

    public boolean isRange() {
        return this.range;
    }

    public double getValue() {
        return this.value;
    }

    public double getEndValue() {
        return this.end;
    }

    public void setEndValue(double newEndValue) {
        this.range = true;
        this.end = newEndValue;
    }

    public void setEndValue(double newEndValue, String newMsg) {
        this.setEndValue(newEndValue);
        this.msg = newMsg;
    }

    public Color getColor() {
        if (this.fillColor != null) {
            return this.fillColor;
        }
        switch (this.severity) {
            case ERROR: {
                return COLOR_ERROR;
            }
            case WARNING: {
                return COLOR_WARNING;
            }
            case INFO: {
                return COLOR_INFO;
            }
        }
        return null;
    }

    public Color getBorderColor() {
        if (this.borderColor != null) {
            return this.borderColor;
        }
        switch (this.severity) {
            case ERROR: {
                return COLOR_ERROR2;
            }
            case WARNING: {
                return COLOR_WARNING2;
            }
            case INFO: {
                return COLOR_INFO2;
            }
        }
        return null;
    }

    public void decorate(Color fillCl, Color borderCl) {
        this.fillColor = fillCl;
        this.borderColor = borderCl;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public static enum Severity {
        WARNING,
        ERROR,
        INFO;

    }
}

