/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.dataset;

import com.sap.jvm.profiling.ui.graph.dataset.LineGraphAnnotation;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphAnnotationSetListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LineGraphAnnotationSet {
    private List<LineGraphAnnotation> annotations = new ArrayList<LineGraphAnnotation>();
    private List<LineGraphAnnotationSetListener> listeners = new ArrayList<LineGraphAnnotationSetListener>();
    private boolean isView;

    public LineGraphAnnotationSet() {
    }

    private LineGraphAnnotationSet(List<LineGraphAnnotation> annotations) {
        this.annotations = annotations;
        this.isView = true;
    }

    public boolean isEmpty() {
        return this.annotations.isEmpty();
    }

    public int getSize() {
        return this.annotations.size();
    }

    private void checkView() {
        if (this.isView) {
            throw new IllegalStateException("This operation is not supported by the set views!");
        }
    }

    private void addSorted(LineGraphAnnotation a) {
        int lastIdx = this.annotations.size() - 1;
        if (this.annotations.isEmpty() || this.annotations.get(lastIdx).getValue() < a.getValue()) {
            this.annotations.add(a);
        } else {
            int idx = this.indexOf(a.getValue(), this.annotations);
            int insertIdx = idx == -1 ? lastIdx : idx;
            this.annotations.add(insertIdx, a);
        }
    }

    public synchronized LineGraphAnnotation addInfoStamp(double value, String msg, Object data) {
        return this.addStampImpl(LineGraphAnnotation.Severity.INFO, value, msg, data);
    }

    public synchronized LineGraphAnnotation addWarningStamp(double value, String msg, Object data) {
        return this.addStampImpl(LineGraphAnnotation.Severity.WARNING, value, msg, data);
    }

    public synchronized LineGraphAnnotation addErrorStamp(double value, String msg, Object data) {
        return this.addStampImpl(LineGraphAnnotation.Severity.ERROR, value, msg, data);
    }

    private LineGraphAnnotation addStampImpl(LineGraphAnnotation.Severity severity, double value, String msg, Object data) {
        int idx;
        this.checkView();
        int lastIdx = this.annotations.size() - 1;
        if (lastIdx > 0 && this.annotations.get(lastIdx).getValue() > value && (idx = this.indexOf(value, this.annotations)) != -1) {
            LineGraphAnnotation a;
            for (int i = idx; i < this.annotations.size() && (a = this.annotations.get(i)).getValue() == value; ++i) {
                if (a.getData() != data || !msg.equals(a.getMessage())) continue;
                return a;
            }
        }
        LineGraphAnnotation annotation = new LineGraphAnnotation(severity, msg, value);
        this.addSorted(annotation);
        annotation.setData(data);
        this.notifyAnnotationAdded(annotation);
        return annotation;
    }

    private int indexOf(double value, List<LineGraphAnnotation> list) {
        if (list.isEmpty()) {
            return -1;
        }
        if (list.size() == 1) {
            if (list.get(0).getValue() >= value) {
                return 0;
            }
            return -1;
        }
        int middle = list.size() / 2;
        double valMiddle = list.get(middle).getValue();
        if (valMiddle < value) {
            int tmp = this.indexOf(value, list.subList(middle + 1, list.size()));
            return tmp == -1 ? -1 : middle + 1 + tmp;
        }
        int tmp = this.indexOf(value, list.subList(0, middle));
        return tmp == -1 ? middle : tmp;
    }

    public synchronized LineGraphAnnotation addInfoRange(double startValue, double endValue, String msg, Object data) {
        return this.addRangeImpl(LineGraphAnnotation.Severity.INFO, startValue, endValue, msg, data);
    }

    public synchronized LineGraphAnnotation addWarningRange(double startValue, double endValue, String msg, Object data) {
        return this.addRangeImpl(LineGraphAnnotation.Severity.WARNING, startValue, endValue, msg, data);
    }

    public synchronized LineGraphAnnotation addErrorRange(double startValue, double endValue, String msg, Object data) {
        return this.addRangeImpl(LineGraphAnnotation.Severity.ERROR, startValue, endValue, msg, data);
    }

    private LineGraphAnnotation addRangeImpl(LineGraphAnnotation.Severity severity, double startValue, double endValue, String msg, Object data) {
        int idx;
        this.checkView();
        int lastIdx = this.annotations.size() - 1;
        if (lastIdx > 0 && this.annotations.get(lastIdx).getValue() > startValue && (idx = this.indexOf(startValue, this.annotations)) != -1) {
            LineGraphAnnotation a;
            for (int i = idx; i < this.annotations.size() && (a = this.annotations.get(i)).getValue() == startValue; ++i) {
                if (a.getData() != data || !msg.equals(a.getMessage())) continue;
                a.setEndValue(endValue);
                return a;
            }
        }
        LineGraphAnnotation annotation = new LineGraphAnnotation(severity, msg, startValue, endValue);
        this.addSorted(annotation);
        annotation.setData(data);
        this.notifyAnnotationAdded(annotation);
        return annotation;
    }

    public synchronized void clearAnnotations() {
        this.checkView();
        this.annotations.clear();
        this.notifyAnnotationsRemoved();
    }

    public synchronized void removeAnnotation(LineGraphAnnotation annotation) {
        this.checkView();
        if (this.annotations.remove(annotation)) {
            this.notifyAnnotationRemoved(annotation);
        }
    }

    public synchronized List<LineGraphAnnotation> getAllAnnotations() {
        return new ArrayList<LineGraphAnnotation>(this.annotations);
    }

    public void addAnnotationSetListener(LineGraphAnnotationSetListener listener) {
        if (this.listeners.indexOf(listener) == -1) {
            this.listeners.add(listener);
        }
    }

    public void removeAnnotationSetListener(LineGraphAnnotationSetListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyAnnotationAdded(LineGraphAnnotation annotation) {
        for (LineGraphAnnotationSetListener l : this.listeners) {
            l.annotationAdded(this, annotation);
        }
    }

    private void notifyAnnotationsRemoved() {
        for (LineGraphAnnotationSetListener l : this.listeners) {
            l.allAnnotationsRemoved(this);
        }
    }

    private void notifyAnnotationRemoved(LineGraphAnnotation a) {
        for (LineGraphAnnotationSetListener l : this.listeners) {
            l.annotationRemoved(this, a);
        }
    }

    public List<LineGraphAnnotation> getAnnotations(double start, double end) {
        if (!this.annotations.isEmpty()) {
            int startIdx;
            int endIdx = this.indexedBS(end, false);
            ArrayList<LineGraphAnnotation> list = new ArrayList<LineGraphAnnotation>(endIdx - startIdx + 1);
            if (endIdx >= startIdx) {
                for (startIdx = this.indexedBS(start, true); startIdx <= endIdx; ++startIdx) {
                    list.add(this.annotations.get(startIdx));
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    public synchronized LineGraphAnnotationSet getSetView(double start, double end) {
        int startIdx = this.indexedBS(start, true);
        int endIdx = this.indexedBS(end, false);
        if (!this.annotations.isEmpty() && endIdx - startIdx >= 0) {
            return new LineGraphAnnotationSet(new ArrayList<LineGraphAnnotation>(this.annotations.subList(startIdx, endIdx + 1)));
        }
        return new LineGraphAnnotationSet(this.annotations.subList(startIdx, startIdx));
    }

    public int indexedBS(double x, boolean height) {
        int maxSize;
        int low = 0;
        int high = maxSize = this.annotations.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            double midVal = this.annotations.get(mid).getValue();
            double cmp = midVal - x;
            if (cmp < 0.0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0.0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (low == 0) {
            return 0;
        }
        if (height) {
            return low > maxSize ? maxSize : low;
        }
        return low - 1;
    }
}

