/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.dataset;

import com.sap.jvm.profiling.ui.graph.dataset.XYGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class LineGraphDataSet
extends XYGraphDataSet {
    private Color cl_fill = Color.brighter(this.getGraphColor());
    private Color cl_value = Color.getRandomColor();
    private XYGraphDataSet.GraphType type = XYGraphDataSet.GraphType.EMPHASIZED;
    private GraphStyle style = GraphStyle.LINES;

    protected LineGraphDataSet(String name) {
        super(name);
    }

    public Value2D addValue(double x, double y) {
        return this.addValue(x, y, false);
    }

    public Value2D addValue(double x, double y, boolean emphasized) {
        return this.addValue(x, y, emphasized, null);
    }

    public Value2D addValue(double x, double y, Object data) {
        return this.addValue(x, y, true, data);
    }

    protected Value2D addValue(double x, double y, boolean emphasized, Object data) {
        Value2D newValue = new Value2D(x, y, emphasized);
        int index = Collections.binarySearch(this.values, newValue);
        if (index > -1) {
            this.values.set(index, newValue);
        } else {
            this.values.add(-index - 1, newValue);
        }
        if (data != null) {
            this.setData(newValue, data);
        }
        this.checkMinMax(newValue);
        return newValue;
    }

    public void removeFirstValues(long remove_count) {
        long count = remove_count;
        boolean adaptMinMax = false;
        if (count >= this.getSize()) {
            this.values.clear();
            this.resetMinMax();
        } else {
            while (count-- != 0L) {
                double y = ((Value2D)this.values.get((int)0)).y;
                adaptMinMax = y == this.getMaxY() || y == this.getMinY();
                this.values.remove(0);
            }
        }
        if (adaptMinMax) {
            this.resetMinMax();
            for (Value2D v : this.values) {
                this.checkMinMax(v);
            }
        }
    }

    public void removeLastValues(long remove_count) {
        long count = remove_count;
        boolean adaptMinMax = false;
        if (count >= this.getSize()) {
            this.values.clear();
            this.resetMinMax();
        } else {
            while (count-- != 0L) {
                double y = ((Value2D)this.values.get((int)(this.values.size() - 1))).y;
                adaptMinMax = y == this.getMaxY() || y == this.getMinY();
                this.values.remove(this.values.size() - 1);
            }
        }
        if (adaptMinMax) {
            this.resetMinMax();
            for (Value2D v : this.values) {
                this.checkMinMax(v);
            }
        }
    }

    public void removeValue(double x_value, long remove_count) {
        long idx = this.getIndexOfXValue(x_value);
        long to = idx + remove_count;
        to = to > this.getSize() ? (long)((int)this.getSize()) : to;
        List toDel = this.values.subList((int)idx, (int)to);
        boolean adaptMinMax = false;
        for (Value2D v : toDel) {
            if (v.y != this.getMaxY() && v.y != this.getMinY()) continue;
            adaptMinMax = true;
            break;
        }
        toDel.clear();
        if (adaptMinMax) {
            this.resetMinMax();
            for (Value2D v : this.values) {
                this.checkMinMax(v);
            }
        }
    }

    public Value2D getNext(Value2D value) {
        int index = Collections.binarySearch(this.values, value);
        if (index > -1 && (long)index < this.getSize() - 1L) {
            return (Value2D)this.values.get(index + 1);
        }
        return null;
    }

    public Value2D getPrevious(Value2D value) {
        int index = Collections.binarySearch(this.values, value);
        if (index > 0) {
            return (Value2D)this.values.get(index - 1);
        }
        return null;
    }

    @Override
    public XYGraphDataSet.GraphType getType() {
        return this.type;
    }

    public void setType(XYGraphDataSet.GraphType type) {
        this.type = type;
    }

    public GraphStyle getDrawingStyle() {
        return this.style;
    }

    public void setDrawingStyle(GraphStyle style) {
        this.style = style;
    }

    public final void setValueColor(Color color) {
        this.cl_value = color;
    }

    public final Color getValueColor() {
        return this.cl_value;
    }

    public final Color getFillColor() {
        return this.cl_fill;
    }

    @Override
    public void setGraphColor(Color color) {
        super.setGraphColor(color);
        this.cl_fill = Color.brighter(color);
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    public Iterable<Value2D> getValues(final long fromIndex, final long toIndex) {
        return new Iterable<Value2D>(){

            @Override
            public Iterator<Value2D> iterator() {
                return new Iterator<Value2D>(){
                    long index;
                    {
                        this.index = fromIndex;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < toIndex;
                    }

                    @Override
                    public Value2D next() {
                        Value2D result = LineGraphDataSet.this.getValueAt(this.index);
                        ++this.index;
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static enum GraphStyle {
        LINES,
        LINES_FILLED,
        LINES_DOTTED,
        CONNECTED_POINTS,
        CONNECTED_POINTS_DOTTED,
        DATA_POINTS;

    }
}

