/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.dataset;

import com.sap.jvm.profiling.ui.graph.LineGraphRenderer;
import com.sap.jvm.profiling.ui.graph.axes.GraphAxisModel;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphPresentationAdapter;
import com.sap.jvm.profiling.ui.graph.dataset.Value2DPersistanceList;
import com.sap.jvm.profiling.ui.graph.dataset.Value2DStorage;
import com.sap.jvm.profiling.ui.graph.dataset.XPredicate;
import com.sap.jvm.profiling.ui.graph.dataset.XYListValue2DStorage;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.geometry.Value2DExtended;
import com.sap.jvm.profiling.ui.graph.progress.RenderingAsyncProgress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LineGraphVirtualDataSet
extends LineGraphDataSet {
    private Value2DStorage storage;
    private Value2D lastVal;
    private LineGraphPresentationAdapter presentationAdapter;
    private static final int THRESHOLD = 5;

    public LineGraphVirtualDataSet(String name, String fileName) throws IOException {
        super(name);
        this.storage = new Value2DPersistanceList(fileName == null ? name + ".swp" : fileName);
    }

    private LineGraphVirtualDataSet(LineGraphVirtualDataSet set, long min, long max) {
        super(set.getName());
        this.presentationAdapter = set.presentationAdapter;
        this.storage = new Value2DPersistanceList((Value2DPersistanceList)set.storage, min, max);
        this.lastVal = this.storage.getValueAt(this.storage.getSize() - 1L);
    }

    public LineGraphVirtualDataSet(String name, XYListValue2DStorage storage) throws IOException {
        super(name);
        this.storage = storage;
        if (storage.getSize() > 0L) {
            this.lastVal = storage.getLastValue();
            this.checkMinMax(new Value2D(this.lastVal.x, storage.getMinY()));
            this.checkMinMax(new Value2D(this.lastVal.x, storage.getMaxY()));
        }
    }

    public void close() throws IOException {
        this.storage.close();
    }

    public void releaseReaders() {
        if (this.storage instanceof Value2DPersistanceList) {
            ((Value2DPersistanceList)this.storage).closeAllReadingIterators();
        }
    }

    public LineGraphVirtualDataSet getSetView(double min, double max) {
        return new LineGraphVirtualDataSet(this, this.storage.indexedBS(min), this.storage.indexedBS(max)){};
    }

    public void setPresentationAdapter(LineGraphPresentationAdapter adapter) {
        this.presentationAdapter = adapter;
    }

    @Override
    protected Value2D addValue(double x, double y, boolean emphasized, Object data) {
        Value2D newValue = new Value2D(x, y, emphasized);
        this.setData(newValue, data);
        if (this.lastVal != null && this.lastVal.x >= x) {
            this.storage.addSortedValue(newValue);
            this.lastVal = this.storage.getValueAt(this.storage.getSize() - 1L);
            return newValue;
        }
        this.storage.appendValue(newValue);
        this.lastVal = newValue;
        this.checkMinMax(newValue);
        return newValue;
    }

    @Override
    public long getSize() {
        return this.storage.getSize();
    }

    @Override
    public Iterator<Value2D> iterator() {
        return this.storage.iterator();
    }

    @Override
    public void dispose(Iterator<Value2D> iterator) {
        this.storage.disposeIterator(iterator);
    }

    @Override
    public void removeAllValues() {
        this.storage.removeAll();
        this.lastVal = null;
    }

    @Override
    public void removeLastValues(long removeCount) {
        this.storage.removeLast(removeCount);
        this.lastVal = this.storage.getSize() > 0L ? this.storage.getValueAt(this.storage.getSize() - 1L) : null;
    }

    @Override
    public Value2D getFirstValue() {
        return this.getValueAt(0L);
    }

    @Override
    public Value2D getLastValue() {
        return this.lastVal;
    }

    @Override
    public void setData(Value2D value, Object data) {
        this.storage.setData(value, data);
    }

    @Override
    public Object getData(Value2D value) {
        return this.storage.getData(value);
    }

    @Override
    public long getIndexOfXValue(double x) {
        if (this.isEmpty()) {
            return -1L;
        }
        return this.storage.indexedBS(x);
    }

    @Override
    public Value2D getValueAt(long idx) {
        if (this.isEmpty()) {
            return null;
        }
        return this.storage.getValueAt(idx);
    }

    @Override
    public double getYValueAt(double x) {
        if (this.isEmpty()) {
            return 0.0;
        }
        if (this.isEmpty() || this.getFirstValue().x > x || this.getLastValue().x < x) {
            return 0.0;
        }
        long idx = this.storage.indexedBS(x);
        if (idx + 1L == this.getSize()) {
            if (this.storage.getValueXAt(idx) == x) {
                return this.getValueAt((long)idx).y;
            }
            return 0.0;
        }
        Value2D v1 = this.getValueAt(idx + 1L);
        Value2D v2 = this.getValueAt(idx);
        if (v1.x == x) {
            return v1.y;
        }
        if (v2.x == x) {
            return v2.y;
        }
        double dy = (v2.y - v1.y) / (v2.x - v1.x);
        return v2.y + dy * (x - v2.x);
    }

    @Override
    public Value2D getNext(Value2D value) {
        throw new IllegalStateException("not supported operation!!!");
    }

    @Override
    public Value2D getPrevious(Value2D value) {
        throw new IllegalStateException("not supported operation!!!");
    }

    @Override
    public void removeFirstValues(long remove_count) {
        throw new IllegalStateException("not supported operation!!!");
    }

    @Override
    public void removeValue(double x_value, long remove_count) {
        throw new IllegalStateException("not supported operation!!!");
    }

    public void performSafeOperationAsync(Runnable task) {
        this.storage.performSafeOperationAsync(task);
    }

    public void performSafeOperationSync(Runnable task) {
        this.storage.performSafeOperationSync(task);
    }

    public double getVisibleYValueAt(double val) {
        return super.getYValueAt(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateVisibleSet(Iterator<Value2D> storageIterator, List<Value2DExtended> visibleSet, RenderingAsyncProgress.Progress progress, long stepSize, GraphAxisModel xAxis, int width) {
        if (this.storage.getSize() == 0L) {
            return;
        }
        try {
            Value2DExtended lastValue;
            if (this.presentationAdapter != null) {
                this.calculateVisibleSet2(storageIterator, visibleSet, progress, stepSize, xAxis, width);
                return;
            }
            Value2DExtended value2DExtended = lastValue = storageIterator.hasNext() ? new Value2DExtended(storageIterator.next()) : null;
            if (lastValue != null) {
                long lastValPos = this.getPixel(width, xAxis.getRange(), lastValue.x);
                int step = 1;
                int count = 1;
                visibleSet.add(lastValue);
                while (storageIterator.hasNext() && !progress.isCanceled()) {
                    Value2D val = storageIterator.next();
                    long valPos = this.getPixel(width, xAxis.getRange(), val.x);
                    if (lastValPos == valPos) {
                        lastValue.y += val.y;
                        if (count < 5) {
                            if (count == 4) {
                                lastValue.entry = lastValue.exit = val.y;
                            } else if (count == 1) {
                                lastValue.entry = lastValue.exit = val.y;
                            } else if (count == 2) {
                                lastValue.exit = val.y;
                            } else if (count == 3) {
                                lastValue.max = lastValue.min = lastValue.exit;
                                lastValue.exit = val.y;
                            } else {
                                if (lastValue.max < val.y) {
                                    lastValue.max = val.y;
                                } else if (lastValue.min > val.y) {
                                    lastValue.min = val.y;
                                }
                                lastValue.exit = val.y;
                            }
                        }
                        ++count;
                        if (val.emphasized) {
                            lastValue.emphasized = true;
                        }
                    } else {
                        lastValue.y /= (double)count;
                        lastValue = new Value2DExtended(val);
                        lastValPos = valPos;
                        count = 1;
                        visibleSet.add(lastValue);
                    }
                    if ((long)step++ != stepSize) continue;
                    progress.incWorked();
                    progress.updateUI();
                    step = 0;
                }
                lastValue.y /= (double)count;
            }
        }
        finally {
            this.storage.disposeIterator(storageIterator);
        }
    }

    private void calculateVisibleSet2(Iterator<Value2D> iterator, List<Value2DExtended> visibleSet, RenderingAsyncProgress.Progress progress, long stepSize, GraphAxisModel xAxis, int width) {
        Value2D firstValue;
        Value2D value2D = firstValue = iterator.hasNext() ? iterator.next() : null;
        if (firstValue != null) {
            long lastValPos = this.getPixel(width, xAxis.getRange(), firstValue.x);
            int step = 1;
            ArrayList<Value2D> pixelValues = new ArrayList<Value2D>();
            pixelValues.add(firstValue);
            boolean firstMarker = true;
            while (iterator.hasNext() && !progress.isCanceled()) {
                Value2D val = iterator.next();
                long valPos = this.getPixel(width, xAxis.getRange(), val.x);
                if (lastValPos == valPos) {
                    pixelValues.add(val);
                } else {
                    if (firstMarker) {
                        this.presentationAdapter.createFirstPixelValue(pixelValues, visibleSet);
                        firstMarker = false;
                    } else {
                        this.presentationAdapter.createPixelValue(pixelValues, visibleSet);
                    }
                    pixelValues = new ArrayList();
                    pixelValues.add(val);
                    lastValPos = valPos;
                }
                if ((long)step++ != stepSize) continue;
                progress.incWorked();
                progress.updateUI();
                step = 0;
            }
            this.presentationAdapter.createLastPixelValue(pixelValues, visibleSet);
        }
    }

    private long getPixel(int width, double range, double x) {
        return (long)((double)width / range * x);
    }

    private double getPixelValue(int width, double range, long pixel) {
        return (double)pixel / ((double)width / range);
    }

    long getOffset(final int width, final double range, double value, boolean low) {
        long pixel = this.getPixel(width, range, value);
        double val = this.getPixelValue(width, range, pixel);
        long offset = this.storage.indexedBS(val);
        if (low) {
            final long pixelToSearch = this.getPixel(width, range, this.storage.getValueXAt(offset));
            return this.storage.getLowest(offset, new XPredicate(){

                @Override
                public boolean applies(double x) {
                    return LineGraphVirtualDataSet.this.getPixel(width, range, x) == pixelToSearch;
                }
            });
        }
        if (offset + 1L < this.storage.getSize()) {
            final long pixelToSearch = this.getPixel(width, range, this.storage.getValueXAt(offset + 1L));
            return this.storage.getHighest(offset + 1L, new XPredicate(){

                @Override
                public boolean applies(double x) {
                    return LineGraphVirtualDataSet.this.getPixel(width, range, x) == pixelToSearch;
                }
            });
        }
        return offset - 1L;
    }

    public synchronized void rescaleVisibleSet(RenderingAsyncProgress.Progress progress, GraphAxisModel xAxis, int width, LineGraphRenderer.RenderingContext ctx) {
        if (xAxis == null) {
            throw new IllegalStateException("Missing the axis model!!!!");
        }
        ctx.resetVisibleSet();
        if (this.isEmpty()) {
            return;
        }
        long offset = this.getOffset(width, xAxis.getRange(), xAxis.getMin(), true);
        long valuesCount = this.getOffset(width, xAxis.getRange(), xAxis.getMax(), false) - offset;
        long stepSize = valuesCount / 30L;
        if (progress.isCanceled()) {
            return;
        }
        progress.beginTask(this.getName(), 30);
        progress.updateUI();
        if (this.storage.getSize() - 1L > offset && valuesCount > 0L) {
            this.calculateVisibleSet(this.storage.getChunkIterator(offset, valuesCount), ctx.getVisibleSet(), progress, stepSize, xAxis, width);
            if (progress.isCanceled()) {
                ctx.resetVisibleSet();
            }
        } else {
            ctx.resetVisibleSet();
        }
    }

    public synchronized void moveVisibleSet(GraphAxisModel xAxis, int width, boolean leftMoved, LineGraphRenderer.RenderingContext rCtx) {
        List<Value2DExtended> visibleSet = rCtx.getVisibleSet();
        if (leftMoved) {
            if (visibleSet.isEmpty() || xAxis.getMax() < visibleSet.get((int)0).x) {
                this.rescaleVisibleSet(RenderingAsyncProgress.Progress.NULL_PROGRESS, xAxis, width, rCtx);
            } else {
                long offset = this.getOffset(width, xAxis.getRange(), xAxis.getMin(), true);
                long valuesCount = this.getOffset(width, xAxis.getRange(), visibleSet.get((int)0).x, false) - offset;
                if (valuesCount > 0L) {
                    ArrayList<Value2DExtended> list = new ArrayList<Value2DExtended>();
                    this.calculateVisibleSet(this.storage.getChunkIterator(offset, valuesCount), list, RenderingAsyncProgress.Progress.NULL_PROGRESS, 0L, xAxis, width);
                    if (!list.isEmpty()) {
                        Value2D lastNew = (Value2D)list.get(list.size() - 1);
                        Value2D firstOld = visibleSet.get(0);
                        while (firstOld.x <= lastNew.x && !list.isEmpty()) {
                            list.remove(list.size() - 1);
                            if (list.isEmpty()) continue;
                            lastNew = (Value2D)list.get(list.size() - 1);
                        }
                        visibleSet.addAll(0, list);
                    }
                }
            }
        } else if (visibleSet.isEmpty() || xAxis.getMin() > visibleSet.get((int)(visibleSet.size() - 1)).x) {
            this.rescaleVisibleSet(RenderingAsyncProgress.Progress.NULL_PROGRESS, xAxis, width, rCtx);
        } else {
            long offset = this.getOffset(width, xAxis.getRange(), visibleSet.get((int)(visibleSet.size() - 1)).x, true);
            long valuesCount = this.getOffset(width, xAxis.getRange(), xAxis.getMax(), false) - offset;
            if (valuesCount > 0L) {
                ArrayList<Value2DExtended> list = new ArrayList<Value2DExtended>();
                this.calculateVisibleSet(this.storage.getChunkIterator(offset, valuesCount), list, RenderingAsyncProgress.Progress.NULL_PROGRESS, 0L, xAxis, width);
                if (!list.isEmpty()) {
                    Value2D lastOld = visibleSet.get(visibleSet.size() - 1);
                    Value2D firstNew = (Value2D)list.get(0);
                    while (lastOld.x >= firstNew.x && !visibleSet.isEmpty()) {
                        visibleSet.remove(visibleSet.size() - 1);
                        if (visibleSet.isEmpty()) continue;
                        lastOld = visibleSet.get(visibleSet.size() - 1);
                    }
                    visibleSet.addAll(list);
                }
            }
        }
        if (visibleSet.size() > 400) {
            if (!xAxis.isInRange(visibleSet.get((int)150).x)) {
                visibleSet.subList(0, 80).clear();
            }
            if (!xAxis.isInRange(visibleSet.get((int)(visibleSet.size() - 150)).x)) {
                visibleSet.subList(visibleSet.size() - 80, visibleSet.size()).clear();
            }
        }
    }

    public List<Value2DExtended> getEntireVisibleSet(RenderingAsyncProgress.Progress progress, int stepSize, GraphAxisModel xAxis, int width) {
        if (xAxis == null) {
            throw new IllegalStateException("Missing the axes model!!!!");
        }
        ArrayList<Value2DExtended> result = new ArrayList<Value2DExtended>();
        this.calculateVisibleSet(this.storage.iterator(), result, progress, stepSize, xAxis, width);
        return result;
    }

    public int determineStateChange(GraphAxisModel xAxisModel, Rectangle graphArea, LineGraphRenderer.RenderingContext rCtx) {
        double f;
        if (this.getAvgValuesToWidth(graphArea.width, xAxisModel) < (long)graphArea.width) {
            rCtx.resetVisibleSet();
            return rCtx.saveScreenState(this.getSize(), xAxisModel, graphArea, 0);
        }
        if (graphArea.width != rCtx.getScreenWidth()) {
            return rCtx.saveScreenState(this.getSize(), xAxisModel, graphArea, 1);
        }
        double range = xAxisModel.getRange() - rCtx.getXAxisRange();
        if (range != 0.0 && ((f = 100.0 / rCtx.getXAxisRange() * range) > 0.25 || f < -0.25)) {
            return rCtx.saveScreenState(this.getSize(), xAxisModel, graphArea, 2);
        }
        if (rCtx.getScreenState() == 0) {
            rCtx.resetVisibleSet();
            return rCtx.saveScreenState(this.getSize(), xAxisModel, graphArea, 0);
        }
        if (xAxisModel.getMin() < rCtx.getMinXValue()) {
            return rCtx.saveScreenState(this.getSize(), xAxisModel, graphArea, 3);
        }
        if (xAxisModel.getMin() > rCtx.getMinXValue()) {
            return rCtx.saveScreenState(this.getSize(), xAxisModel, graphArea, 4);
        }
        if (this.getSize() > rCtx.getDataSize()) {
            return rCtx.saveScreenState(this.getSize(), xAxisModel, graphArea, 5);
        }
        return -1;
    }

    private long getAvgValuesToWidth(int width, GraphAxisModel xAxisModel) {
        if (this.storage.getSize() == 0L) {
            return 0L;
        }
        long allPixels = this.getPixel(width, xAxisModel.getRange(), this.storage.getValueXAt(this.storage.getSize() - 1L)) - this.getPixel(width, xAxisModel.getRange(), this.storage.getValueXAt(0L));
        return Math.round((double)this.storage.getSize() / (double)allPixels * (double)width);
    }

    @Override
    public Iterable<Value2D> getValues(long fromIndex, long toIndex) {
        if (this.storage instanceof XYListValue2DStorage) {
            return ((XYListValue2DStorage)this.storage).getValues(fromIndex, toIndex);
        }
        return super.getValues(fromIndex, toIndex);
    }
}

