/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.dataset;

import com.sap.jvm.profiling.ui.graph.PieGraph;
import com.sap.jvm.profiling.ui.graph.dataset.DataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.ColorPool;
import com.sap.jvm.profiling.ui.graph.utils.PercentDistributionCalculator;
import java.util.ArrayList;

public class PieGraphDataSet
implements DataSet {
    public static final int DEFAULT_START_ANGLE = 45;
    public static final boolean DEFAULT_ROTATE_CW = false;
    private final ColorPool colPool = new ColorPool();
    private int startAngle = 45;
    private boolean rotateCW = false;
    private String name;
    private ArrayList<PiePiece> values = new ArrayList();
    private boolean inserted;
    private PieGraph.GraphType type = PieGraph.GraphType.Graph2D;
    private boolean fixedToolTips;
    private int percentDigits = -1;

    public PieGraphDataSet() {
        this(null);
    }

    public PieGraphDataSet(String name) {
        this.name = name;
        this.colPool.setDefinedStart(3, 0, 0, 3, 26, 12, 12);
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(int angle) {
        this.startAngle = angle;
        this.calculateAngles();
    }

    public void setPercentDigits(int percentDigits) {
        this.percentDigits = percentDigits;
    }

    public int getPercentDigits() {
        return this.percentDigits;
    }

    public void setRotateCW(boolean enabled) {
        this.rotateCW = enabled;
        this.calculateAngles();
    }

    public boolean getRotateCW() {
        return this.rotateCW;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public PieGraph.GraphType getGraphType() {
        return this.type;
    }

    public void set3DRepresentation(boolean enabled) {
        this.type = enabled ? PieGraph.GraphType.Graph3D : PieGraph.GraphType.Graph2D;
    }

    public void setFixedToolTips(boolean enabled) {
        this.fixedToolTips = enabled;
    }

    public boolean getFixedToolTips() {
        return this.fixedToolTips;
    }

    public boolean hasFixedTooltips() {
        return this.fixedToolTips;
    }

    public void changeName(String newName) {
        this.name = newName;
    }

    public int addValue(double value, String description) {
        this.values.add(new PiePiece(value, description, this.colPool.getNext()));
        this.inserted = true;
        return this.values.size() - 1;
    }

    public int addValue(double value, String description, Color color) {
        this.values.add(new PiePiece(value, description, color));
        this.inserted = true;
        return this.values.size() - 1;
    }

    public void updateValue(PiePiece piece, double newValue) {
        piece.value = newValue;
        this.calculateAngles();
    }

    public PiePiece getPiece(int idx) {
        if (this.inserted) {
            this.calculateAngles();
        }
        return this.values.get(idx);
    }

    public ArrayList<PiePiece> getPieces() {
        if (this.inserted) {
            this.calculateAngles();
        }
        return this.values;
    }

    public void clear() {
        this.values.clear();
    }

    private void calculateAngles() {
        if (!this.values.isEmpty()) {
            double angle = this.startAngle;
            int digits = this.percentDigits == -1 ? 2 : this.percentDigits;
            double summ = PercentDistributionCalculator.calculate(this.values, digits);
            PiePiece lastPiece = null;
            for (int pIdx = 0; pIdx < this.values.size(); ++pIdx) {
                PiePiece p = this.values.get(this.rotateCW ? this.values.size() - 1 - pIdx : pIdx);
                p.updateAngle(summ);
                p.piePositionAngle = angle;
                angle += p.angle;
                if (lastPiece != null) {
                    lastPiece.roundedAngle = p.getPiePositionAngle() - lastPiece.getPiePositionAngle();
                }
                lastPiece = p;
            }
            lastPiece.roundedAngle = 360 + this.startAngle - lastPiece.getPiePositionAngle();
        }
        this.inserted = false;
    }

    @Override
    public boolean isEmpty() {
        return this.values == null || this.values.size() == 0;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Pie: ");
        for (PiePiece p : this.values) {
            str.append('\n');
            str.append('[');
            str.append(p.piePositionAngle);
            str.append('/');
            str.append(p.angle);
            str.append(']');
            str.append(' ');
        }
        return str.toString();
    }

    public static class PiePiece
    implements PercentDistributionCalculator.PercentValue {
        private double value;
        private String name;
        private Color color;
        private Color dimColor;
        private double angle;
        private int roundedAngle;
        private double percent;
        private double piePositionAngle;
        private boolean selected;

        public PiePiece(double value, String name, Color color) {
            this.value = value;
            this.name = name;
            this.color = color;
            this.dimColor = new Color(this.dim(color.red), this.dim(color.green), this.dim(color.blue));
        }

        @Override
        public void updatePercent(double p) {
            this.percent = p;
        }

        private void updateAngle(double summ) {
            this.angle = summ == 0.0 ? 0.0 : 360.0 / summ * this.value;
        }

        private int dim(int val) {
            return val > 100 ? val - 100 : 0;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public Color getDimColor() {
            return this.dimColor;
        }

        public double getPercent() {
            return this.percent;
        }

        public int getAngle() {
            return this.roundedAngle;
        }

        public int getPiePositionAngle() {
            return (int)this.piePositionAngle;
        }

        public int getPieCenterAngle() {
            return (int)Math.round(this.piePositionAngle + this.angle / 2.0);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelection(boolean selection) {
            this.selected = selection;
        }
    }
}

