/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.dataset;

import com.sap.jvm.profiling.ui.graph.dataset.DataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Image;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RangeLineDataSet
implements DataSet,
Comparable<RangeLineDataSet> {
    private String name = "";
    private long startValue = 0L;
    private long endValue = 0L;
    private List<Range> ranges = new ArrayList<Range>();
    private List<TimeStamp> timeStamps = new ArrayList<TimeStamp>();
    private Set<RangeType> types = new HashSet<RangeType>();
    private Image icon;
    private Object data;

    public RangeLineDataSet(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    public RangeLineDataSet(String name, Image icon) {
        this(name);
        this.icon = icon;
    }

    public RangeLineDataSet(String name, long startValue) {
        this(name);
        this.startValue = startValue;
        this.endValue = startValue;
    }

    public RangeLineDataSet(String name, Image icon, long startValue) {
        this(name, startValue);
        this.icon = icon;
    }

    public static RangeType createType(String name, String description, Color color) {
        return new RangeType(name, description, color);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isEmpty() {
        if (this.ranges.isEmpty()) {
            return true;
        }
        for (Range range : this.ranges) {
            if (range.getType().isSpace()) continue;
            return false;
        }
        return true;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Image getIcon() {
        return this.icon;
    }

    public long getMinValue() {
        return this.startValue;
    }

    public long getMaxValue() {
        return this.endValue;
    }

    public void setStartValue(long value) {
        this.endValue = this.startValue = value;
        for (Range range : this.ranges) {
            range.min = this.endValue;
            this.endValue = range.max = this.endValue + range.min;
        }
    }

    public void setEndValue(long value) {
        if (value < this.startValue) {
            throw new IllegalArgumentException("The end value for the range line could not be less than the start value");
        }
        this.endValue = value;
    }

    public TimeStamp addTimeStamp(long value) {
        return this.addTimeStamp(value, Color.LIGHT_GRAY);
    }

    public TimeStamp addTimeStamp(long value, Color color) {
        return this.addTimeStamp(value, null, color);
    }

    public TimeStamp addTimeStamp(long value, String tooltip, Color color) {
        if (this.ranges.size() == 0 && this.timeStamps.size() == 0) {
            this.startValue = value - 10L;
            this.endValue = value + 10L;
        } else if (this.startValue > value) {
            this.startValue = value - 10L;
        } else if (this.endValue < value) {
            this.endValue = value + 10L;
        }
        TimeStamp stamp = new TimeStamp(value, tooltip, color);
        this.timeStamps.add(stamp);
        return stamp;
    }

    public void removeAllTimeStamps() {
        this.timeStamps.clear();
        if (this.ranges.size() == 0) {
            this.endValue = 0L;
            this.startValue = 0L;
        }
    }

    public void appendSpace(long space) {
        this.appendRange(space, RangeType.SPACE, null);
    }

    public void appendRange(long size, RangeType type, String tooltip) {
        this.ranges.add(new Range(this.endValue, this.endValue + size, type, tooltip));
        this.endValue += size;
        if (!this.types.contains(type)) {
            this.types.add(type);
        }
        this.updatePercentages();
    }

    public void appendRange(long size, RangeType type) {
        this.appendRange(size, type, null);
    }

    public void extendLastRange(long size) {
        if (size > 0L && this.ranges.size() > 0) {
            this.ranges.get((int)(this.ranges.size() - 1)).max += size;
            this.endValue += size;
            this.updatePercentages();
        }
    }

    private void updatePercentages() {
        double factor = 100.0 / (double)(this.ranges.get((int)(this.ranges.size() - 1)).max - this.startValue);
        Iterator<RangeType> i = this.types.iterator();
        while (i.hasNext()) {
            i.next().percentage = 0.0;
        }
        for (Range range : this.ranges) {
            range.percentage = factor * (double)range.size;
            RangeType rangeType = range.type;
            rangeType.percentage = rangeType.percentage + range.percentage;
        }
    }

    public Range getFirstRange() {
        return this.ranges.get(0);
    }

    public Range getLastRange() {
        return this.ranges.get(this.ranges.size() - 1);
    }

    public Range getRange(int idx) {
        return this.ranges.get(idx);
    }

    public int getRangeCount() {
        return this.ranges.size();
    }

    public List<Range> getAllRanges() {
        return this.ranges;
    }

    public List<TimeStamp> getAllTimeStamps() {
        return this.timeStamps;
    }

    public RangeType[] getTypes() {
        return this.types.toArray(new RangeType[this.types.size()]);
    }

    public void clear() {
        this.endValue = 0L;
        this.startValue = 0L;
        this.ranges.clear();
        this.timeStamps.clear();
    }

    @Override
    public int compareTo(RangeLineDataSet o) {
        return this.name.compareTo(o.name);
    }

    public static class TimeStamp {
        private long value;
        private Color color;
        private Color border;
        private String tooltip = null;
        private Object data;

        public TimeStamp(long value, Color color) {
            this.value = value;
            this.color = color;
            this.border = Color.darker(color);
        }

        public TimeStamp(long value, String tooltip, Color color) {
            this(value, color);
            this.tooltip = tooltip;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public long getValue() {
            return this.value;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public Color getColor() {
            return this.color;
        }

        public Color getBorderColor() {
            return this.border;
        }
    }

    public static class RangeType {
        static final RangeType SPACE = new RangeType();
        private double percentage = 0.0;
        private String name = "space";
        private String description = "";
        private Color color = Color.WHITE;
        private Color borderColor = Color.darker(this.color);

        private RangeType() {
        }

        private RangeType(String name, String description, Color color) {
            this.name = name;
            this.description = description;
            this.color = color;
            this.borderColor = Color.darker(color);
        }

        public void mixColor(Color mixColor) {
            this.color = Color.mix(this.color, mixColor);
            this.borderColor = Color.darker(this.color);
        }

        public void setColor(Color newColor) {
            this.color = newColor;
            this.borderColor = Color.darker(this.color);
        }

        public Color getColor() {
            return this.color;
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public double getPercentage() {
            return this.percentage;
        }

        public boolean isSpace() {
            return this == SPACE;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RangeType) {
                RangeType type = (RangeType)obj;
                return type.name.equals(this.name) && type.description.equals(this.description);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.description.hashCode();
        }
    }

    public static class Range {
        protected long min;
        protected long max;
        protected long size;
        double percentage;
        protected RangeType type;
        private String tooltip;

        public Range(long min, long max, RangeType type) {
            this(min, max, type, null);
        }

        public Range(long min, long max, RangeType type, String tooltip) {
            this.min = min;
            this.max = max;
            this.size = max - min;
            this.type = type;
            this.tooltip = tooltip;
        }

        public long getMinValue() {
            return this.min;
        }

        public long getMaxValue() {
            return this.max;
        }

        public long getSize() {
            return this.size;
        }

        public double getPercentage() {
            return this.percentage;
        }

        public RangeType getType() {
            return this.type;
        }

        public String getToolTip() {
            return this.tooltip;
        }
    }
}

