/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.dataset;

import com.sap.jvm.profiling.ui.graph.dataset.RangeLineDataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Image;

public class RangeLineTableDataSet
extends RangeLineDataSet {
    private TableGroup tableGroup;
    private String[] values;
    private Image[] images;

    public RangeLineTableDataSet(String name, TableGroup group) {
        super(name);
        this.assignGroup(group);
    }

    public RangeLineTableDataSet(String name, TableGroup group, Image icon, long startValue) {
        super(name, icon, startValue);
        this.assignGroup(group);
    }

    public RangeLineTableDataSet(String name, TableGroup group, Image icon) {
        super(name, icon);
        this.assignGroup(group);
    }

    public RangeLineTableDataSet(String name, TableGroup group, long startValue) {
        super(name, startValue);
        this.assignGroup(group);
    }

    public void addValue(int column, String text) {
        if (column == 0) {
            this.setName(text);
        } else if (column > this.tableGroup.getColumnCount() | column < 0) {
            throw new IllegalStateException("The specified value column [" + column + "] is out of bounds!");
        }
        this.values[column] = text;
        this.images[column] = null;
    }

    public void addValue(int column, String text, Image img) {
        this.addValue(column, text);
        this.images[column] = img;
    }

    public String getValue(int column) {
        return column >= this.values.length ? null : this.values[column];
    }

    public Image getIcon(int column) {
        return column >= this.values.length ? null : this.images[column];
    }

    public TableGroup getGroup() {
        return this.tableGroup;
    }

    private void assignGroup(TableGroup group) {
        this.tableGroup = group;
        this.values = new String[this.tableGroup.getColumnCount()];
        this.images = new Image[this.values.length];
        this.images[0] = this.getIcon();
        this.values[0] = this.getName();
    }

    public static class TableGroup {
        private int columns;
        private String[] columnNames;
        private Image[] columnImages;
        private RangeLineDataSet data;
        private Align[] headerAligns;
        private Align[] aligns;

        public TableGroup(int columns) {
            this.columns = columns;
            this.columnNames = new String[this.columns];
            this.columnImages = new Image[this.columns];
            this.aligns = new Align[this.columns];
            this.headerAligns = new Align[this.columns];
            for (int i = 0; i < this.columns; ++i) {
                this.headerAligns[i] = Align.CENTER;
                this.aligns[i] = Align.LEFT;
            }
        }

        public TableGroup(String[] columns) {
            this(columns.length);
            System.arraycopy(columns, 0, this.columnNames, 0, columns.length);
        }

        public int getColumnCount() {
            return this.columns;
        }

        public String getColumnName(int idx) {
            return idx >= this.columnNames.length ? null : this.columnNames[idx];
        }

        public void setColumnName(int idx, String name) {
            if (idx < this.columns) {
                this.columnNames[idx] = name;
            }
        }

        public Image getColumnImage(int idx) {
            return idx >= this.columns ? null : this.columnImages[idx];
        }

        public void setColumnImage(int idx, Image img) {
            if (idx < this.columns) {
                this.columnImages[idx] = img;
            }
        }

        public void setColumnAlignment(int column, Align alignment) {
            this.aligns[column] = alignment;
        }

        public void setColumnHeaderAlignment(int column, Align alignment) {
            this.headerAligns[column] = alignment;
        }

        public Align getColumnAlignment(int column) {
            return column < this.columns ? this.aligns[column] : null;
        }

        public Align getColumnHeaderAlignment(int column) {
            return column < this.columns ? this.headerAligns[column] : null;
        }

        public void setRangeLine(RangeLineDataSet data) {
            this.data = data;
        }

        public RangeLineDataSet getRangeLine() {
            return this.data;
        }

        public static enum Align {
            CENTER,
            LEFT,
            RIGHT;

        }
    }
}

