/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.dataset;

import com.sap.jvm.profiling.ui.graph.dataset.DataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.ColorPool;
import java.util.ArrayList;
import java.util.List;

public class SingeBarDataSet
implements DataSet {
    protected static final ColorPool COLORS = ColorPool.getPool();
    private String descr;
    private String name;
    private Color color = COLORS.getNext();
    private Color borderColor;
    private long max;
    private long value;
    private double percent;
    private String toolTip;
    private String inlinedTextPattern = "{0} %";
    private List<ValueMarker> markers = new ArrayList<ValueMarker>();
    private List<Long> valueSelection = new ArrayList<Long>();
    private List<Long> valueHighlights = new ArrayList<Long>();
    private Color backgroundHighlightColor = Color.DARK_GRAY;
    private Color selectionColor = Color.BLUE;

    public Color getColor() {
        return this.color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    public void setValueBackgroundHighlightColor(Color color) {
        this.backgroundHighlightColor = color;
    }

    public Color getValueBackgroundHighlightColor() {
        return this.backgroundHighlightColor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setToolTip(String tip) {
        this.toolTip = tip;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setInlinedText(String pattern) {
        boolean showPercent = pattern != null && pattern.trim().length() > 0;
        this.inlinedTextPattern = showPercent ? pattern : null;
    }

    public String getInlinedText() {
        return this.inlinedTextPattern;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public void setMaxValue(long max) {
        this.max = max > 0L ? max : 1L;
    }

    public void setValue(long value) {
        this.value = value < 0L ? 0L : (value > this.max ? this.max : value);
        this.percent = 100.0 / (double)this.max * (double)value;
        if (this.percent > 100.0) {
            this.percent = 100.0;
        }
    }

    public long getValue() {
        return this.value;
    }

    public double getPercent() {
        return this.percent;
    }

    public long getMaxValue() {
        return this.max;
    }

    public void setValueDescription(String descr) {
        this.descr = descr;
    }

    public String getValueDescription() {
        return this.descr;
    }

    public ValueMarker setValueMarker(long value, String description) {
        return this.setValueMarker(value, description, Color.RED);
    }

    public ValueMarker setValueMarker(long value, String description, Color color) {
        if (value >= 0L && value <= this.max) {
            ValueMarker result = new ValueMarker(description, value, color);
            this.markers.add(result);
            return result;
        }
        return null;
    }

    public void setSelectedValueMarker(int idx) {
        try {
            this.markers.get(idx).setSelected(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resetMarkerSelection() {
        for (ValueMarker m : this.markers) {
            m.setSelected(false);
        }
    }

    public boolean setValueSelection(long val) {
        if (val >= 0L && val <= this.max) {
            this.valueSelection.add(val);
            return true;
        }
        return false;
    }

    public void resetValueSelection() {
        this.valueSelection.clear();
    }

    public List<ValueMarker> getValueMarkers() {
        return this.markers;
    }

    public List<Long> getValueSelection() {
        return this.valueSelection;
    }

    public boolean highlightValue(long val) {
        if (val >= 0L && val <= this.max) {
            this.valueHighlights.add(val);
            return true;
        }
        return false;
    }

    public List<Long> getValueHighlights() {
        return this.valueHighlights;
    }

    static {
        COLORS.setRandomStart();
    }

    public static class ValueMarker {
        private String description;
        private long value;
        private Color color = Color.RED;
        private boolean selected;

        private ValueMarker(String description, long value, Color color) {
            this.description = description;
            this.value = value;
            this.color = color;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

