/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.dataset;

import com.sap.jvm.profiling.ui.graph.dataset.Value2DStorage;
import com.sap.jvm.profiling.ui.graph.dataset.XPredicate;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.tracing.Trace;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Value2DPersistanceList
implements Value2DStorage {
    private static final int DOUBLE_SIZE = 8;
    private static final int VALUE_SIZE = 17;
    private static final int CHUNK_COUNT = 1000;
    private File baseFile;
    private RandomAccessFile raFile;
    private Value2D[] valueBuffer = new Value2D[1000];
    private int bufferPointer = 0;
    private byte[] flushBuffer = new byte[17000];
    private int size = 0;
    private long sizeInBytes = 0L;
    private Set<ListChunkIteratorImpl> iteratorBuffer = Collections.synchronizedSet(new HashSet(100));
    private ListView view;
    private SafeOpDispacher safeOpDispacher = new SafeOpDispacher();
    private Map<String, Object> dataMap = new HashMap<String, Object>();

    public Value2DPersistanceList(String filePath) throws IOException {
        this.baseFile = new File(filePath);
        this.raFile = new RandomAccessFile(this.baseFile, "rw");
        this.raFile.seek(0L);
        this.raFile.setLength(0L);
    }

    public Value2DPersistanceList(Value2DPersistanceList list, long min, long max) {
        if (min < 0L || min > list.getSize() || max < 0L || max < min || max > list.getSize()) {
            throw new IllegalArgumentException("Illegal view borders defined! " + min + "/" + max + " list size=" + list.getSize());
        }
        this.view = new ListView(list, min, max);
        this.dataMap = list.dataMap;
    }

    private void checkListView() {
        if (this.view != null) {
            throw new IllegalStateException("Invalid operation on the persistent list view!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllReadingIterators() {
        this.checkListView();
        Object object = this.safeOpDispacher.LOCK;
        synchronized (object) {
            for (ListChunkIteratorImpl i : this.iteratorBuffer) {
                try {
                    i.close();
                }
                catch (IOException iOException) {}
            }
            this.iteratorBuffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.checkListView();
        Object object = this.safeOpDispacher.LOCK;
        synchronized (object) {
            RandomAccessFile tmpFile = this.raFile;
            this.raFile = null;
            this.bufferPointer = 0;
            this.size = 0;
            if (tmpFile != null) {
                tmpFile.close();
            }
            for (ListChunkIteratorImpl i : this.iteratorBuffer) {
                try {
                    i.close();
                }
                catch (IOException iOException) {}
            }
            this.iteratorBuffer.clear();
        }
    }

    @Override
    public void appendValue(Value2D val) {
        this.checkListView();
        if (this.raFile != null) {
            try {
                if (this.bufferPointer == this.valueBuffer.length) {
                    this.flushBuffer();
                }
                this.valueBuffer[this.bufferPointer++] = val;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addSortedValue(Value2D newValue) {
        this.checkListView();
        if (this.raFile != null) {
            this.flushBuffer();
            long insertIdx = this.indexedBS(newValue.x);
            if (insertIdx > 0L || this.getValueXAt(0L) < newValue.x) {
                ++insertIdx;
            }
            long tail = this.getSize() - insertIdx;
            try {
                byte[] bytes = new byte[17];
                Value2D tmpVal = newValue;
                int i = 0;
                while ((long)i <= tail) {
                    long idx = insertIdx + (long)i;
                    if (idx == this.getSize()) {
                        this.appendValue(tmpVal);
                    } else {
                        Value2D val = this.getValueAt(idx);
                        this.raFile.seek(idx * 17L);
                        Value2DPersistanceList.writeValue(bytes, 0, tmpVal);
                        this.raFile.write(bytes);
                        tmpVal = val;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void removeAll() {
        this.checkListView();
        if (this.raFile != null) {
            this.bufferPointer = 0;
            this.size = 0;
            this.sizeInBytes = 0L;
            try {
                this.raFile.setLength(0L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void removeLast() {
        this.checkListView();
        this.removeLast(1L);
    }

    @Override
    public void removeLast(long count) {
        this.checkListView();
        if (this.raFile != null) {
            this.flushBuffer();
            this.sizeInBytes = count >= this.getSize() ? 0L : this.sizeInBytes - 17L * count;
            this.size = (int)(this.sizeInBytes / 17L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() {
        if (this.bufferPointer > 0) {
            RandomAccessFile randomAccessFile = this.raFile;
            synchronized (randomAccessFile) {
                int offset = 0;
                for (int i = 0; i < this.bufferPointer; ++i) {
                    Value2DPersistanceList.writeValue(this.flushBuffer, offset, this.valueBuffer[i]);
                    offset += 17;
                }
                int writtenSize = this.bufferPointer * 17;
                this.bufferPointer = 0;
                try {
                    this.raFile.seek(this.sizeInBytes);
                    this.raFile.write(this.flushBuffer, 0, writtenSize);
                    this.sizeInBytes += (long)writtenSize;
                    this.size = (int)(this.sizeInBytes / 17L);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        if (this.view != null) {
            return this.view.getSize();
        }
        Object object = this.safeOpDispacher.LOCK;
        synchronized (object) {
            return this.size + this.bufferPointer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value2D getValueAt(long idx) {
        if (this.view != null) {
            return this.view.getValueAt(idx);
        }
        Object object = this.safeOpDispacher.LOCK;
        synchronized (object) {
            if (this.raFile != null) {
                this.check(idx);
                this.flushBuffer();
                try {
                    this.raFile.seek(17L * idx);
                    byte[] rawValue = new byte[17];
                    int length = this.raFile.read(rawValue);
                    if (length == -1) {
                        return null;
                    }
                    if (length < 17) {
                        for (int i = length - 1; i < 17; ++i) {
                            rawValue[i] = (byte)this.raFile.read();
                        }
                    }
                    return Value2DPersistanceList.readValue(rawValue, 0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getValueXAt(long idx) {
        if (this.view != null) {
            return this.view.getValueXAt(idx);
        }
        Object object = this.safeOpDispacher.LOCK;
        synchronized (object) {
            if (this.raFile != null) {
                this.check(idx);
                this.flushBuffer();
                return this.getXAt(idx);
            }
            return 0.0;
        }
    }

    private double getXAt(long idx) {
        if (this.view != null) {
            return this.view.getXAt(idx);
        }
        try {
            this.raFile.seek(17L * idx);
            byte[] rawValue = new byte[8];
            int length = this.raFile.read(rawValue);
            if (length == -1) {
                return 0.0;
            }
            if (length < 8) {
                for (int i = length - 1; i < 8; ++i) {
                    rawValue[i] = (byte)this.raFile.read();
                }
            }
            return Value2DPersistanceList.readDouble(rawValue, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private void check(long idx) {
        if (idx < 0L || idx >= this.getSize()) {
            throw new IndexOutOfBoundsException("Invalid list index [" + idx + "] list size [" + this.getSize() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long indexedBS(double x) {
        if (this.view != null) {
            return this.view.indexedBS(x);
        }
        Object object = this.safeOpDispacher.LOCK;
        synchronized (object) {
            if (this.raFile != null) {
                this.flushBuffer();
                long low = 0L;
                long high = this.getSize() - 1L;
                while (low <= high) {
                    long mid = low + high >> 1;
                    double midVal = this.getXAt(mid);
                    double cmp = midVal - x;
                    if (cmp < 0.0) {
                        low = mid + 1L;
                        continue;
                    }
                    if (cmp > 0.0) {
                        high = mid - 1L;
                        continue;
                    }
                    return mid;
                }
                return low == 0L ? 0L : low - 1L;
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Value2D> getChunkIterator(long elementOffset, long elements) {
        if (this.view != null) {
            return this.view.getChunkIterator(elementOffset, elements);
        }
        Object object = this.safeOpDispacher.LOCK;
        synchronized (object) {
            if (this.raFile != null) {
                this.flushBuffer();
                if (elementOffset < 0L || elements + elementOffset > this.getSize()) {
                    throw new IllegalArgumentException("Invalid Parameters offset= " + elementOffset + " elements= " + elements + "list size = " + this.getSize());
                }
                try {
                    ListChunkIteratorImpl iterator = new ListChunkIteratorImpl(this.baseFile, this.sizeInBytes, elementOffset, elements);
                    this.iteratorBuffer.add(iterator);
                    this.safeOpDispacher.blockSafeOPs();
                    return iterator;
                }
                catch (IOException e) {
                    Trace.error((Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Value2D> iterator() {
        if (this.view != null) {
            return this.view.iterator();
        }
        Object object = this.safeOpDispacher.LOCK;
        synchronized (object) {
            if (this.raFile != null) {
                this.flushBuffer();
                try {
                    ListChunkIteratorImpl iterator = new ListChunkIteratorImpl(this.baseFile, this.sizeInBytes, 0L, -1L);
                    this.iteratorBuffer.add(iterator);
                    this.safeOpDispacher.blockSafeOPs();
                    return iterator;
                }
                catch (IOException e) {
                    Trace.error((Throwable)e);
                }
            }
            return null;
        }
    }

    @Override
    public void disposeIterator(Iterator<Value2D> iterator) {
        if (this.iteratorBuffer.contains(iterator)) {
            this.iteratorBuffer.remove(iterator);
            try {
                ((ListChunkIteratorImpl)iterator).close();
            }
            catch (IOException e) {
                Trace.error((Throwable)e);
            }
        }
    }

    @Override
    public void performSafeOperationAsync(Runnable task) {
        this.safeOpDispacher.performSafe(task, true);
    }

    @Override
    public void performSafeOperationSync(Runnable task) {
        this.safeOpDispacher.performSafe(task, false);
    }

    private static void writeValue(byte[] out, int offset, Value2D value) {
        Value2DPersistanceList.writeDouble(out, offset, value.x);
        Value2DPersistanceList.writeDouble(out, offset + 8, value.y);
        Value2DPersistanceList.writeBoolean(out, offset + 16, value.emphasized);
    }

    private static Value2D readValue(byte[] in, int offset) {
        return new Value2D(Value2DPersistanceList.readDouble(in, offset), Value2DPersistanceList.readDouble(in, offset + 8), Value2DPersistanceList.readBoolean(in, offset + 16));
    }

    private static void writeDouble(byte[] out, int offset, double value) {
        long val = Double.doubleToLongBits(value);
        out[offset] = (byte)(val >>> 56 & 0xFFL);
        out[offset + 1] = (byte)(val >>> 48 & 0xFFL);
        out[offset + 2] = (byte)(val >>> 40 & 0xFFL);
        out[offset + 3] = (byte)(val >>> 32 & 0xFFL);
        out[offset + 4] = (byte)(val >>> 24 & 0xFFL);
        out[offset + 5] = (byte)(val >>> 16 & 0xFFL);
        out[offset + 6] = (byte)(val >>> 8 & 0xFFL);
        out[offset + 7] = (byte)(val >>> 0 & 0xFFL);
    }

    private static double readDouble(byte[] in, int offset) {
        long bits = ((long)in[offset] << 56) + ((long)(in[offset + 1] & 0xFF) << 48) + ((long)(in[offset + 2] & 0xFF) << 40) + ((long)(in[offset + 3] & 0xFF) << 32) + ((long)(in[offset + 4] & 0xFF) << 24) + (long)((in[offset + 5] & 0xFF) << 16) + (long)((in[offset + 6] & 0xFF) << 8) + (long)((in[offset + 7] & 0xFF) << 0);
        return Double.longBitsToDouble(bits);
    }

    private static void writeBoolean(byte[] out, int offset, boolean value) {
        out[offset] = (byte)(value ? 1 : 0);
    }

    private static boolean readBoolean(byte[] in, int offset) {
        return in[offset] == 1;
    }

    @Override
    public long getLowest(long start, XPredicate predicate) {
        long result;
        for (result = start; result > 0L && predicate.applies(this.getValueXAt(result)); --result) {
        }
        return result + 1L;
    }

    @Override
    public long getHighest(long start, XPredicate predicate) {
        long result;
        for (result = start; result < this.getSize() && predicate.applies(this.getValueXAt(result)); ++result) {
        }
        return result - 1L;
    }

    @Override
    public void setData(Value2D value, Object data) {
        if (data != null) {
            StringBuilder key = new StringBuilder();
            key.append(value.x);
            key.append(value.y);
            key.append(value.emphasized);
            this.dataMap.put(key.toString(), data);
        }
    }

    @Override
    public Object getData(Value2D value) {
        StringBuilder key = new StringBuilder();
        key.append(value.x);
        key.append(value.y);
        key.append(value.emphasized);
        return this.dataMap.get(key.toString());
    }

    private static class SafeOpDispacher {
        private final Object LOCK = new Object();
        private final Object TASKS_LOCK = new Object();
        private int blockCounter = 0;
        private boolean block = false;

        private SafeOpDispacher() {
        }

        private void performSafe(final Runnable task, boolean async) {
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = LOCK;
                    synchronized (object) {
                        while (block) {
                            try {
                                LOCK.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        Object object2 = TASKS_LOCK;
                        synchronized (object2) {
                            try {
                                task.run();
                            }
                            catch (Throwable th) {
                                Trace.error((Throwable)th);
                            }
                        }
                    }
                }
            };
            if (async) {
                new Thread(run).start();
            } else {
                run.run();
            }
        }

        private void blockSafeOPs() {
            this.block = true;
            ++this.blockCounter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseSafeOPs() {
            Object object = this.LOCK;
            synchronized (object) {
                --this.blockCounter;
                if (this.blockCounter == 0) {
                    this.block = false;
                    this.LOCK.notifyAll();
                }
            }
        }
    }

    private class ListChunkIteratorImpl
    implements Iterator<Value2D> {
        private RandomAccessFile file;
        private byte[] inBuffer = new byte[17000];
        private int bufferSize;
        private int iterator = 0;
        private long redElements;
        private long readSize;
        private boolean endOfFile;
        boolean closed;

        private ListChunkIteratorImpl(File file, long size, long offset, long readSize) throws IOException {
            this.file = new RandomAccessFile(file, "r");
            this.redElements = 0L;
            this.readSize = readSize == -1L ? (long)((int)(size / 17L)) : readSize;
            this.file.seek(offset * 17L);
            this.endOfFile = !this.readBuffer();
        }

        public void close() throws IOException {
            this.closed = true;
            this.file.close();
            Value2DPersistanceList.this.safeOpDispacher.releaseSafeOPs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readBuffer() throws IOException {
            if (!this.closed) {
                RandomAccessFile randomAccessFile = this.file;
                synchronized (randomAccessFile) {
                    int length = this.file.read(this.inBuffer);
                    if (length == -1) {
                        return false;
                    }
                    if (length == 0) {
                        this.bufferSize = 0;
                        return true;
                    }
                    int rest = length % 17;
                    if (rest > 0) {
                        this.file.seek(this.file.getFilePointer() - (long)rest);
                        this.bufferSize = (length - rest) / 17;
                    } else {
                        this.bufferSize = length / 17;
                    }
                    this.iterator = 0;
                    return true;
                }
            }
            return false;
        }

        private void checkBuffer() throws IOException {
            if (this.iterator == this.bufferSize) {
                do {
                    boolean bl = this.endOfFile = !this.readBuffer();
                } while (!this.endOfFile && this.bufferSize == 0);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                this.checkBuffer();
                return this.redElements < this.readSize && !this.endOfFile;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public Value2D next() {
            Value2D val;
            try {
                this.checkBuffer();
                val = Value2DPersistanceList.readValue(this.inBuffer, this.iterator * 17);
                ++this.iterator;
                ++this.redElements;
                if (this.redElements == this.readSize) {
                    Value2DPersistanceList.this.iteratorBuffer.remove(this);
                    this.close();
                }
            }
            catch (IOException e) {
                val = null;
                e.printStackTrace();
            }
            return val;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("NO Remove!!!!");
        }
    }

    private static class ListView {
        long min;
        long size;
        Value2DPersistanceList list;

        public ListView(Value2DPersistanceList list, long min, long max) {
            this.list = list;
            this.min = min;
            this.size = max - min;
        }

        public Iterator<Value2D> iterator() {
            return this.list.getChunkIterator(this.min, this.size);
        }

        public Iterator<Value2D> getChunkIterator(long elementOffset, long elements) {
            this.check(elementOffset);
            this.check(elementOffset + elements);
            return this.list.getChunkIterator(this.min + elementOffset, elements);
        }

        public long getSize() {
            return this.size;
        }

        public Value2D getValueAt(long idx) {
            this.check(idx);
            return this.list.getValueAt(this.min + idx);
        }

        public double getValueXAt(long idx) {
            this.check(idx);
            return this.list.getValueXAt(this.min + idx);
        }

        public double getXAt(long idx) {
            this.check(idx);
            return this.list.getXAt(this.min + idx);
        }

        public long indexedBS(double x) {
            long low = 0L;
            long high = this.getSize() - 1L;
            while (low <= high) {
                long mid = low + high >> 1;
                double midVal = this.getXAt(mid);
                double cmp = midVal - x;
                if (cmp < 0.0) {
                    low = mid + 1L;
                    continue;
                }
                if (cmp > 0.0) {
                    high = mid - 1L;
                    continue;
                }
                return mid;
            }
            return low == 0L ? 0L : low - 1L;
        }

        private void check(long idx) {
            if (idx < 0L || idx > this.size - 1L) {
                throw new IndexOutOfBoundsException("out of bounds ! idx=" + idx + " list size=" + this.getSize());
            }
        }
    }
}

