/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.dataset;

import com.sap.jvm.profiling.ui.graph.dataset.DataSet;
import com.sap.jvm.profiling.ui.graph.dataset.Value2DSet;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.legend.LegendItem;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class XYGraphDataSet
implements DataSet,
Value2DSet,
LegendItem {
    protected List<Value2D> values = new ArrayList<Value2D>();
    private Map<Value2D, Object> value_data = new HashMap<Value2D, Object>();
    private String name;
    private double min;
    private double max;
    private Color cl_graph = Color.getRandomColor();

    protected XYGraphDataSet(String name) {
        this.name = name;
        this.resetMinMax();
    }

    protected final void resetMinMax() {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
    }

    protected final void checkMinMax(Value2D val) {
        this.min = Math.min(this.min, val.y);
        this.max = Math.max(this.max, val.y);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setData(Value2D value, Object data) {
        this.value_data.put(value, data);
    }

    public Object getData(Value2D value) {
        return this.value_data.get(value);
    }

    public XYGraphDataSet[] getCombinedItems() {
        return null;
    }

    @Override
    public Iterator<Value2D> iterator() {
        return new ArrayList<Value2D>(this.values).iterator();
    }

    @Override
    public void dispose(Iterator<Value2D> iterator) {
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() < 1L;
    }

    @Override
    public long getSize() {
        return this.values.size();
    }

    public double getMinY() {
        return this.isEmpty() ? 0.0 : this.min;
    }

    public double getMaxY() {
        return this.isEmpty() ? 0.0 : this.max;
    }

    public double getMinX() {
        return this.isEmpty() ? 0.0 : this.getFirstValue().x;
    }

    public double getMaxX() {
        return this.isEmpty() ? 0.0 : this.getLastValue().x;
    }

    public void removeAllValues() {
        this.values.clear();
        this.value_data.clear();
        this.resetMinMax();
    }

    public Value2D getValueAt(long idx) {
        return this.values.get((int)idx);
    }

    public Value2D getFirstValue() {
        return this.values.size() > 0 ? this.values.get(0) : null;
    }

    public Value2D getLastValue() {
        return this.values.size() > 0 ? this.values.get(this.values.size() - 1) : null;
    }

    public boolean isXIn(double x) {
        return !this.isEmpty() && this.getFirstValue().x < x && this.getLastValue().x > x;
    }

    public double getYValueAt(double x) {
        if (this.values.isEmpty() || this.values.get((int)0).x > x || this.values.get((int)(this.values.size() - 1)).x < x) {
            return 0.0;
        }
        int idx = this.indexedBS(this.values, x);
        if (idx + 1 >= this.values.size()) {
            if (this.values.get((int)idx).x == x) {
                return this.values.get((int)idx).y;
            }
            return 0.0;
        }
        Value2D v1 = this.values.get(idx + 1);
        Value2D v2 = this.values.get(idx);
        if (v1.x == x) {
            return v1.y;
        }
        if (v2.x == x) {
            return v2.y;
        }
        double dy = (v2.y - v1.y) / (v2.x - v1.x);
        return v2.y + dy * (x - v2.x);
    }

    public long getIndexOfXValue(double x) {
        if (this.values.isEmpty()) {
            return -1L;
        }
        return this.indexedBS(this.values, x);
    }

    private int indexedBS(List<Value2D> list, double x) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Value2D midVal = list.get(mid);
            double cmp = midVal.x - x;
            if (cmp < 0.0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0.0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low == 0 ? 0 : low - 1;
    }

    public void setGraphColor(Color color) {
        this.cl_graph = color;
    }

    public final Color getGraphColor() {
        return this.cl_graph;
    }

    public abstract GraphType getType();

    @Override
    public Color getItemColor() {
        return this.getGraphColor();
    }

    @Override
    public String getItemText() {
        return this.getName();
    }

    @Override
    public boolean isSeparatorItem() {
        return false;
    }

    public static enum GraphType {
        SIMPLE,
        EMPHASIZED,
        COMBINED,
        COLORED;

    }
}

