/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.dataset;

import com.sap.jvm.profiling.ui.graph.dataset.Value2DStorage;
import com.sap.jvm.profiling.ui.graph.dataset.XPredicate;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.util.dataset.XLongPredicate;
import com.sap.jvm.profiling.util.dataset.XYList;
import com.sap.jvm.profiling.util.dataset.XYListIterator;
import com.sap.jvm.util.threads.ThreadRunner;
import java.io.IOException;
import java.util.Iterator;

public class XYListValue2DStorage
implements Value2DStorage {
    private final XYList list;
    private final long xOffset;
    private final double minY;
    private final double maxY;

    public XYListValue2DStorage(XYList list) {
        this.list = list;
        this.xOffset = 0L;
        this.minY = list.getMinY();
        this.maxY = list.getMaxY();
    }

    public XYListValue2DStorage(XYList list, long xOffset, double minY, double maxY) {
        this.list = list;
        this.xOffset = xOffset;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public void appendValue(Value2D val) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void addSortedValue(Value2D newValue) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void removeAll() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void removeLast() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void removeLast(long count) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public long getSize() {
        return this.list.getSize();
    }

    @Override
    public Value2D getValueAt(long idx) {
        return new Value2D(this.xToVx(this.list.getX((int)idx)), this.list.getY((int)idx), this.list.isEmphasized((int)idx));
    }

    @Override
    public double getValueXAt(long idx) {
        return this.xToVx(this.list.getX((int)idx));
    }

    @Override
    public long indexedBS(double x) {
        return this.list.getIndexOfX(this.vxToX(x));
    }

    @Override
    public Iterator<Value2D> getChunkIterator(long elementOffset, long elements) {
        return new IteratorAdapter(this.list.getIterator((int)elementOffset, (int)(elementOffset + elements - 1L)));
    }

    @Override
    public Iterator<Value2D> iterator() {
        return new IteratorAdapter(this.list.getIterator(0, (int)(this.getSize() - 1L)));
    }

    @Override
    public void disposeIterator(Iterator<Value2D> iterator) {
        ((IteratorAdapter)iterator).close();
    }

    @Override
    public void performSafeOperationAsync(Runnable task) {
        ThreadRunner.run((Runnable)task);
    }

    @Override
    public void performSafeOperationSync(Runnable task) {
        task.run();
    }

    @Override
    public void close() throws IOException {
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public Value2D getLastValue() {
        return new Value2D(this.xToVx(this.list.getMaxX()), this.list.getLastY(), false);
    }

    @Override
    public long getLowest(long start, final XPredicate predicate) {
        return this.list.getLowest((int)start, new XLongPredicate(){

            public boolean applies(long x) {
                return predicate.applies(XYListValue2DStorage.this.xToVx(x));
            }
        });
    }

    @Override
    public long getHighest(long start, final XPredicate predicate) {
        return this.list.getHighest((int)start, new XLongPredicate(){

            public boolean applies(long x) {
                return predicate.applies(XYListValue2DStorage.this.xToVx(x));
            }
        });
    }

    @Override
    public void setData(Value2D value, Object data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getData(Value2D value) {
        return this.list.getData(this.vxToX(value.x), (long)(0.5 + value.y));
    }

    public Iterable<Value2D> getValues(final long fromIndex, final long toIndex) {
        return new Iterable<Value2D>(){

            @Override
            public Iterator<Value2D> iterator() {
                return new Iterator<Value2D>(){
                    XYListIterator it;
                    boolean valid;
                    boolean closed;
                    {
                        this.it = XYListValue2DStorage.this.list.getIterator((int)fromIndex, (int)toIndex - 1);
                        this.valid = this.it.next();
                        this.closed = false;
                    }

                    @Override
                    public boolean hasNext() {
                        if (!this.valid && !this.closed) {
                            this.it.close();
                            this.closed = true;
                        }
                        return this.valid;
                    }

                    @Override
                    public Value2D next() {
                        Value2D result = new Value2D(XYListValue2DStorage.this.xToVx(this.it.x), this.it.y, this.it.emphasized);
                        this.valid = this.it.next();
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private long xToVx(long x) {
        return x + this.xOffset;
    }

    private long vxToX(double vx) {
        if (vx < 0.0) {
            return (long)(vx - 0.5) - this.xOffset;
        }
        return (long)(vx + 0.5) - this.xOffset;
    }

    public class IteratorAdapter
    implements Iterator<Value2D> {
        private final XYListIterator it;
        private boolean hasNext;

        public IteratorAdapter(XYListIterator it) {
            this.it = it;
            this.hasNext = it.next();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Value2D next() {
            double x = XYListValue2DStorage.this.xToVx(this.it.x);
            double y = this.it.y;
            boolean emphazized = this.it.emphasized;
            this.hasNext = this.it.next();
            return new Value2D(x, y, emphazized);
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not implemented");
        }

        public void close() {
            this.it.close();
        }
    }
}

