/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.geometry;

import com.sap.jvm.profiling.ui.graph.geometry.Point2D;
import java.util.ArrayList;

public class Arc {
    private final int centerX;
    private final int centerY;
    private final double width;
    private final double height;
    private final int startAngle;
    private final int angleDiff;

    public Arc(int centerX, int centerY, int width, int height, int startAngle, int endAngle) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.width = (double)width / 2.0;
        this.height = (double)height / 2.0;
        this.startAngle = startAngle % 360;
        this.angleDiff = endAngle - startAngle;
    }

    public boolean contains(int x, int y) {
        if (x == this.centerX && y == this.centerY) {
            return true;
        }
        double scale = this.height / this.width;
        double dx = (double)(x - this.centerX) * scale;
        double dy = y - this.centerY;
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (distance > this.height) {
            return false;
        }
        double angle = Math.toDegrees(Math.atan2(dy, dx));
        double startDiff = Math.IEEEremainder(angle - (double)this.startAngle - 180.0, 360.0) + 180.0;
        return startDiff <= (double)this.angleDiff;
    }

    public Point2D[] asPath() {
        if (this.angleDiff == 0) {
            return new Point2D[0];
        }
        ArrayList<Point2D> path = new ArrayList<Point2D>();
        path.add(new Point2D(this.centerX, this.centerY));
        for (int i = 0; i <= this.angleDiff; ++i) {
            double phi = Math.toRadians(this.startAngle + i);
            path.add(new Point2D((int)((double)this.centerX + Math.cos(phi) * this.width), (int)((double)this.centerY + Math.sin(phi) * this.height)));
        }
        return path.toArray(new Point2D[path.size()]);
    }

    public double asPercentage() {
        return (double)this.angleDiff / 360.0;
    }
}

