/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.geometry;

import com.sap.jvm.profiling.ui.graph.geometry.Point2D;
import com.sap.jvm.profiling.ui.graph.geometry.RectangleLayoutAdaptor;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;

public class Rectangle {
    public int x;
    public int y;
    public int x_end;
    public int y_end;
    public int width;
    public int height;
    public Point2D center;
    private Object data;

    public Rectangle() {
        this(10, 10, 10, 10);
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.x_end = x + width;
        this.y_end = y - height;
        this.width = width;
        this.height = height;
        this.center = new Point2D(x + width / 2, y - height / 2);
    }

    public Rectangle(int x, int y, int width, int height, Object data) {
        this(x, y, width, height);
        this.data = data;
    }

    public void copy(Rectangle rec) {
        this.x = rec.x;
        this.y = rec.y;
        this.width = rec.width;
        this.height = rec.height;
        this.x_end = rec.x_end;
        this.y_end = rec.y_end;
        this.center.x = rec.center.x;
        this.center.y = rec.center.y;
    }

    public void update(int newX, int newY, int newWidth, int newHeight) {
        this.x = newX;
        this.y = newY;
        this.width = newWidth;
        this.height = newHeight;
        this.x_end = this.x + this.width;
        this.y_end = this.y - this.height;
        this.center = new Point2D(this.x + this.width / 2, this.y - this.height / 2);
    }

    public void update(int newWidth, int newHeight) {
        this.width = newWidth;
        this.height = newHeight;
        this.x_end = this.x + this.width;
        this.y_end = this.y - this.height;
        this.center = new Point2D(this.x + this.width / 2, this.y - this.height / 2);
    }

    public void updateHeight(int newHeight) {
        this.height = newHeight;
        this.y_end = this.y - this.height;
        this.center.y = this.y - this.height / 2;
    }

    public void updateWidth(int newWidth) {
        this.width = newWidth;
        this.x_end = this.x + this.width;
        this.center.x = this.x + this.width / 2;
    }

    public void updatePosition(int xPos, int yPos) {
        this.x = xPos;
        this.y = yPos;
        this.x_end = this.x + this.width;
        this.y_end = this.y - this.height;
        this.center = new Point2D(this.x + this.width / 2, this.y - this.height / 2);
    }

    public void updateXPosition(int xPos) {
        this.x = xPos;
        this.x_end = this.x + this.width;
        this.center.x = this.x + this.width / 2;
    }

    public void updateYPosition(int yPos) {
        this.y = yPos;
        this.y_end = this.y - this.height;
        this.center.y = this.y + this.height / 2;
    }

    public void updateLayout(RectangleLayoutAdaptor adaptor) {
        if (adaptor.getHeight() > 0) {
            this.updateHeight(adaptor.getHeight());
        }
        if (adaptor.getWidth() > 0) {
            this.updateHeight(adaptor.getWidth());
        }
        if (adaptor.getXPosition() > 0) {
            this.updateXPosition(adaptor.getXPosition());
        }
        if (adaptor.getYPosition() > 0) {
            this.updateYPosition(adaptor.getYPosition());
        }
    }

    public Object getData() {
        return this.data;
    }

    public Rectangle createIn(Rectangle rec) {
        return new Rectangle(this.x + rec.x, this.y - (this.height - rec.y), rec.width, rec.height);
    }

    public void updateIn(Rectangle rec, int xIn, int yIn, int widthIn, int heightIn) {
        rec.update(this.x + xIn, this.y + yIn, widthIn, heightIn);
    }

    public Rectangle clone() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public boolean isIn(int x_test, int y_test) {
        if (x_test < this.x || x_test > this.x + this.width) {
            return false;
        }
        return y_test <= this.y && y_test >= this.y - this.height;
    }

    public boolean isPartialIn(Rectangle test) {
        return this.isInXRange(test.x) && this.isInYRange(test.y) || this.isInXRange(test.x_end) && this.isInYRange(test.y) || this.isInXRange(test.x) && this.isInYRange(test.y_end) || this.isInXRange(test.x_end) && this.isInYRange(test.y_end);
    }

    public boolean isInYRange(int y_test) {
        return y_test < this.y && y_test > this.y - this.height;
    }

    public boolean isInXRange(int x_test) {
        return x_test > this.x && x_test < this.x + this.width;
    }

    public boolean isInYRange(Rectangle rec) {
        if (rec.y < this.y - this.height) {
            return false;
        }
        return rec.y - rec.height <= this.y;
    }

    public boolean isInXRange(Rectangle rec) {
        if (rec.x > this.x_end) {
            return false;
        }
        return rec.x_end >= this.x;
    }

    public int isFullyInXRange(Rectangle rec) {
        if (rec.x_end > this.x_end) {
            return -(rec.x_end - this.x_end);
        }
        if (rec.x < this.x) {
            return this.x - rec.x;
        }
        return 0;
    }

    public int isFullyInYRange(Rectangle rec) {
        if (rec.y_end < this.y_end) {
            return this.y_end - rec.y_end;
        }
        if (rec.y > this.y) {
            return -(rec.y - this.y);
        }
        return 0;
    }

    public int getXinRec(int xDisplay) {
        return xDisplay - this.x;
    }

    public int getYinRec(int yDisplay) {
        return yDisplay - (this.y - this.height);
    }

    public int getXonDisplay(int xRec) {
        return xRec + this.x;
    }

    public int getYonDisplay(int yRec) {
        return yRec + (this.y - this.height);
    }

    public void drawRectangle(Renderer r) {
        r.drawRectangle(this.x, this.y, this.width, this.height);
    }

    public void fillRectangle(Renderer r) {
        r.fillRectangle(this.x, this.y, this.width, this.height);
    }

    public void fillShadowRectangle(Renderer r) {
        r.fillRectangle(this.x + 3, this.y - 3, this.width + 1, this.height + 1);
    }

    public void draw(Renderer r) {
        this.draw(r, Color.GRAY);
    }

    public void draw(Renderer r, Color color) {
        r.setForeground(color);
        r.drawRectangle(this.x, this.y, this.width, this.height);
        r.setDefaultColors();
    }

    public void fill(Renderer r, Color color) {
        r.setFillColor(color);
        r.fillRectangle(this.x, this.y, this.width, this.height);
        r.setDefaultColors();
    }

    public void drawAndFill(Renderer r, Color color, Color fillColor) {
        r.setFillColor(fillColor);
        r.fillRectangle(this.x, this.y, this.width, this.height);
        r.setForeground(color);
        r.drawRectangle(this.x, this.y, this.width, this.height);
        r.setDefaultColors();
    }

    public void drawWithCenter(Renderer r, Color color) {
        r.setForeground(color);
        if (this.width > 0) {
            r.drawRectangle(this.x, this.y, this.width, this.height);
            r.drawLine(this.center.x - 2, this.center.y, this.center.x + 2, this.center.y);
            r.drawLine(this.center.x, this.center.y - 2, this.center.x, this.center.y + 2);
        } else {
            r.drawLine(this.x, this.y_end, this.x, this.y);
        }
        r.setDefaultColors();
    }

    public void drawShadow(Renderer r) {
        r.setAlpha(100);
        r.setFillColor(Color.LIGHT_GRAY);
        r.fillRectangle(this.x + this.width, this.y - 3, 3, this.height);
        r.fillRectangle(this.x + 3, this.y - this.height, this.width, 3);
        r.setDefaultColors();
        r.setAlpha(255);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("rec: x=");
        text.append(this.x);
        text.append("  y=");
        text.append(this.y);
        text.append("  width=");
        text.append(this.width);
        text.append("  height=");
        text.append(this.height);
        return text.toString();
    }
}

