/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.legend;

import com.sap.jvm.profiling.ui.graph.BarGraphChart;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.XYGraphContainerListener;
import com.sap.jvm.profiling.ui.graph.dataset.BarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.ColoredBarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.XYGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.legend.LegendItem;
import com.sap.jvm.profiling.ui.graph.legend.LegendSelectionHandler;
import java.util.ArrayList;
import java.util.List;

public class BarGraphLegendContributor
implements XYGraphContainerListener<BarGraphDataSet> {
    private GraphChartContainer container;
    private List<BarGraphChart> charts = new ArrayList<BarGraphChart>();

    public BarGraphLegendContributor(GraphChartContainer container) {
        this.container = container;
        container.enableLegend(true);
        container.enableLegendItemSelection(true);
    }

    public void registerChartLegendContributor(BarGraphChart chart) {
        if (!this.charts.contains(chart)) {
            this.charts.add(chart);
            chart.addGraphContainerListener(this);
        }
    }

    @Override
    public void appendedGraph(BarGraphDataSet graph) {
        if (graph.getType() == XYGraphDataSet.GraphType.COMBINED) {
            for (XYGraphDataSet item : graph.getCombinedItems()) {
                this.container.addLegendItem(item.getName(), item.getGraphColor(), new BarHandler((BarGraphDataSet)item));
            }
        } else if (graph.getType() == XYGraphDataSet.GraphType.COLORED) {
            ColoredBarGraphDataSet cData = (ColoredBarGraphDataSet)graph;
            for (Value2D value : cData) {
                String itemText = cData.getText(value);
                if (itemText == null || itemText.trim().length() <= 0) continue;
                this.container.addLegendItem(itemText, cData.getColor(value), new ColorBarHandler(graph, value));
            }
        } else {
            this.container.addLegendItem(graph.getName(), graph.getGraphColor(), new BarHandler(graph));
        }
    }

    @Override
    public void removedGraph(BarGraphDataSet graph) {
    }

    @Override
    public void removedAllGraphs(ArrayList<BarGraphDataSet> graphs) {
    }

    private class ColorBarHandler
    implements LegendSelectionHandler {
        Value2D value;
        BarGraphDataSet data;

        public ColorBarHandler(BarGraphDataSet data, Value2D value) {
            this.data = data;
            this.value = value;
        }

        @Override
        public void toggleSelection(LegendItem item) {
            boolean state = !this.getSelection(item);
            for (BarGraphChart chart : BarGraphLegendContributor.this.charts) {
                chart.setSingleSelection(this.data, this.value, state, true);
            }
        }

        @Override
        public boolean getSelection(LegendItem item) {
            for (BarGraphChart chart : BarGraphLegendContributor.this.charts) {
                if (!chart.contains(this.data) || chart.isSelected(this.data, this.value)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void resetSelection(LegendItem item) {
            for (BarGraphChart chart : BarGraphLegendContributor.this.charts) {
                chart.setSelection(this.data, false, true);
            }
        }
    }

    private class BarHandler
    implements LegendSelectionHandler {
        BarGraphDataSet data;

        public BarHandler(BarGraphDataSet data) {
            this.data = data;
        }

        @Override
        public void toggleSelection(LegendItem item) {
            boolean state = !this.getSelection(item);
            for (BarGraphChart chart : BarGraphLegendContributor.this.charts) {
                chart.setSelection(this.data, state, true);
            }
        }

        @Override
        public boolean getSelection(LegendItem item) {
            for (BarGraphChart chart : BarGraphLegendContributor.this.charts) {
                if (!chart.contains(this.data) || chart.isSelected(this.data)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void resetSelection(LegendItem item) {
            for (BarGraphChart chart : BarGraphLegendContributor.this.charts) {
                chart.setSelection(this.data, false, true);
            }
        }
    }
}

