/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.legend;

import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.legend.LegendItem;
import com.sap.jvm.profiling.ui.graph.legend.LegendPositionAnchor;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphLegend {
    protected static final Color SELECTION_COLOR = new Color(217, 232, 249);
    protected static final Color SELECTION_BORDER_COLOR = new Color(0, 128, 255);
    protected static final int LINE_SPACE = 5;
    protected static final int MARGIN = 10;
    protected List<LegendItem> legendItems = new ArrayList<LegendItem>();
    private Renderer renderer;
    private boolean enabled = false;
    private boolean extensionsEnabled = true;
    private boolean enabledItemSelection = false;
    private Rectangle legendArea = new Rectangle();
    private Rectangle legendHeader = new Rectangle();
    private Map<LegendItem, Rectangle> itemsAreas = new HashMap<LegendItem, Rectangle>();
    private LegendItem focusedItem;
    private int defXPos;
    private int defYPos;
    private double posXWidth = -1.0;
    private double posYWidth = -1.0;
    private int rows = 1;
    private Font boldFont = null;
    private Font defFont = null;
    private Font sepFont = null;
    private int lineHeight;
    private LegendPositionAnchor anchor;
    private LegendItem hoveredItem;

    public GraphLegend(Renderer renderer) {
        this.renderer = renderer;
    }

    public boolean isEnabled() {
        return this.enabled && this.legendItems.size() > 0;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPositionAnchor(LegendPositionAnchor anchor) {
        this.anchor = anchor;
        this.posYWidth = -1.0;
        this.posXWidth = -1.0;
        this.adjustOnAnchor(this.legendArea.width, this.legendArea.height);
        this.legendArea.update(this.defXPos, this.defYPos, this.legendArea.width, this.legendArea.height);
    }

    public boolean isPinnedOnAnchor() {
        return this.anchor != null && this.posXWidth == this.posYWidth && this.posXWidth == -1.0;
    }

    public LegendPositionAnchor getPositionAnchor() {
        return this.anchor;
    }

    public boolean isHovered(LegendPositionAnchor anch) {
        return this.getDistance(anch) < 40.0;
    }

    public double getDistance(LegendPositionAnchor anch) {
        int x = anch.getX();
        int y = anch.getY();
        switch (anch.getPinCorner()) {
            case RIGHT_TOP: {
                x -= this.legendArea.x_end;
                y -= this.legendArea.y;
                break;
            }
            case RIGHT_CENTER: {
                x -= this.legendArea.x_end;
                y -= this.legendArea.center.y;
                break;
            }
            case RIGHT_BOTTOM: {
                x -= this.legendArea.x_end;
                y -= this.legendArea.y_end;
                break;
            }
            case LEFT_TOP: {
                x -= this.legendArea.x;
                y -= this.legendArea.y;
                break;
            }
            case LEFT_CENTER: {
                x -= this.legendArea.x;
                y -= this.legendArea.center.y;
                break;
            }
            case LEFT_BOTTOM: {
                x -= this.legendArea.x;
                y -= this.legendArea.y_end;
            }
        }
        return Math.sqrt(x * x + y * y);
    }

    public void setExtensionsEnabled(boolean enabled) {
        this.extensionsEnabled = enabled;
    }

    public void setItemSelectionEnabled(boolean enabled) {
        this.enabledItemSelection = enabled;
    }

    public LegendItem[] getItems() {
        return this.legendItems.toArray(new LegendItem[this.legendItems.size()]);
    }

    public void appendItems(List<LegendItem> items) {
        this.legendItems.addAll(items);
    }

    public LegendItem appendItem(LegendItem item) {
        if (!this.legendItems.contains(item)) {
            for (LegendItem i : this.legendItems) {
                if (!i.getItemText().equals(item.getItemText())) continue;
                return i;
            }
            this.legendItems.add(item);
            return item;
        }
        return item;
    }

    public void removeItem(LegendItem item) {
        this.legendItems.remove(item);
    }

    public void removeAllItems() {
        this.legendItems.clear();
    }

    public void paintLegend() {
        if (this.isEnabled()) {
            this.renderer.setPaintArea(null);
            this.drawLegend();
        }
    }

    public void paintLegend(Rectangle clip) {
        if (this.isEnabled() && clip.isPartialIn(this.legendArea)) {
            Rectangle pSave = this.renderer.getPainArea();
            Rectangle cSave = this.renderer.getClippingArea();
            this.renderer.setPaintArea(null, clip);
            this.drawLegend();
            this.renderer.setPaintArea(pSave, cSave);
        }
    }

    private void drawLegend() {
        this.renderer.setFillColor(Color.LIGHT_GRAY);
        this.renderer.setForeground(Color.GRAY);
        this.renderer.setAlpha(140);
        if (this.enabledItemSelection) {
            this.legendHeader.update(this.legendArea.x, this.legendArea.y, this.legendArea.width, this.lineHeight);
            this.renderer.fillRectangle(this.legendArea.x, this.legendArea.y - this.legendHeader.height, this.legendArea.width - 1, this.legendArea.height - this.legendHeader.height);
            this.renderer.drawRectangle(this.legendArea.x, this.legendArea.y - this.legendHeader.height, this.legendArea.width - 1, this.legendArea.height - this.legendHeader.height);
        } else {
            this.renderer.fillRectangle(this.legendArea.x, this.legendArea.y, this.legendArea.width, this.legendArea.height);
            this.renderer.drawRectangle(this.legendArea.x, this.legendArea.y, this.legendArea.width, this.legendArea.height);
        }
        if (this.enabledItemSelection) {
            this.renderer.setAlpha(220);
            this.renderer.setFillColor(new Color(180, 180, 180));
            this.renderer.setForeground(new Color(245, 245, 245));
            this.renderer.fillGradientRectangle(this.legendHeader.x, this.legendHeader.y, this.legendHeader.width - 1, this.legendHeader.height - 2, false);
            this.renderer.setForeground(new Color(100, 100, 100));
            this.renderer.drawRectangle(this.legendHeader.x, this.legendHeader.y, this.legendHeader.width - 1, this.legendHeader.height - 2);
            this.paintMoveIcon();
        }
        this.renderer.setAlpha(255);
        for (LegendItem i : this.legendItems) {
            Rectangle itemCell = this.itemsAreas.get(i);
            if (itemCell == null) continue;
            String text = i.getItemText();
            Rectangle paintCell = new Rectangle(this.legendArea.x + itemCell.x, this.legendArea.y_end + itemCell.y, itemCell.width, itemCell.height);
            if (i.isSeparatorItem()) {
                int y = paintCell.y - this.lineHeight / 2 - 2;
                if (text != null && text.length() > 0) {
                    this.renderer.setForeground(Color.DARK_GRAY);
                    this.renderer.setFont(this.sepFont);
                    int textWidth = this.renderer.getStringWidth(i.getItemText());
                    this.renderer.drawString(text, paintCell.x + this.lineHeight, paintCell.y - 2);
                    this.renderer.setAlpha(140);
                    this.renderer.setForeground(Color.GRAY);
                    this.renderer.drawLine(paintCell.x - 5, y, paintCell.x + this.lineHeight - 4, y);
                    this.renderer.drawLine(paintCell.x + this.lineHeight + 4 + textWidth, y, paintCell.x_end + 5, y);
                    this.renderer.setAlpha(255);
                } else {
                    this.renderer.setAlpha(140);
                    this.renderer.setForeground(Color.GRAY);
                    this.renderer.drawLine(paintCell.x - 5, y, paintCell.x_end + 5, y);
                }
                this.renderer.setAlpha(255);
                continue;
            }
            this.renderer.setFillColor(i.getItemColor());
            this.renderer.setForeground(this.dim(i.getItemColor()));
            this.renderer.fillRectangle(paintCell.x, paintCell.y, this.lineHeight / 2, this.lineHeight);
            this.renderer.drawRectangle(paintCell.x, paintCell.y, this.lineHeight / 2, this.lineHeight);
            if (this.enabledItemSelection) {
                Rectangle selRec = new Rectangle(paintCell.x + this.lineHeight - 3, paintCell.y, paintCell.width - this.lineHeight + 5, paintCell.height + 1);
                if (i.isSelected()) {
                    this.renderer.setAlpha(160);
                    selRec.drawAndFill(this.renderer, SELECTION_BORDER_COLOR, SELECTION_COLOR);
                    this.renderer.setAlpha(255);
                }
                if (i == this.focusedItem) {
                    this.renderer.setForeground(Color.DARK_GRAY);
                    this.renderer.setFont(this.boldFont);
                    this.renderer.drawString(i.getItemText(), paintCell.x + this.lineHeight, paintCell.y);
                    this.renderer.setFont(this.defFont);
                    selRec.draw(this.renderer, Color.DARK_GRAY);
                    if (!this.extensionsEnabled) continue;
                    this.paintExtendedItem(true, paintCell, i, this.renderer);
                    continue;
                }
            }
            this.renderer.setForeground(Color.BLACK);
            this.renderer.setFont(this.defFont);
            this.renderer.drawString(i.getItemText(), paintCell.x + this.lineHeight, paintCell.y);
            if (!this.extensionsEnabled) continue;
            this.paintExtendedItem(false, paintCell, i, this.renderer);
        }
        this.renderer.setAlpha(255);
        this.renderer.setDefaultColors();
    }

    private void paintMoveIcon() {
        boolean oldAntialias = this.renderer.isAntialiased();
        this.renderer.setAntialiased(true);
        int offsetY = this.legendHeader.y_end + this.legendHeader.height / 2 + 1;
        int offsetX = this.legendHeader.x + 5;
        this.renderer.setForeground(Color.DARK_GRAY);
        this.renderer.drawPoint(offsetX, offsetY);
        this.renderer.drawLine(++offsetX, ++offsetY, offsetX, offsetY - 2);
        this.renderer.drawLine(++offsetX, ++offsetY, offsetX, offsetY - 4);
        this.renderer.drawPoint(offsetX += 4, ++offsetY);
        this.renderer.drawLine(++offsetX, --offsetY, offsetX - 2, offsetY);
        this.renderer.drawLine(++offsetX, --offsetY, offsetX - 4, offsetY);
        this.renderer.drawLine(offsetX += 2, ++offsetY, offsetX, offsetY - 4);
        this.renderer.drawLine(++offsetX, --offsetY, offsetX, offsetY - 2);
        this.renderer.drawPoint(++offsetX, --offsetY);
        this.renderer.drawLine(offsetX -= 4, --offsetY, offsetX - 4, offsetY);
        this.renderer.drawLine(--offsetX, --offsetY, offsetX - 2, offsetY);
        this.renderer.drawPoint(--offsetX, --offsetY);
        this.renderer.setAntialiased(oldAntialias);
    }

    protected int getItemExtensionWidthSpace(LegendItem item) {
        return 0;
    }

    protected void paintExtendedItem(boolean heighlighted, Rectangle itemCell, LegendItem item, Renderer r) {
    }

    private Color dim(Color color) {
        return new Color(color.red > 120 ? color.red - 120 : 0, color.green > 120 ? color.green - 120 : 0, color.blue > 120 ? color.blue - 120 : 0);
    }

    public void updateLegendArea(Rectangle mainArea) {
        if (this.isEnabled()) {
            if (this.boldFont == null) {
                this.defFont = this.renderer.getFont();
                this.boldFont = this.defFont.getBold();
                this.sepFont = new Font(this.defFont.getName(), this.defFont.getSize() - 2, this.defFont.getStyle());
                this.lineHeight = this.renderer.getFontHeight();
            }
            this.renderer.setFont(this.defFont);
            this.itemsAreas.clear();
            int rowItems = this.legendItems.size();
            int height = this.lineHeight * rowItems + 5 * (rowItems - 1) + 20;
            while (mainArea.height > 0 && height > mainArea.height) {
                rowItems = (int)((double)rowItems * 0.75);
                height = this.lineHeight * rowItems + 5 * (rowItems - 1) + 20;
                if (rowItems != 0) continue;
                this.legendArea.update(0, 0);
                return;
            }
            this.rows = this.legendItems.size() % rowItems == 0 ? this.legendItems.size() / rowItems : this.legendItems.size() / rowItems + 1;
            int width = 10;
            for (int row = 0; row < this.rows; ++row) {
                LegendItem item;
                int i;
                int rowWidth = 0;
                int rowLineOffset = height - 10;
                int itemsCount = (height - 10) / (5 + this.lineHeight);
                int itemsCountOffset = row * itemsCount;
                if (itemsCount > this.legendItems.size() - itemsCountOffset) {
                    itemsCount = this.legendItems.size() - itemsCountOffset;
                }
                if (itemsCount <= 0) break;
                this.renderer.setFont(this.boldFont);
                for (i = 0; i < itemsCount; ++i) {
                    item = this.legendItems.get(i + itemsCountOffset);
                    int w = this.renderer.getStringWidth(item.getItemText()) + (this.extensionsEnabled ? this.getItemExtensionWidthSpace(item) : 0);
                    if (rowWidth < w) {
                        rowWidth = w;
                    }
                    this.itemsAreas.put(item, new Rectangle(width, rowLineOffset, this.lineHeight + w, this.lineHeight));
                    rowLineOffset -= 5 + this.lineHeight;
                }
                this.renderer.setFont(this.defFont);
                rowWidth += this.lineHeight;
                for (i = 0; i < itemsCount; ++i) {
                    item = this.legendItems.get(i + itemsCountOffset);
                    Rectangle rec = this.itemsAreas.get(item);
                    rec.updateWidth(rowWidth);
                }
                width += rowWidth + 10;
            }
            if (this.enabledItemSelection) {
                height += this.lineHeight;
            }
            if (this.posXWidth == this.posYWidth && this.posXWidth == -1.0) {
                if (this.anchor == null) {
                    this.defXPos = mainArea.width - width;
                    this.defYPos = mainArea.height;
                } else {
                    this.adjustOnAnchor(width, height);
                }
            } else {
                this.defXPos = (int)((double)(mainArea.width - width) * this.posXWidth);
                this.defYPos = (int)((double)height + (double)(mainArea.height - height) * this.posYWidth);
            }
            this.legendArea.update(this.defXPos, this.defYPos, width, height);
            this.adjustOnBorder(mainArea);
            this.defXPos = this.legendArea.x;
            this.defYPos = this.legendArea.y;
        }
    }

    private void adjustOnAnchor(int width, int height) {
        this.defXPos = this.anchor.getX();
        this.defYPos = this.anchor.getY();
        switch (this.anchor.getPinCorner()) {
            case LEFT_TOP: {
                break;
            }
            case LEFT_CENTER: {
                this.defYPos += height / 2;
                break;
            }
            case LEFT_BOTTOM: {
                this.defYPos += height;
                break;
            }
            case RIGHT_TOP: {
                this.defXPos -= width;
                break;
            }
            case RIGHT_CENTER: {
                this.defXPos -= width;
                this.defYPos += height / 2;
                break;
            }
            case RIGHT_BOTTOM: {
                this.defXPos -= width;
                this.defYPos += height;
            }
        }
    }

    public void moveLegend(int deltaX, int deltaY, Rectangle mainArea) {
        this.legendArea.updatePosition(this.legendArea.x + deltaX, this.legendArea.y + deltaY);
        this.adjustOnBorder(mainArea);
        this.posXWidth = (double)this.legendArea.x / (double)(mainArea.width - this.legendArea.width);
        this.posYWidth = (double)(this.legendArea.y - this.legendArea.height) / (double)(mainArea.height - this.legendArea.height);
    }

    private void adjustOnBorder(Rectangle mainArea) {
        int checkY;
        int checkX = mainArea.isFullyInXRange(this.legendArea);
        if (checkX != 0) {
            this.legendArea.updatePosition(this.legendArea.x + checkX, this.legendArea.y);
        }
        if ((checkY = mainArea.isFullyInYRange(this.legendArea)) != 0) {
            this.legendArea.updatePosition(this.legendArea.x, this.legendArea.y + checkY);
        }
    }

    public void restoreDefaultPosition() {
        this.legendArea.update(this.defXPos, this.defYPos, this.legendArea.width, this.legendArea.height);
    }

    public void saveAsDefaultPosition() {
        this.defXPos = this.legendArea.x;
        this.defYPos = this.legendArea.y;
    }

    public boolean isHovered(int x, int y) {
        if (this.isEnabled() && this.legendArea.isIn(x, y)) {
            if (this.enabledItemSelection) {
                this.hoveredItem = null;
                int xR = this.legendArea.getXinRec(x);
                int yR = this.legendArea.getYinRec(y);
                if (this.legendHeader.isIn(x, y)) {
                    return true;
                }
                for (Map.Entry<LegendItem, Rectangle> item : this.itemsAreas.entrySet()) {
                    if (!item.getValue().isIn(xR, yR)) continue;
                    this.hoveredItem = item.getKey();
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public LegendItem getHoveredItem() {
        return this.hoveredItem;
    }

    public LegendItem getFocusedItem() {
        return this.focusedItem;
    }

    public void focusNextItem() {
        if (this.enabledItemSelection && !this.legendItems.isEmpty()) {
            if (this.focusedItem == null) {
                this.focusedItem = this.legendItems.get(0);
            } else {
                int idx = this.legendItems.indexOf(this.focusedItem);
                if (idx < this.legendItems.size() - 1) {
                    this.focusedItem = this.legendItems.get(idx + 1);
                }
            }
        }
    }

    public void focusPrevItem() {
        if (this.enabledItemSelection && !this.legendItems.isEmpty()) {
            if (this.focusedItem == null) {
                this.focusedItem = this.legendItems.get(this.legendItems.size() - 1);
            } else {
                int idx = this.legendItems.indexOf(this.focusedItem);
                if (idx > 0) {
                    this.focusedItem = this.legendItems.get(idx - 1);
                }
            }
        }
    }

    public void setFocusedItem(LegendItem item) {
        this.focusedItem = item;
    }

    public void setRelPosition(double xRel, double yRel) {
        this.posXWidth = Math.min(Math.max(xRel, 0.0), 1.0);
        this.posYWidth = Math.min(Math.max(yRel, 0.0), 1.0);
    }

    public double getRelXPosition() {
        return this.posXWidth;
    }

    public double getRelYPosition() {
        return this.posYWidth;
    }
}

