/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.legend;

import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.legend.GraphLegend;
import com.sap.jvm.profiling.ui.graph.legend.LegendPositionAnchor;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.ColorPool;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.List;

public class LegendAnchorController {
    private boolean legendMove;
    private LegendPositionAnchor hoveredAnchor;

    public void setLegendMove() {
        this.legendMove = true;
    }

    public void resetLegendMove() {
        this.legendMove = false;
    }

    public boolean isLegendMove() {
        return this.legendMove;
    }

    public LegendPositionAnchor getHoveredAnchor() {
        return this.hoveredAnchor;
    }

    public void paintAnchors(Renderer renderer, List<GraphChartContainer.DisplayCell> displayCells, GraphLegend legend) {
        Color color = ColorPool.getPool().getColor(3, 8);
        Color colorH = ColorPool.getPool().getColor(1, 11);
        LegendPositionAnchor hovAnchor = null;
        double lastHoveredDistance = Double.MAX_VALUE;
        renderer.setForeground(color);
        renderer.setFillColor(color);
        for (GraphChartContainer.DisplayCell cell : displayCells) {
            if (cell.getLegendAnchors() == null) continue;
            for (LegendPositionAnchor anchor : cell.getLegendAnchors()) {
                if (legend.isHovered(anchor) && legend.getDistance(anchor) < lastHoveredDistance) {
                    lastHoveredDistance = legend.getDistance(anchor);
                    hovAnchor = anchor;
                }
                this.paintAnchor(renderer, anchor);
            }
        }
        if (hovAnchor != null) {
            renderer.setForeground(colorH);
            renderer.setFillColor(colorH);
            this.paintAnchor(renderer, hovAnchor);
            this.hoveredAnchor = hovAnchor;
        } else {
            this.hoveredAnchor = null;
        }
    }

    public void paintAnchor(Renderer renderer, GraphChartContainer.DisplayCell displayCell, GraphLegend legend) {
        Color color = ColorPool.getPool().getColor(3, 8);
        Color colorH = ColorPool.getPool().getColor(1, 11);
        LegendPositionAnchor hovAnchor = null;
        double lastHoveredDistance = Double.MAX_VALUE;
        renderer.setForeground(color);
        renderer.setFillColor(color);
        if (displayCell.getLegendAnchors() == null) {
            return;
        }
        for (LegendPositionAnchor anchor : displayCell.getLegendAnchors()) {
            if (legend.isHovered(anchor) && legend.getDistance(anchor) < lastHoveredDistance) {
                lastHoveredDistance = legend.getDistance(anchor);
                hovAnchor = anchor;
            }
            this.paintAnchor(renderer, anchor);
        }
        if (hovAnchor != null) {
            renderer.setForeground(colorH);
            renderer.setFillColor(colorH);
            this.paintAnchor(renderer, hovAnchor);
            this.hoveredAnchor = hovAnchor;
        } else {
            this.hoveredAnchor = null;
        }
    }

    private void paintAnchor(Renderer renderer, LegendPositionAnchor anchor) {
        switch (anchor.getPinCorner()) {
            case RIGHT_TOP: {
                renderer.drawRectangle(anchor.getX() - 8, anchor.getY(), 8, 8);
                renderer.fillRectangle(anchor.getX() - 6, anchor.getY() - 2, 5, 5);
                break;
            }
            case RIGHT_CENTER: {
                renderer.drawRectangle(anchor.getX() - 8, anchor.getY() + 4, 8, 8);
                renderer.fillRectangle(anchor.getX() - 6, anchor.getY() + 2, 5, 5);
                break;
            }
            case RIGHT_BOTTOM: {
                renderer.drawRectangle(anchor.getX() - 8, anchor.getY() + 8, 8, 8);
                renderer.fillRectangle(anchor.getX() - 6, anchor.getY() + 6, 5, 5);
                break;
            }
            case LEFT_TOP: {
                renderer.drawRectangle(anchor.getX(), anchor.getY(), 8, 8);
                renderer.fillRectangle(anchor.getX() + 2, anchor.getY() - 2, 5, 5);
                break;
            }
            case LEFT_CENTER: {
                renderer.drawRectangle(anchor.getX(), anchor.getY() + 4, 8, 8);
                renderer.fillRectangle(anchor.getX() + 2, anchor.getY() + 2, 5, 5);
                break;
            }
            case LEFT_BOTTOM: {
                renderer.drawRectangle(anchor.getX(), anchor.getY() + 8, 8, 8);
                renderer.fillRectangle(anchor.getX() + 2, anchor.getY() + 6, 5, 5);
            }
        }
    }
}

