/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.legend;

import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;

public abstract class LegendPositionAnchor {
    public abstract int getX();

    public abstract int getY();

    public abstract PinCorner getPinCorner();

    public abstract int getId();

    public static class GraphAreaAnchor
    extends LegendPositionAnchor {
        private PinCorner corner;
        private Rectangle graphArea;
        private int id;

        public GraphAreaAnchor(PinCorner corner, Rectangle graphArea, int id) {
            this.corner = corner;
            this.graphArea = graphArea;
            this.id = id;
        }

        @Override
        public int getX() {
            switch (this.corner) {
                case LEFT_TOP: 
                case LEFT_CENTER: 
                case LEFT_BOTTOM: {
                    return this.graphArea.x + 5;
                }
                case RIGHT_TOP: 
                case RIGHT_CENTER: 
                case RIGHT_BOTTOM: {
                    return this.graphArea.x_end - 5;
                }
            }
            return 0;
        }

        @Override
        public int getY() {
            switch (this.corner) {
                case LEFT_TOP: 
                case RIGHT_TOP: {
                    return this.graphArea.y - 5;
                }
                case LEFT_BOTTOM: 
                case RIGHT_BOTTOM: {
                    return this.graphArea.y_end + 5;
                }
                case LEFT_CENTER: 
                case RIGHT_CENTER: {
                    return this.graphArea.center.y;
                }
            }
            return 0;
        }

        @Override
        public PinCorner getPinCorner() {
            return this.corner;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum PinCorner {
        LEFT_TOP,
        LEFT_CENTER,
        LEFT_BOTTOM,
        RIGHT_TOP,
        RIGHT_CENTER,
        RIGHT_BOTTOM;

    }
}

