/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.legend;

import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.PieGraphChart;
import com.sap.jvm.profiling.ui.graph.dataset.PieGraphDataSet;
import com.sap.jvm.profiling.ui.graph.legend.LegendItem;
import com.sap.jvm.profiling.ui.graph.legend.LegendSelectionHandler;
import java.util.ArrayList;
import java.util.List;

public class PieGraphLegendContributor {
    private GraphChartContainer container;
    private List<PieGraphChart> charts = new ArrayList<PieGraphChart>();

    public PieGraphLegendContributor(GraphChartContainer container) {
        this.container = container;
        container.enableLegend(true);
        container.enableLegendItemSelection(true);
    }

    public void registerChartLegendContributor(PieGraphChart chart) {
        if (!this.charts.contains(chart)) {
            this.charts.add(chart);
        }
    }

    public void updateLegend() {
        for (PieGraphChart chart : this.charts) {
            if (chart.getPieGraph() == null) continue;
            PieGraphDataSet data = chart.getPieGraph().getDataSet();
            for (PieGraphDataSet.PiePiece piece : data.getPieces()) {
                this.container.addLegendItem(piece.getName(), piece.getColor(), new PiePieceHandler(piece));
            }
        }
    }

    private class PiePieceHandler
    implements LegendSelectionHandler {
        private PieGraphDataSet.PiePiece piece;

        public PiePieceHandler(PieGraphDataSet.PiePiece piece) {
            this.piece = piece;
        }

        @Override
        public void toggleSelection(LegendItem item) {
            boolean selectionState = !this.getSelection(item);
            for (PieGraphChart chart : PieGraphLegendContributor.this.charts) {
                for (PieGraphDataSet.PiePiece p : chart.getPieGraph().getDataSet().getPieces()) {
                    if (!p.getName().equals(this.piece.getName())) continue;
                    chart.setSelection(chart.getPieGraph().getDataSet(), p, selectionState, true);
                }
            }
            PieGraphLegendContributor.this.container.refresh();
        }

        @Override
        public boolean getSelection(LegendItem item) {
            for (PieGraphChart chart : PieGraphLegendContributor.this.charts) {
                for (PieGraphDataSet.PiePiece p : chart.getPieGraph().getDataSet().getPieces()) {
                    if (!p.getName().equals(this.piece.getName()) || p.isSelected()) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public void resetSelection(LegendItem item) {
            for (PieGraphChart chart : PieGraphLegendContributor.this.charts) {
                for (PieGraphDataSet.PiePiece p : chart.getPieGraph().getDataSet().getPieces()) {
                    if (!p.getName().equals(this.piece.getName())) continue;
                    chart.setSelection(chart.getPieGraph().getDataSet(), p, false, true);
                }
            }
            PieGraphLegendContributor.this.container.refresh();
        }
    }
}

