/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.progress;

import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RenderingAsyncProgress {
    private final int corePoolSize = 5;
    private final int maxPoolSize = 20;
    private final long keepAliveTime = 20L;
    private ThreadPoolExecutor threadPool = null;
    private Job lastJob;
    private ProgressOp updUiOp;

    public RenderingAsyncProgress(ProgressOp updUiOp) {
        this.updUiOp = updUiOp;
        this.restart();
    }

    private void runTask(Runnable task) {
        if (this.threadPool.isShutdown()) {
            return;
        }
        this.threadPool.execute(task);
    }

    public void shutDown() {
        this.threadPool.shutdown();
        this.stopRendering();
    }

    public boolean isShutDown() {
        return this.threadPool.isShutdown();
    }

    public void restart() {
        if (this.threadPool == null || this.threadPool.isShutdown()) {
            this.threadPool = new ThreadPoolExecutor(5, 20, 20L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
        }
    }

    public void requestRenderingJob(RenderingJob job, Renderer renderer) {
        if (this.lastJob != null && this.lastJob.isWorking()) {
            this.lastJob.cancel();
        }
        this.lastJob = new Job(job, renderer, this.updUiOp);
        this.runTask(this.lastJob);
    }

    public void stopRendering() {
        if (this.lastJob != null) {
            this.lastJob.cancel();
        }
    }

    public boolean isRendering() {
        return this.lastJob != null && this.lastJob.isWorking();
    }

    public void paintRenderingState(Renderer renderer, Rectangle drawingArea) {
        RenderingAsyncProgress.paintRenderingState(this.lastJob.progress, renderer, drawingArea);
    }

    public static void paintRenderingState(Progress progress, Renderer renderer, Rectangle drawingArea) {
        renderer.setPaintArea(drawingArea);
        int barWidth = renderer.getWidth() / 2;
        int barHeight = renderer.getFontHeight() * 3 + 15;
        Rectangle barRec = new Rectangle(barWidth / 2, renderer.getHeight() / 2 + barHeight / 2, barWidth, barHeight);
        Rectangle progressRec = new Rectangle(barRec.x + 10, barRec.y - renderer.getFontHeight() - 5, barRec.width - 20, renderer.getFontHeight());
        Rectangle progressStatusRec = new Rectangle(progressRec.x, progressRec.y, (int)((double)progressRec.width / (double)progress.toWork * (double)progress.worked), progressRec.height);
        renderer.setAlpha(180);
        renderer.setFillColor(Color.LIGHT_GRAY);
        renderer.fillRectangle(barRec.x, barRec.y, barRec.width, barRec.height);
        renderer.setFillColor(Color.GRAY);
        renderer.fillRectangle(progressStatusRec.x + 3, progressStatusRec.y_end, progressStatusRec.width, 3);
        renderer.fillRectangle(progressStatusRec.x_end, progressStatusRec.y - 3, 3, progressStatusRec.height - 3);
        renderer.setFillColor(new Color(190, 190, 255));
        renderer.fillRectangle(progressStatusRec.x, progressStatusRec.y, progressStatusRec.width, progressStatusRec.height);
        renderer.setForeground(Color.GRAY);
        renderer.drawRectangle(progressRec.x, progressRec.y, progressRec.width, progressRec.height);
        renderer.setAlpha(255);
        StringBuilder text = new StringBuilder("Loading: ");
        text.append(progress.getPercent());
        text.append("%");
        renderer.drawString(text.toString(), barRec.x + 10, barRec.y_end + (renderer.getFontHeight() + 5));
        if (progress.message != null) {
            String tmpName = progress.message;
            int w = renderer.getStringWidth(tmpName);
            while (barRec.width - 20 < w && tmpName.length() > 5) {
                tmpName = tmpName.substring(0, tmpName.length() - 6) + "...";
            }
            renderer.drawString(tmpName, barRec.x + 10, barRec.y);
        }
    }

    private static class Job
    implements Runnable {
        private final Renderer renderer;
        private final RenderingJob renderingJob;
        private final Progress progress;

        private Job(RenderingJob renderingJob, Renderer renderer, ProgressOp updOp) {
            this.renderingJob = renderingJob;
            this.renderer = renderer;
            this.progress = new Progress(updOp);
        }

        public boolean isWorking() {
            return this.progress.isWorking();
        }

        public void cancel() {
            this.progress.cancel();
        }

        @Override
        public void run() {
            if (this.progress.isCanceled()) {
                return;
            }
            boolean changedVisualSet = this.renderingJob.processAsync(this.progress);
            if (!this.progress.isCanceled() && changedVisualSet) {
                this.progress.endTask();
                this.renderer.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!progress.isCanceled()) {
                            renderingJob.paint(renderer);
                        }
                    }
                });
            }
        }
    }

    public static interface RenderingJob {
        public boolean processAsync(Progress var1);

        public void paint(Renderer var1);
    }

    public static class Progress {
        public static final Progress NULL_PROGRESS = new Progress(){

            @Override
            public boolean isCanceled() {
                return false;
            }
        };
        private boolean canceled;
        private boolean ready = true;
        private int toWork;
        private int worked;
        private String message;
        private ProgressOp updOp;

        public Progress(ProgressOp updOp) {
            this.updOp = updOp;
        }

        public Progress() {
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public boolean isWorking() {
            return !this.canceled && !this.ready;
        }

        public void beginTask(String msg, int ticks) {
            this.message = msg;
            this.toWork = ticks;
            this.worked = 0;
            this.ready = false;
            this.canceled = false;
        }

        public void setWorked(int ticks) {
            this.worked = ticks;
        }

        public void incWorked() {
            ++this.worked;
        }

        public void incWorked(int ticks) {
            this.worked += ticks;
        }

        public int getPercent() {
            return (int)(100.0 / (double)this.toWork * (double)this.worked);
        }

        public void cancel() {
            this.canceled = true;
        }

        public void endTask() {
            this.ready = true;
            this.canceled = false;
        }

        public void updateUI() {
            if (this.updOp != null) {
                this.updOp.run(this);
            }
        }
    }

    public static interface ProgressOp {
        public void run(Progress var1);
    }
}

