/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.renderer;

public class Color {
    public static final Color TOOLTIP_BLUE = new Color(200, 220, 255);
    public static final Color TOOLTIP_YELLOW = new Color(255, 255, 150);
    public static final Color TOOLTIP_LIGHT_YELLOW = new Color(255, 255, 200);
    public static final Color TOOLTIP_ORANGE = new Color(255, 230, 180);
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color GRAY_10 = new Color(26, 26, 26);
    public static final Color GRAY_20 = new Color(51, 51, 51);
    public static final Color GRAY_30 = new Color(77, 77, 77);
    public static final Color GRAY_40 = new Color(102, 102, 102);
    public static final Color GRAY_50 = new Color(128, 128, 128);
    public static final Color GRAY_60 = new Color(153, 153, 153);
    public static final Color GRAY_70 = new Color(179, 179, 179);
    public static final Color GRAY_80 = new Color(204, 204, 204);
    public static final Color GRAY_90 = new Color(230, 230, 230);
    public static final Color LIGHT_GRAY = new Color(245, 245, 245);
    public static final Color GRAY_MIDDLE = new Color(190, 190, 190);
    public static final Color GRAY = GRAY_50;
    public static final Color DARK_GRAY = new Color(64, 64, 64);
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color LIGHT_RED = new Color(255, 200, 200);
    public static final Color PINK = new Color(255, 175, 175);
    public static final Color ORANGE = new Color(255, 200, 0);
    public static final Color YELLOW = new Color(255, 255, 0);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color MAGENTA = new Color(255, 0, 255);
    public static final Color CYAN = new Color(0, 255, 255);
    public static final Color BLUE = new Color(0, 0, 255);
    private static final double FACTOR = 0.7;
    public final int red;
    public final int green;
    public final int blue;
    public final int rgb;
    private final int hash;

    public Color(int red, int green, int blue) {
        int n = red < 0 ? 0 : (this.red = red > 255 ? 255 : red);
        int n2 = green < 0 ? 0 : (this.green = green > 255 ? 255 : green);
        this.blue = blue < 0 ? 0 : (blue > 255 ? 255 : blue);
        this.rgb = red << 16 | green << 8 | blue;
        this.hash = blue << 16 | green << 8 | red;
    }

    public Color(int rgb) {
        this.rgb = rgb;
        this.red = rgb >> 16 & 0xFF;
        this.green = rgb >> 8 & 0xFF;
        this.blue = rgb & 0xFF;
        this.hash = this.blue << 16 | this.green << 8 | this.red;
    }

    public boolean equals(Object obj) {
        Color test = (Color)obj;
        return this.red == test.red && this.green == test.green && this.blue == test.blue;
    }

    public int hashCode() {
        return this.hash;
    }

    public static Color getRandomColor() {
        return new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
    }

    public static Color darker(Color cl) {
        return new Color(Math.max((int)((double)cl.red * 0.7), 0), Math.max((int)((double)cl.green * 0.7), 0), Math.max((int)((double)cl.blue * 0.7), 0));
    }

    public static Color brighter(Color cl) {
        int r = cl.red;
        int g = cl.green;
        int b = cl.blue;
        int i = 3;
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / 0.7), 255), Math.min((int)((double)g / 0.7), 255), Math.min((int)((double)b / 0.7), 255));
    }

    public static Color alpha(Color overCl, Color underCl, double alpha) {
        assert (alpha > 0.0 && alpha < 1.0);
        double r = alpha * ((double)overCl.red * 0.00392156862745098) + (1.0 - alpha) * ((double)underCl.red * 0.00392156862745098);
        double g = alpha * ((double)overCl.green * 0.00392156862745098) + (1.0 - alpha) * ((double)underCl.green * 0.00392156862745098);
        double b = alpha * ((double)overCl.blue * 0.00392156862745098) + (1.0 - alpha) * ((double)underCl.blue * 0.00392156862745098);
        return new Color((int)(255.0 * r), (int)(255.0 * g), (int)(255.0 * b));
    }

    public static Color mix(Color cl1, Color cl2) {
        return new Color((cl1.red + cl2.red) / 2, (cl1.green + cl2.green) / 2, (cl1.blue + cl2.blue) / 2);
    }

    public String getString() {
        String b;
        String g;
        String r = Integer.toHexString(this.red);
        if (r.length() < 2) {
            r = "0" + r;
        }
        if ((g = Integer.toHexString(this.green)).length() < 2) {
            g = "0" + g;
        }
        if ((b = Integer.toHexString(this.blue)).length() < 2) {
            b = "0" + b;
        }
        return r + g + b;
    }
}

