/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.renderer;

import com.sap.jvm.profiling.ui.graph.renderer.Color;
import java.util.Arrays;
import java.util.Comparator;

public class ColorPool {
    private int nextPointer = -1;
    private ColorRange[] pool = new ColorRange[]{new ColorRange(new Color[]{new Color(217, 245, 178), new Color(206, 248, 175), new Color(200, 232, 129), new Color(198, 249, 17), new Color(190, 244, 33), new Color(187, 246, 135), new Color(187, 243, 175), new Color(186, 238, 111), new Color(176, 211, 115), new Color(173, 226, 152), new Color(171, 197, 51), new Color(165, 198, 142), new Color(163, 185, 96), new Color(162, 219, 156), new Color(155, 243, 142), new Color(155, 184, 64), new Color(154, 169, 77), new Color(151, 243, 117), new Color(146, 221, 71), new Color(144, 192, 92), new Color(135, 159, 124), new Color(133, 189, 55), new Color(130, 227, 110), new Color(125, 229, 17), new Color(105, 159, 116), new Color(89, 202, 145), new Color(81, 218, 69), new Color(44, 162, 99)}), new ColorRange(new Color[]{new Color(253, 154, 79), new Color(252, 191, 169), new Color(245, 179, 179), new Color(245, 139, 129), new Color(242, 124, 53), new Color(239, 177, 178), new Color(239, 130, 120), new Color(237, 77, 132), new Color(233, 145, 4), new Color(231, 95, 49), new Color(229, 145, 118), new Color(229, 59, 66), new Color(228, 116, 128), new Color(228, 86, 121), new Color(223, 86, 129), new Color(218, 122, 104)}), new ColorRange(new Color[]{new Color(238, 222, 173), new Color(235, 235, 213), new Color(231, 212, 167), new Color(221, 200, 148), new Color(219, 176, 121), new Color(218, 190, 125), new Color(214, 199, 115), new Color(213, 165, 104), new Color(212, 222, 213), new Color(205, 198, 138), new Color(193, 152, 94), new Color(191, 192, 159), new Color(186, 171, 134), new Color(167, 164, 102), new Color(133, 135, 82)}), new ColorRange(new Color[]{new Color(175, 228, 254), new Color(130, 178, 180), new Color(113, 181, 173), new Color(111, 171, 239), new Color(109, 179, 188), new Color(108, 181, 232), new Color(83, 166, 202), new Color(75, 161, 248), new Color(67, 110, 199), new Color(45, 195, 207), new Color(38, 157, 226), new Color(37, 151, 186), new Color(34, 150, 233), new Color(34, 125, 210), new Color(12, 185, 244), new Color(5, 153, 212)}), new ColorRange(new Color[]{new Color(248, 226, 116), new Color(247, 234, 166), new Color(244, 175, 53), new Color(242, 203, 43), new Color(241, 223, 50), new Color(240, 224, 81), new Color(239, 236, 55), new Color(237, 206, 37), new Color(232, 230, 6), new Color(230, 206, 6), new Color(214, 209, 62), new Color(205, 191, 13), new Color(202, 207, 134)}), new ColorRange(new Color[]{new Color(227, 223, 244), new Color(197, 198, 246), new Color(197, 164, 207), new Color(194, 163, 234), new Color(189, 139, 158), new Color(187, 171, 252), new Color(184, 141, 223), new Color(170, 108, 237), new Color(163, 175, 226), new Color(157, 163, 197), new Color(151, 148, 244), new Color(151, 80, 148)})};

    public static ColorPool getPool() {
        ColorPool newPool = new ColorPool();
        newPool.setRandomStart();
        return newPool;
    }

    public Color getNext() {
        ++this.nextPointer;
        if (this.nextPointer == this.pool.length) {
            this.nextPointer = 0;
        }
        return this.pool[this.nextPointer].getNext();
    }

    public void setRandomStart() {
        this.nextPointer = this.pool.length > 0 ? (int)Math.round(Math.random() * (double)(this.pool.length - 1)) : 0;
        for (ColorRange range : this.pool) {
            range.setRandomStart();
        }
    }

    public void setDefinedStart(int category, int ... idx) {
        this.nextPointer = category - 1;
        for (int i = 0; i < Math.min(idx.length, this.pool.length); ++i) {
            int cat = (category + i) % this.pool.length;
            this.pool[cat].next = idx[i] - 1;
        }
    }

    public int getSize() {
        int size = 0;
        for (ColorRange range : this.pool) {
            size += range.items.length;
        }
        return size;
    }

    public Color getColor(int category, int idx) {
        this.nextPointer = category;
        this.pool[category].next = idx;
        return this.pool[category].items[idx];
    }

    public Color[][] getColors() {
        Color[][] result = new Color[this.pool.length][];
        int i = 0;
        for (ColorRange range : this.pool) {
            result[i++] = range.items;
        }
        return result;
    }

    private static class ColorRange {
        int next = -1;
        Color[] items;

        ColorRange(Color[] items) {
            this.items = items;
            Arrays.sort(items, new Comparator<Color>(){

                @Override
                public int compare(Color c1, Color c2) {
                    return c2.rgb - c1.rgb;
                }
            });
        }

        Color getNext() {
            ++this.next;
            if (this.next == this.items.length) {
                this.next = 0;
            }
            return this.items[this.next];
        }

        void setRandomStart() {
            this.next = this.items.length > 0 ? (int)Math.round(Math.random() * (double)(this.items.length - 1)) : 0;
        }
    }
}

