/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.renderer;

public class Font {
    private String name;
    private int size;
    private Style style;
    private final int hash;

    public Font(String name, int size, Style style) {
        this.name = name;
        this.size = size;
        this.style = style;
        this.hash = (name + size + style.name()).hashCode();
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public Style getStyle() {
        return this.style;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Font) {
            Font font = (Font)obj;
            return this.name.equals(font.name) && this.size == font.size && this.style == font.style;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public Font getBold() {
        return new Font(this.name, this.size, Style.BOLD);
    }

    public Font getItalic() {
        return new Font(this.name, this.size, Style.ITALIC);
    }

    public static enum Style {
        NORMAL,
        BOLD,
        ITALIC,
        BOLD_ITALIC;

    }
}

