/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.utils;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.ui.graph.LineGraphSelectionToolTipProvider;
import com.sap.jvm.profiling.ui.graph.LineGraphValueBarToolTipProvider;
import com.sap.jvm.profiling.ui.graph.axes.AxisCaptionProviderBase;
import com.sap.jvm.profiling.ui.graph.axes.LineGraphAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.axes.RasterCalculationAdapter;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphPresentationAdapter;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.geometry.Value2DExtended;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class GraphTools {
    private static final long SEC_IN_MS = 1000L;
    private static final long MIN_IN_MS = 60000L;
    private static final long HOUR_IN_MS = 3600000L;
    private static final long DAY_IN_MS = 86400000L;
    public static final LineGraphAxisCaptionProvider AXIS_CAPTION_NR_OF_BYTES = new AxisCaptionProviderBase(){

        @Override
        public String provideScaleUnitCaption(double value, double scale_step, double min, double max) {
            return DataFormatter.getNrOfBytesText((long)((long)value));
        }
    };
    public static final LineGraphAxisCaptionProvider AXIS_CAPTION_MILLIS_DURATION = new AxisCaptionProviderBase(){

        @Override
        public String provideScaleUnitCaption(double value, double scale_step, double min, double max) {
            if (scale_step < 1000.0) {
                return DataFormatter.getMicrosDurationText((long)((long)value * 1000L));
            }
            return DataFormatter.getMillisDurationTextHMS((long)((long)value));
        }
    };
    public static final LineGraphAxisCaptionProvider AXIS_CAPTION_PERCENTAGE = new AxisCaptionProviderBase(){

        @Override
        public String provideScaleUnitCaption(double value, double scale_step, double min, double max) {
            return (int)value + " %";
        }
    };
    public static final RasterCalculationAdapter RASTER_Y_NR_OF_BYTES = new RasterCalculationAdapter(){
        private long[] steps = new long[]{1L, 2L, 5L, 10L, 20L, 50L, 100L, 200L, 512L};

        @Override
        public double adaptRasterSize(double calculatedValue, double min, double max) {
            long factor = 1L;
            while (true) {
                for (int i = 0; i < this.steps.length; ++i) {
                    long raster = this.steps[i] * factor;
                    if (!(calculatedValue < (double)raster)) continue;
                    return raster;
                }
                factor *= 1024L;
            }
        }
    };
    public static final RasterCalculationAdapter RASTER_DURATION = new RasterCalculationAdapter(){
        private static final double MICRO = 1000.0;
        private static final double MILLI = 1000000.0;
        private static final double SEC = 1.0E9;
        private static final double MIN = 6.0E10;
        private static final double HOUR = 3.6E12;
        private static final double DAY = 8.64E13;
        private final double[] decimal_row = new double[]{1.0, 2.0, 5.0, 10.0, 20.0, 25.0, 50.0};
        private final double[] min_sec_row = new double[]{1.0, 2.0, 5.0, 10.0, 20.0, 15.0, 30.0, 60.0};
        private final double[] hour_row = new double[]{1.0, 2.0, 3.0, 6.0, 12.0, 24.0};

        @Override
        public double adaptRasterSize(double calculatedValue, double min, double max) {
            double FACTOR = 1.0;
            double raster = calculatedValue < 1.0 ? 1.0 : calculatedValue;
            double[] row = null;
            if (raster >= 8.64E13) {
                row = this.decimal_row;
                FACTOR = 8.64E13;
            } else if (raster >= 3.6E12) {
                row = this.hour_row;
                FACTOR = 3.6E12;
            } else if (raster >= 6.0E10) {
                row = this.min_sec_row;
                FACTOR = 6.0E10;
            } else if (raster >= 1.0E9) {
                row = this.min_sec_row;
                FACTOR = 1.0E9;
            } else if (raster >= 1000000.0) {
                row = this.decimal_row;
                FACTOR = 1000000.0;
            } else if (raster >= 1000.0) {
                row = this.decimal_row;
                FACTOR = 1000.0;
            } else {
                row = this.decimal_row;
            }
            raster /= FACTOR;
            if (row == this.decimal_row) {
                while (raster > this.decimal_row[this.decimal_row.length - 1]) {
                    raster /= 10.0;
                    FACTOR *= 10.0;
                }
            }
            for (int i = 0; i < row.length; ++i) {
                if (!(row[i] >= raster)) continue;
                return row[i] * FACTOR;
            }
            assert (false);
            return calculatedValue;
        }
    };
    public static final RasterCalculationAdapter RASTER_MILLIS_DURATION = new RasterCalculationAdapter(true){
        private static final double SEC = 1000.0;
        private static final double MIN = 60000.0;
        private static final double HOUR = 3600000.0;
        private static final double DAY = 8.64E7;
        private final double[] decimal_row = new double[]{1.0, 2.0, 5.0, 10.0, 20.0, 25.0, 50.0};
        private final double[] min_sec_row = new double[]{1.0, 2.0, 5.0, 10.0, 20.0, 15.0, 30.0, 60.0};
        private final double[] hour_row = new double[]{1.0, 2.0, 3.0, 6.0, 12.0, 24.0};

        @Override
        public double adaptRasterSize(double calculatedValue, double min, double max) {
            double FACTOR = 1.0;
            double raster = calculatedValue < 1.0 ? 1.0 : calculatedValue;
            double[] row = null;
            if (raster >= 8.64E7) {
                row = this.decimal_row;
                FACTOR = 8.64E7;
            } else if (raster >= 3600000.0) {
                row = this.hour_row;
                FACTOR = 3600000.0;
            } else if (raster >= 60000.0) {
                row = this.min_sec_row;
                FACTOR = 60000.0;
            } else if (raster >= 1000.0) {
                row = this.min_sec_row;
                FACTOR = 1000.0;
            } else {
                row = this.decimal_row;
            }
            raster /= FACTOR;
            if (row == this.decimal_row) {
                while (raster > this.decimal_row[this.decimal_row.length - 1]) {
                    raster /= 10.0;
                    FACTOR *= 10.0;
                }
            }
            for (int i = 0; i < row.length; ++i) {
                if (!(row[i] >= raster)) continue;
                return row[i] * FACTOR;
            }
            assert (false);
            return calculatedValue;
        }
    };
    public static final RasterCalculationAdapter RASTER_X_TIMESTAMP = new RasterCalculationAdapter(){
        private final GregorianCalendar calendar = new GregorianCalendar();

        @Override
        public double adaptRasterSize(double calculatedValue, double min, double max) {
            return RASTER_MILLIS_DURATION.adaptRasterSize(calculatedValue, min, max);
        }

        @Override
        public int getInitialScaleStepSize() {
            return 80;
        }

        @Override
        public double getRasterOrigin(double rasterSize, double min) {
            this.calendar.setTimeInMillis((long)min);
            this.calendar.set(11, 0);
            this.calendar.set(12, 0);
            this.calendar.set(13, 0);
            this.calendar.set(14, 0);
            return this.calendar.getTimeInMillis();
        }
    };
    public static final LineGraphPresentationAdapter MAX_VALUE_PRESENTATION = new LineGraphPresentationAdapter(){

        @Override
        public void createFirstPixelValue(List<Value2D> pixelValues, List<Value2DExtended> visibleSet) {
            this.createPixelValue(pixelValues, visibleSet);
        }

        @Override
        public void createPixelValue(List<Value2D> pixelValues, List<Value2DExtended> visibleSet) {
            Value2DExtended result = new Value2DExtended(pixelValues.get((int)0).x, pixelValues.get((int)0).y);
            for (Value2D v : pixelValues) {
                if (v.emphasized) {
                    result.emphasized = true;
                }
                if (!(result.y < v.y)) continue;
                result.y = v.y;
            }
            visibleSet.add(result);
        }

        @Override
        public void createLastPixelValue(List<Value2D> pixelValues, List<Value2DExtended> visibleSet) {
            this.createPixelValue(pixelValues, visibleSet);
        }
    };
    public static final LineGraphSelectionToolTipProvider TIME_SELECTION_TOOLTIP_PROVIDER = new LineGraphSelectionToolTipProvider(){

        @Override
        public String provideSelectedValueToolTip(LineGraphDataSet graph, List<Value2D> values) {
            return null;
        }

        @Override
        public String provideHorizontalSelectionText(double min, double max) {
            return DataFormatter.getMillisDurationTextHMS((long)((long)(max - min)));
        }
    };
    public static final LineGraphPresentationAdapter IN_MAX_OUT_PEAK_PRESENTATION_ADAPTER = new SimpleLineGraphPresentationAdapter(){

        @Override
        protected void calc(List<Value2D> pixelValues, List<Value2DExtended> visibleSet) {
            if (pixelValues.size() < 4) {
                for (Value2D v : pixelValues) {
                    visibleSet.add(new Value2DExtended(v));
                }
            } else {
                Value2D first = pixelValues.get(0);
                visibleSet.add(new Value2DExtended(first));
                Value2D max = first;
                Value2D lastSeen = null;
                for (int i = 1; i < pixelValues.size(); ++i) {
                    lastSeen = pixelValues.get(i);
                    if (!(lastSeen.y > max.y)) continue;
                    max = lastSeen;
                }
                if (max != first) {
                    visibleSet.add(new Value2DExtended(max));
                }
                if (lastSeen != max && lastSeen.y != max.y) {
                    visibleSet.add(new Value2DExtended(lastSeen));
                }
            }
        }
    };
    public static final LineGraphPresentationAdapter MAX_PEAK_PRESENTATION_ADAPTER = new SimpleLineGraphPresentationAdapter(){

        @Override
        protected void calc(List<Value2D> pixelValues, List<Value2DExtended> visibleSet) {
            Value2D max = null;
            for (Value2D current : pixelValues) {
                if (max != null && !(current.y > max.y)) continue;
                max = current;
            }
            if (max != null) {
                visibleSet.add(new Value2DExtended(max));
            }
        }
    };
    public static final LineGraphPresentationAdapter POS_NEG_PEAK_PRESENTATION_ADAPTER = new SimpleLineGraphPresentationAdapter(){

        @Override
        protected void calc(List<Value2D> pixelValues, List<Value2DExtended> visibleSet) {
            if (pixelValues.isEmpty()) {
                return;
            }
            boolean negative = true;
            Value2D max = null;
            Value2D min = null;
            for (Value2D current : pixelValues) {
                if (current.y > 0.0) {
                    negative = false;
                }
                if (max == null || current.y > max.y) {
                    max = current;
                }
                if (min != null && !(current.y < min.y)) continue;
                min = current;
            }
            visibleSet.add(new Value2DExtended(negative ? min : max));
        }
    };

    public static AxisCaptionProviderBase getTimeStampAxisCaptionProvider(final TimeZone tz) {
        return new AxisCaptionProviderBase(){

            @Override
            public String provideScaleUnitCaption(double value, double scale_step, double min, double max) {
                long ts = (long)value;
                if (scale_step >= 8.64E7) {
                    return DataFormatter.getTimeStampDate((long)ts, (TimeZone)tz);
                }
                if (scale_step >= 3600000.0) {
                    return DataFormatter.getTimeStamp((long)ts, (TimeZone)tz);
                }
                if (scale_step >= 60000.0) {
                    return DataFormatter.getTimeStampTimeNoSeconds((long)ts, (TimeZone)tz);
                }
                if (scale_step >= 1000.0) {
                    return DataFormatter.getTimeStampTime((long)ts, (TimeZone)tz);
                }
                return DataFormatter.getTimeStampTimeDetailed((long)ts, (TimeZone)tz);
            }
        };
    }

    public static final RasterCalculationAdapter createTimeStampRasterAdapter(final int labelWidth) {
        return new RasterCalculationAdapter(){

            @Override
            public double adaptRasterSize(double calculatedValue, double min, double max) {
                return RASTER_X_TIMESTAMP.adaptRasterSize(calculatedValue, min, max);
            }

            @Override
            public int getInitialScaleStepSize() {
                return labelWidth;
            }

            @Override
            public double getRasterOrigin(double rasterSize, double min) {
                return RASTER_X_TIMESTAMP.getRasterOrigin(rasterSize, min);
            }
        };
    }

    public static LineGraphValueBarToolTipProvider getLineGraphValueBarToolTipProvider(final TimeZone tz) {
        return new LineGraphValueBarToolTipProvider(){

            @Override
            public boolean isGraphValueToltipAvailable(LineGraphDataSet graph) {
                return true;
            }

            @Override
            public boolean isBarValueTooltipAvailable() {
                return true;
            }

            @Override
            public String getYAxisValueText(LineGraphDataSet graph, double value) {
                return (int)value + " % " + graph.getName();
            }

            @Override
            public String getXAxisValueText(double value) {
                return DataFormatter.getTimeStampTimeDetailed((long)((long)value), (TimeZone)tz);
            }
        };
    }

    public static abstract class SimpleLineGraphPresentationAdapter
    implements LineGraphPresentationAdapter {
        protected abstract void calc(List<Value2D> var1, List<Value2DExtended> var2);

        @Override
        public void createPixelValue(List<Value2D> pixelValues, List<Value2DExtended> visibleSet) {
            this.calc(pixelValues, visibleSet);
        }

        @Override
        public void createLastPixelValue(List<Value2D> pixelValues, List<Value2DExtended> visibleSet) {
            this.calc(pixelValues, visibleSet);
        }

        @Override
        public void createFirstPixelValue(List<Value2D> pixelValues, List<Value2DExtended> visibleSet) {
            this.calc(pixelValues, visibleSet);
        }
    }
}

