/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public abstract class PercentDistributionCalculator {
    static PercentValue[] valuesV = new PercentValue[]{new PV(1100L), new PV(1100L), new PV(1872L), new PV(137L), new PV(1196L), new PV(96L), new PV(1853L), new PV(1660L), new PV(945L)};

    public static <T extends PercentValue> double calculate(List<T> values, int digits) {
        if (values.size() < 2 && digits > -1) {
            return 0.0;
        }
        int check = (int)Math.pow(10.0, digits + 2);
        double shiftWeight = (double)check / 10.0;
        double shiftPercent = shiftWeight / 10.0;
        double sum = 0.0;
        for (PercentValue v : values) {
            sum += v.getValue();
        }
        double f = 100.0 / sum;
        double sum2 = 0.0;
        int[] result = new int[values.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (int)(((PercentValue)values.get(i)).getValue() * f * shiftPercent);
            sum2 += (double)result[i];
        }
        if (sum2 == (double)check) {
            double r = Math.pow(10.0, digits);
            for (int i = 0; i < result.length; ++i) {
                ((PercentValue)values.get(i)).updatePercent((double)result[i] / r);
            }
        } else {
            int[][] ten = new int[result.length][3];
            for (int i = 0; i < result.length; ++i) {
                ten[i][0] = i;
                ten[i][1] = (int)Math.round(((PercentValue)values.get(i)).getValue() * f * shiftWeight % (double)result[i]);
                ten[i][2] = result[i];
            }
            if (sum2 > (double)check) {
                assert (false);
            } else {
                while (sum2 < (double)check) {
                    PercentDistributionCalculator.sortTendency(ten, false);
                    int w = ten[0][1];
                    ten[0][1] = w - 1;
                    int[] nArray = ten[0];
                    nArray[2] = nArray[2] + 1;
                    sum2 += 1.0;
                    for (int i = 1; i < ten.length && sum2 != (double)check; ++i) {
                        w = ten[i][1];
                        if (w <= 4) continue;
                        ten[i][1] = w - 1;
                        int[] nArray2 = ten[i];
                        nArray2[2] = nArray2[2] + 1;
                        sum2 += 1.0;
                    }
                }
            }
            double r = Math.pow(10.0, digits);
            for (int i = 0; i < ten.length; ++i) {
                ((PercentValue)values.get(ten[i][0])).updatePercent((double)ten[i][2] / r);
            }
        }
        return sum;
    }

    private static void sortTendency(int[][] ten, boolean asc) {
        if (asc) {
            Arrays.sort(ten, new Comparator<int[]>(){

                @Override
                public int compare(int[] o1, int[] o2) {
                    return o1[1] - o2[1];
                }
            });
        } else {
            Arrays.sort(ten, new Comparator<int[]>(){

                @Override
                public int compare(int[] o1, int[] o2) {
                    return o2[1] - o1[1];
                }
            });
        }
    }

    public static void main(String[] args) {
        PercentDistributionCalculator.calculate(Arrays.asList(valuesV), 2);
        long idx = 0L;
        do {
            int vCount = (int)(Math.random() * 10.0);
            PercentValue[] values = new PercentValue[vCount];
            for (int i = 0; i < vCount; ++i) {
                values[i] = new PV((int)(Math.random() * 100.0));
            }
            PercentDistributionCalculator.calculate(Arrays.asList(values), 2);
            double sum = 0.0;
            for (PercentValue v : values) {
                System.out.println(" v: " + v.getValue() + " -> " + ((PV)v).getPercent() + "%");
                sum += ((PV)v).getPercent();
            }
            System.out.println("-----------------");
            System.out.println(sum + "%");
        } while (++idx != 20L);
    }

    private static class PV
    implements PercentValue {
        double value;
        double percent;

        public PV(long value) {
            this.value = value;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        public double getPercent() {
            return this.percent;
        }

        @Override
        public void updatePercent(double p) {
            this.percent = p;
        }
    }

    public static interface PercentValue {
        public double getValue();

        public void updatePercent(double var1);
    }
}

