/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.utils;

import com.sap.jvm.profiling.ui.graph.SingleBarValueChart;
import com.sap.jvm.profiling.ui.graph.dataset.SingeBarDataSet;
import java.util.Timer;
import java.util.TimerTask;

public class SingleBarAnimationHandler {
    private Timer timer = new Timer("Bar Timer", true);
    private Job job = new Job();
    private SingleBarValueChart chart;
    private SingeBarDataSet data;
    private long toValue;

    public SingleBarAnimationHandler(SingleBarValueChart chart, SingeBarDataSet data) {
        this.chart = chart;
        this.data = data;
        this.job.ready = true;
    }

    public void nextValue(long value) {
        if (value < this.data.getValue()) {
            this.toValue = value;
            if (this.job.ready) {
                this.timer.schedule((TimerTask)new Job(), 200L);
            }
        } else {
            this.toValue = value;
            this.data.setValue(value);
            this.chartRefresh();
        }
    }

    private void chartRefresh() {
        this.chart.getRenderer().asyncExec(new Runnable(){

            @Override
            public void run() {
                SingleBarAnimationHandler.this.chart.refresh();
            }
        });
    }

    private class Job
    extends TimerTask {
        boolean ready;

        private Job() {
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            while (SingleBarAnimationHandler.this.data.getValue() > SingleBarAnimationHandler.this.toValue) {
                long value = Math.round((double)SingleBarAnimationHandler.this.data.getValue() - 0.0125 * this.fallDistance(startTime));
                if (value < SingleBarAnimationHandler.this.toValue) {
                    value = SingleBarAnimationHandler.this.toValue;
                }
                SingleBarAnimationHandler.this.data.setValue(value);
                SingleBarAnimationHandler.this.chartRefresh();
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.ready = true;
        }

        double fallDistance(long startTime) {
            double time = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            return 4.905 * time * time * 1000.0;
        }
    }
}

