/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.utils;

import com.sap.jvm.profiling.ui.graph.SingleBarValueChart;
import com.sap.jvm.profiling.ui.graph.dataset.SingeBarDataSet;
import java.util.Timer;
import java.util.TimerTask;

public class SingleBarMarkerAnimationHandler<T extends SingeBarDataSet> {
    static Timer timer = new Timer("Bars Timer", true);
    Job job = new Job();
    SingleBarValueChart chart;
    T data;
    SingeBarDataSet.ValueMarker marker;

    public SingleBarMarkerAnimationHandler(SingleBarValueChart chart, T data) {
        this.marker = ((SingeBarDataSet)data).setValueMarker(((SingeBarDataSet)data).getValue(), "");
        this.chart = chart;
        this.data = data;
        this.job.ready = true;
    }

    public T getDataSet() {
        return this.data;
    }

    public void nextValue(long value) {
        if (value < this.marker.getValue()) {
            ((SingeBarDataSet)this.data).setValue(value);
            this.chartRefresh();
            if (this.job.ready) {
                this.job = new Job();
                timer.schedule((TimerTask)this.job, 200L);
            }
        } else {
            ((SingeBarDataSet)this.data).setValue(value);
            this.marker.setValue(value);
            this.chartRefresh();
        }
    }

    public void nextValue(NextValueAdaptor<T> value) {
        long totalValue = value.getTotalValue();
        if (totalValue < this.marker.getValue()) {
            value.updateValues(this.data);
            this.chartRefresh();
            if (this.job.ready) {
                this.job = new Job();
                timer.schedule((TimerTask)this.job, 200L);
            }
        } else {
            value.updateValues(this.data);
            this.marker.setValue(totalValue);
            this.chartRefresh();
        }
    }

    private void chartRefresh() {
        this.chart.getRenderer().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!SingleBarMarkerAnimationHandler.this.chart.getRenderer().isVisibleInitialized()) {
                    return;
                }
                SingleBarMarkerAnimationHandler.this.chart.refresh();
            }
        });
    }

    private class Job
    extends TimerTask {
        boolean ready;

        private Job() {
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            while (SingleBarMarkerAnimationHandler.this.marker.getValue() > ((SingeBarDataSet)SingleBarMarkerAnimationHandler.this.data).getValue()) {
                long value = Math.round((double)SingleBarMarkerAnimationHandler.this.marker.getValue() - 0.0125 * this.fallDistance(startTime));
                if (value < ((SingeBarDataSet)SingleBarMarkerAnimationHandler.this.data).getValue()) {
                    value = ((SingeBarDataSet)SingleBarMarkerAnimationHandler.this.data).getValue();
                }
                SingleBarMarkerAnimationHandler.this.marker.setValue(value);
                SingleBarMarkerAnimationHandler.this.chartRefresh();
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.ready = true;
        }

        double fallDistance(long startTime) {
            double time = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            return 4.905 * time * time * 1000.0;
        }
    }

    public static interface NextValueAdaptor<T extends SingeBarDataSet> {
        public long getTotalValue();

        public void updateValues(T var1);
    }
}

