/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class LongestCommonSubsequence<VALUE> {
    private int[][] c;
    private List<DiffEntry<VALUE>> diff;
    private List<VALUE> backtrack;

    protected LongestCommonSubsequence() {
    }

    protected abstract int lengthOfY();

    protected abstract int lengthOfX();

    protected abstract VALUE valueOfX(int var1);

    protected abstract VALUE valueOfY(int var1);

    protected boolean equals(VALUE x1, VALUE y1) {
        if (x1 == null) {
            return y1 == null;
        }
        return x1.equals(y1);
    }

    private boolean isXYEqual(int i, int j) {
        return this.equals(this.valueOfXInternal(i), this.valueOfYInternal(j));
    }

    private VALUE valueOfXInternal(int i) {
        return this.valueOfX(i - 1);
    }

    private VALUE valueOfYInternal(int j) {
        return this.valueOfY(j - 1);
    }

    public void calculateLcs() {
        int i;
        if (this.c != null) {
            return;
        }
        this.c = new int[this.lengthOfX() + 1][];
        for (i = 0; i < this.c.length; ++i) {
            this.c[i] = new int[this.lengthOfY() + 1];
        }
        for (i = 1; i < this.c.length; ++i) {
            for (int j = 1; j < this.c[i].length; ++j) {
                this.c[i][j] = this.isXYEqual(i, j) ? this.c[i - 1][j - 1] + 1 : Math.max(this.c[i][j - 1], this.c[i - 1][j]);
            }
        }
    }

    public int getLcsLength() {
        this.calculateLcs();
        return this.c[this.lengthOfX()][this.lengthOfY()];
    }

    public int getMinEditDistance() {
        this.calculateLcs();
        return this.lengthOfX() + this.lengthOfY() - 2 * Math.abs(this.getLcsLength());
    }

    public List<VALUE> backtrack() {
        this.calculateLcs();
        if (this.backtrack == null) {
            this.backtrack = new ArrayList<VALUE>();
            this.backtrack(this.lengthOfX(), this.lengthOfY());
        }
        return this.backtrack;
    }

    public void backtrack(int i, int j) {
        this.calculateLcs();
        if (i == 0 || j == 0) {
            return;
        }
        if (this.isXYEqual(i, j)) {
            this.backtrack(i - 1, j - 1);
            this.backtrack.add(this.valueOfXInternal(i));
        } else if (this.c[i][j - 1] > this.c[i - 1][j]) {
            this.backtrack(i, j - 1);
        } else {
            this.backtrack(i - 1, j);
        }
    }

    public List<DiffEntry<VALUE>> diff() {
        this.calculateLcs();
        if (this.diff == null) {
            this.diff = new ArrayList<DiffEntry<VALUE>>();
            this.diff(this.lengthOfX(), this.lengthOfY());
        }
        return this.diff;
    }

    private void diff(int k, int m) {
        int i = k;
        int j = m;
        this.calculateLcs();
        while (i != 0 || j != 0) {
            if (i > 0 && j > 0 && this.isXYEqual(i, j)) {
                this.diff.add(new DiffEntry<VALUE>(DiffType.NONE, this.valueOfXInternal(i)));
                --i;
                --j;
                continue;
            }
            if (j > 0 && (i == 0 || this.c[i][j - 1] >= this.c[i - 1][j])) {
                this.diff.add(new DiffEntry<VALUE>(DiffType.ADD, this.valueOfYInternal(j)));
                --j;
                continue;
            }
            if (i <= 0 || j != 0 && this.c[i][j - 1] >= this.c[i - 1][j]) continue;
            this.diff.add(new DiffEntry<VALUE>(DiffType.REMOVE, this.valueOfXInternal(i)));
            --i;
        }
        Collections.reverse(this.diff);
    }

    public String toString() {
        int j;
        this.calculateLcs();
        StringBuffer buf = new StringBuffer();
        buf.append("  ");
        for (j = 1; j <= this.lengthOfY(); ++j) {
            buf.append(this.valueOfYInternal(j));
        }
        buf.append("\n");
        buf.append(" ");
        for (j = 0; j < this.c[0].length; ++j) {
            buf.append(Integer.toString(this.c[0][j]));
        }
        buf.append("\n");
        for (int i = 1; i < this.c.length; ++i) {
            buf.append(this.valueOfXInternal(i));
            for (int j2 = 0; j2 < this.c[i].length; ++j2) {
                buf.append(Integer.toString(this.c[i][j2]));
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public static class DiffEntry<VALUE> {
        private DiffType type;
        private VALUE value;

        public DiffEntry(DiffType type, VALUE value) {
            this.type = type;
            this.value = value;
        }

        public DiffType getType() {
            return this.type;
        }

        public void setType(DiffType type) {
            this.type = type;
        }

        public VALUE getValue() {
            return this.value;
        }

        public void setValue(VALUE value) {
            this.value = value;
        }

        public String toString() {
            return this.type.toString() + this.value.toString();
        }
    }

    public static enum DiffType {
        ADD("+", "add"),
        REMOVE("-", "remove"),
        NONE(" ", "none");

        private String val;
        private String name;

        private DiffType(String val, String name) {
            this.val = val;
            this.name = name;
        }

        public String toString() {
            return this.val;
        }

        public String getName() {
            return this.name;
        }

        public String getVal() {
            return this.val;
        }
    }
}

