/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.viewer;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.util.IdentityHashSet;
import com.sap.jvm.profiling.viewer.TaskManager;
import com.sap.jvm.tracing.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BatchTaskManager
implements TaskManager {
    private static final ExecutorService threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    });
    private Thread currentForegroundThread;
    private final LinkedList<Future<?>> backgroundTasks = new LinkedList();
    private final LinkedList<Future<?>> foregroundTasks = new LinkedList();

    @Override
    public ProgressReporter getNodeCreationProgressReporter() {
        return new ProgressReporter();
    }

    @Override
    public ProgressReporter getRootCreationProgressReporter() {
        return new ProgressReporter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performBackgroundTask(Runnable runnable) {
        LinkedList<Future<?>> linkedList = this.backgroundTasks;
        synchronized (linkedList) {
            this.backgroundTasks.add(threadPool.submit(runnable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void performForegroundTask(final Runnable runnable) {
        Future<?> future = null;
        try {
            while (true) {
                LinkedList<Future<?>> linkedList = this.foregroundTasks;
                synchronized (linkedList) {
                    if (this.currentForegroundThread == Thread.currentThread()) {
                        runnable.run();
                        return;
                    }
                    if (this.foregroundTasks.isEmpty()) {
                        future = threadPool.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    BatchTaskManager.this.currentForegroundThread = Thread.currentThread();
                                    runnable.run();
                                    BatchTaskManager.this.currentForegroundThread = null;
                                }
                                catch (Throwable t) {
                                    Trace.error((Throwable)t, (String)"Foreground task failed");
                                }
                            }
                        });
                        this.foregroundTasks.add(future);
                        // MONITOREXIT @DISABLED, blocks:[0, 19, 20, 10] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                        future.get();
                        return;
                    }
                    try {
                        this.foregroundTasks.wait();
                    }
                    catch (InterruptedException e) {
                        Trace.error((Throwable)e, (String)"Foreground task was interrupted");
                    }
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return;
        }
        finally {
            LinkedList<Future<?>> linkedList = this.foregroundTasks;
            synchronized (linkedList) {
                this.foregroundTasks.remove(future);
                this.foregroundTasks.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTasks() {
        while (true) {
            BatchTaskManager.waitForTasks(this.backgroundTasks);
            BatchTaskManager.waitForTasks(this.foregroundTasks);
            LinkedList<Future<?>> linkedList = this.backgroundTasks;
            synchronized (linkedList) {
                LinkedList<Future<?>> linkedList2 = this.foregroundTasks;
                synchronized (linkedList2) {
                    if (this.backgroundTasks.isEmpty() && this.foregroundTasks.isEmpty()) {
                        return;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForTasks(LinkedList<Future<?>> taskList) {
        ArrayList tasksCopy;
        LinkedList<Future<?>> linkedList = taskList;
        synchronized (linkedList) {
            tasksCopy = new ArrayList(taskList);
        }
        IdentityHashSet futureHashSet = new IdentityHashSet();
        for (Future<?> future : tasksCopy) {
            try {
                future.get();
                futureHashSet.add(future);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        LinkedList<Future<?>> linkedList2 = taskList;
        synchronized (linkedList2) {
            Iterator it = taskList.iterator();
            while (it.hasNext()) {
                if (!futureHashSet.contains(it.next())) continue;
                it.remove();
            }
        }
    }
}

