/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.viewer;

import com.sap.jvm.profiling.resource.BasicResourceReader;
import com.sap.jvm.profiling.resource.BasicResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.viewer.ScreenViewState;
import java.io.IOException;

public final class ColumnViewState
implements ScreenViewState {
    private static final int VERSION = 2;
    private final int topItem;
    private final int widthDefiningRow;
    private final double[] columnWidths;
    private final double scrollPos;

    public ColumnViewState(int topItem, int widthDefiningRow, double[] columnWidths, double scrollPos) {
        this.topItem = topItem;
        this.widthDefiningRow = widthDefiningRow;
        this.columnWidths = columnWidths;
        this.scrollPos = scrollPos;
    }

    public ColumnViewState(BasicResourceReader reader) throws IOException {
        int i;
        int version = reader.readVersion(0, 2);
        this.topItem = reader.readInt32();
        this.widthDefiningRow = reader.readInt32();
        int nrOfColumns = reader.readInt32();
        this.columnWidths = new double[nrOfColumns];
        for (i = 0; i < nrOfColumns; ++i) {
            this.columnWidths[i] = reader.readDouble();
        }
        this.scrollPos = reader.readDouble();
        if (version == 1) {
            for (i = 0; i < nrOfColumns; ++i) {
                reader.readInt32();
            }
        }
    }

    public int getTopItem() {
        return this.topItem;
    }

    public int getWidthDefiningRow() {
        return this.widthDefiningRow;
    }

    public double[] getColumnWidths() {
        return this.columnWidths;
    }

    public double getScrollPos() {
        return this.scrollPos;
    }

    @Override
    public void write(BasicResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(2);
        writer.writeInt32(this.topItem);
        writer.writeInt32(this.widthDefiningRow);
        writer.writeInt32(this.columnWidths.length);
        for (double width : this.columnWidths) {
            writer.writeDouble(width);
        }
        writer.writeDouble(this.scrollPos);
    }
}

