/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.viewer;

import com.sap.jvm.profiling.resource.BasicResourceReader;
import com.sap.jvm.profiling.resource.BasicResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.viewer.ScreenViewState;
import java.io.IOException;

public class TimeSeriesViewState
implements ScreenViewState {
    private static final int VERSION = 3;
    private final int[] relativeHeights;
    private final long startX;
    private boolean showAbsoluteTime;
    private final long endX;
    private final long xOffset;
    private LegendPosition[] legendPositions;
    private boolean detailedValueBar;

    public TimeSeriesViewState(int[] relativeHeights, long startX, long endX, long xOffset, boolean showAbsoluteTime, LegendPosition[] legendPositions, boolean detailedValueBar) {
        this.relativeHeights = relativeHeights;
        this.startX = startX;
        this.endX = endX;
        this.xOffset = xOffset;
        this.showAbsoluteTime = showAbsoluteTime;
        this.legendPositions = legendPositions;
        this.detailedValueBar = detailedValueBar;
    }

    public TimeSeriesViewState(BasicResourceReader reader, ProgressReporter reporter) throws IOException {
        int i;
        int version = reader.readVersion(0, 3);
        this.relativeHeights = new int[reader.readInt32()];
        this.legendPositions = new LegendPosition[this.relativeHeights.length];
        for (i = 0; i < this.relativeHeights.length; ++i) {
            this.relativeHeights[i] = reader.readInt32();
        }
        this.startX = reader.readInt64();
        this.endX = reader.readInt64();
        this.xOffset = reader.readInt64();
        if (version > 0) {
            for (i = 0; i < this.legendPositions.length; ++i) {
                boolean positionAvailable = reader.readBoolean();
                if (!positionAvailable) continue;
                this.legendPositions[i] = new LegendPosition(reader, reporter);
            }
        }
        if (version > 1) {
            this.showAbsoluteTime = reader.readBoolean();
            if (version > 2) {
                this.detailedValueBar = reader.readBoolean();
            }
        }
    }

    public int[] getRelativeHeights() {
        return this.relativeHeights;
    }

    public long getStartX() {
        return this.startX;
    }

    public long getEndX() {
        return this.endX;
    }

    public long getXOffset() {
        return this.xOffset;
    }

    public boolean isShowingAbsoluteTime() {
        return this.showAbsoluteTime;
    }

    public boolean hasDetailedValueBar() {
        return this.detailedValueBar;
    }

    public LegendPosition[] getLegendPositions() {
        return this.legendPositions;
    }

    @Override
    public void write(BasicResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(3);
        writer.writeInt32(this.relativeHeights.length);
        for (int relativeHeight : this.relativeHeights) {
            writer.writeInt32(relativeHeight);
        }
        writer.writeInt64(this.startX);
        writer.writeInt64(this.endX);
        writer.writeInt64(this.xOffset);
        for (int i = 0; i < this.legendPositions.length; ++i) {
            if (this.legendPositions[i] == null) {
                writer.writeBoolean(false);
                continue;
            }
            writer.writeBoolean(true);
            this.legendPositions[i].write(writer, reporter);
        }
        writer.writeBoolean(this.showAbsoluteTime);
        writer.writeBoolean(this.detailedValueBar);
    }

    public static class LegendPosition {
        public final boolean pinned;
        public final int anchorIndex;
        public final int chartIndex;
        public final double relX;
        public final double relY;

        public LegendPosition(int chartIndex, int anchorIndex) {
            this.pinned = true;
            this.anchorIndex = anchorIndex;
            this.chartIndex = chartIndex;
            this.relX = 0.0;
            this.relY = 0.0;
        }

        public LegendPosition(double relX, double relY) {
            this.pinned = false;
            this.anchorIndex = 0;
            this.chartIndex = 0;
            this.relX = relX;
            this.relY = relY;
        }

        public LegendPosition(BasicResourceReader reader, ProgressReporter reporter) throws IOException {
            this.pinned = reader.readBoolean();
            if (this.pinned) {
                this.anchorIndex = reader.readInt32();
                this.chartIndex = reader.readInt32();
                this.relX = 0.0;
                this.relY = 0.0;
            } else {
                this.anchorIndex = 0;
                this.chartIndex = 0;
                this.relX = reader.readDouble();
                this.relY = reader.readDouble();
            }
        }

        public void write(BasicResourceWriter writer, ProgressReporter reporter) throws IOException {
            writer.writeBoolean(this.pinned);
            if (this.pinned) {
                writer.writeInt32(this.anchorIndex);
                writer.writeInt32(this.chartIndex);
            } else {
                writer.writeDouble(this.relX);
                writer.writeDouble(this.relY);
            }
        }
    }
}

