/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.viewer.graph;

import com.sap.jvm.profiling.ui.graph.BarGraphChart;
import com.sap.jvm.profiling.ui.graph.BarGraphSelectionListener;
import com.sap.jvm.profiling.ui.graph.BarGraphToolTipProvider;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.PieGraphChart;
import com.sap.jvm.profiling.ui.graph.PieGraphSelectionListener;
import com.sap.jvm.profiling.ui.graph.dataset.BarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.ColoredBarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.PieGraphDataSet;
import com.sap.jvm.profiling.ui.graph.legend.BarGraphLegendContributor;
import com.sap.jvm.profiling.ui.graph.legend.PieGraphLegendContributor;
import com.sap.jvm.profiling.viewer.graph.BarGraphRenderer;
import com.sap.jvm.profiling.viewer.graph.BarGraphRendererProvider;
import com.sap.jvm.profiling.viewer.graph.PieGraphRenderer;
import com.sap.jvm.profiling.viewer.graph.PieGraphRendererProvider;
import com.sap.jvm.profiling.viewer.graph.ValueSetModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class GraphHelper {
    private static int[] columnsForGraphs = new int[]{1, 2, 3, 2};
    private final Runnable selectionUpdater;
    private final ArrayList<String> titles;
    private final ArrayList<Object> graphCharts;

    private GraphHelper(Runnable selectionUpdater, ArrayList<String> titles, ArrayList<Object> graphCharts) {
        this.selectionUpdater = selectionUpdater;
        this.titles = titles;
        this.graphCharts = graphCharts;
    }

    public void updateSelection() {
        this.selectionUpdater.run();
    }

    public String getTitle(int idx) {
        return this.titles.get(idx);
    }

    public Object getChart(int idx) {
        return this.graphCharts.get(idx);
    }

    public static int[] getVisibleColumns(ValueSetModel model) {
        int[] result = new int[GraphHelper.getNrOfVisibleColumns(model)];
        int index = 0;
        for (int i = 0; i < model.getNrOfColumns(); ++i) {
            if (!model.isColumnVisible(i)) continue;
            result[index] = i;
            ++index;
        }
        return result;
    }

    public static int getNrOfVisibleColumns(ValueSetModel model) {
        int result = 0;
        for (int i = 0; i < model.getNrOfColumns(); ++i) {
            if (!model.isColumnVisible(i)) continue;
            ++result;
        }
        return result;
    }

    public static int getNrOfDisplayedColumns(ValueSetModel model) {
        int index = GraphHelper.getNrOfVisibleColumns(model) - 1;
        if (index < 0) {
            return 0;
        }
        if (columnsForGraphs.length > index) {
            return columnsForGraphs[index];
        }
        return 3;
    }

    public static GraphHelper create(BarGraphRendererProvider provider, final GraphChartContainer container, final ValueSetModel model, int[] visibleColumns, final boolean removeChartTitles, boolean markSelected) {
        final int[] sortedVisibleColumns = (int[])visibleColumns.clone();
        Arrays.sort(sortedVisibleColumns);
        final int nrOfColumns = model.getNrOfColumns();
        final ColoredBarGraphDataSet[] graphs = new ColoredBarGraphDataSet[nrOfColumns];
        final BarGraphRenderer[] renderers = new BarGraphRenderer[nrOfColumns];
        final ArrayList<BarGraphChart> charts = new ArrayList<BarGraphChart>();
        int[] selectedRows = model.getSelectedRows();
        int column = 0;
        int chartIdx = 0;
        BarGraphLegendContributor legendCreator = new BarGraphLegendContributor(container);
        for (int i = 0; i < nrOfColumns; ++i) {
            BarGraphRenderer renderer;
            if (Arrays.binarySearch(sortedVisibleColumns, i) < 0) continue;
            BarGraphChart chart = new BarGraphChart(container, true, true);
            charts.add(chart);
            container.addChart(chart);
            legendCreator.registerChartLegendContributor(chart);
            renderers[i] = renderer = provider.getRenderer(i, column, container);
            graphs[i] = renderer.getDataSet();
            chart.addGraph(graphs[i]);
            if (markSelected) {
                for (int selectedEntry : selectedRows) {
                    chart.setSingleSelection(graphs[i], graphs[i].getValueAt(selectedEntry), true, true);
                }
            }
            container.setChartTitle(graphs[i].getName(), chartIdx++);
            chart.setAxesCaptionProvider(renderer.getAxisCaptionProvider());
            chart.setRangeAxisAdaptor(null, renderer.getYAxisAdapter());
            chart.setRasterAdaptor(renderer.getRasterCalculationAdapter());
            chart.addSelectionListener(new BarGraphSelectionListener(){

                @Override
                public void selectionChanged(BarGraphChart.BarSelectedValues selection, boolean selected) {
                    GraphHelper.changeSelection(model, selection.getSelectedValues(), selected);
                }
            });
            ++column;
        }
        final ArrayList<String> titles = new ArrayList<String>();
        for (BarGraphChart chart : charts) {
            chart.setToolTipProvider(new BarGraphToolTipProvider(){

                @Override
                public String provideToolTip(BarGraphDataSet data, int idx) {
                    for (int i = 0; i < graphs.length; ++i) {
                        if (data != graphs[i]) continue;
                        BarGraphRenderer renderer = renderers[i];
                        return renderer.getToolTipProvider().provideToolTip(data, idx);
                    }
                    return null;
                }
            });
        }
        container.setInitializer(new Runnable(){

            @Override
            public void run() {
                int index = 0;
                for (int i = 0; i < nrOfColumns; ++i) {
                    if (Arrays.binarySearch(sortedVisibleColumns, i) < 0) continue;
                    BarGraphChart chart = (BarGraphChart)charts.get(index);
                    chart.initAxes();
                    chart.adjustXAxis(0L, graphs[i].getSize());
                    titles.add(container.getChartTitle(index));
                    if (removeChartTitles) {
                        container.setChartTitle(null, index);
                    }
                    ++index;
                }
            }
        });
        return new GraphHelper(new Runnable(){

            @Override
            public void run() {
                int idx = 0;
                int[] selection = model.getSelectedRows();
                for (int i = 0; i < graphs.length; ++i) {
                    if (Arrays.binarySearch(sortedVisibleColumns, i) < 0) continue;
                    ColoredBarGraphDataSet data = graphs[i];
                    BarGraphChart chart = (BarGraphChart)charts.get(idx);
                    chart.resetSelection(data, true);
                    for (int selected : selection) {
                        chart.setSingleSelection(data, data.getValueAt(selected), true, false);
                    }
                    ++idx;
                }
            }
        }, titles, new ArrayList<Object>(charts));
    }

    public static GraphHelper create(PieGraphRendererProvider provider, GraphChartContainer container, final ValueSetModel model, int[] visibleColumns, boolean markSelected) {
        int[] sortedVisibleColumns = (int[])visibleColumns.clone();
        Arrays.sort(sortedVisibleColumns);
        int nrOfColumns = model.getNrOfColumns();
        final PieGraphDataSet[] graphs = new PieGraphDataSet[nrOfColumns];
        final ArrayList<PieGraphChart> charts = new ArrayList<PieGraphChart>();
        int column = 0;
        ArrayList<String> titles = new ArrayList<String>();
        PieGraphLegendContributor legendCreator = new PieGraphLegendContributor(container);
        for (int i = 0; i < nrOfColumns; ++i) {
            if (Arrays.binarySearch(visibleColumns, i) < 0) continue;
            PieGraphChart chart = new PieGraphChart(container);
            charts.add(chart);
            container.addChart(chart);
            titles.add(container.getChartTitle(column));
            legendCreator.registerChartLegendContributor(chart);
            PieGraphRenderer renderer = provider.getRenderer(i, column, chart);
            graphs[i] = renderer.getDataSet(markSelected);
            chart.addGraph(graphs[i]);
            container.setChartTitle(graphs[i].getName(), column);
            legendCreator.updateLegend();
            chart.setToolTipsProvider(graphs[i], renderer.getToolTipProvider());
            chart.addSelectionListener(graphs[i], new PieGraphSelectionListener(){

                @Override
                public void selectionChanged(PieGraphDataSet set, PieGraphDataSet.PiePiece piece) {
                    int idx = 0;
                    for (PieGraphDataSet.PiePiece p : set.getPieces()) {
                        if (piece == p) {
                            GraphHelper.changeSelection(model, new int[]{idx}, p.isSelected());
                        }
                        ++idx;
                    }
                }
            });
            ++column;
        }
        return new GraphHelper(new Runnable(){

            @Override
            public void run() {
                for (PieGraphChart chart : charts) {
                    chart.resetSelection(false, true);
                    int[] selection = model.getSelectedRows();
                    for (int i = 0; i < graphs.length; ++i) {
                        if (!model.isColumnVisible(i)) continue;
                        PieGraphDataSet data = graphs[i];
                        for (int selected : selection) {
                            chart.setSelection(data, data.getPieces().get(selected), true, false);
                        }
                    }
                }
            }
        }, titles, new ArrayList<Object>(charts));
    }

    private static void changeSelection(ValueSetModel model, int[] rows, boolean selected) {
        HashSet<Integer> selection = new HashSet<Integer>();
        for (int row : model.getSelectedRows()) {
            selection.add(row);
        }
        if (selected) {
            for (int row : rows) {
                selection.add(row);
            }
        } else {
            for (int row : rows) {
                selection.remove(row);
            }
        }
        int[] newSelection = new int[selection.size()];
        int idx = 0;
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int row;
            newSelection[idx] = row = ((Integer)iterator.next()).intValue();
            ++idx;
        }
        model.setSelectedRows(newSelection);
    }
}

