/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.viewer.renderer;

import com.sap.jvm.profiling.ui.graph.SingleBarValueChart;
import com.sap.jvm.profiling.ui.graph.dataset.SingeBarDataSet;
import com.sap.jvm.profiling.viewer.renderer.AbstractChartRendererNode;
import java.text.DecimalFormat;

public class BarChartNode
extends AbstractChartRendererNode<SingleBarValueChart, BarChartNode> {
    private static final DecimalFormat format = new DecimalFormat("##0.00 %");
    private SingeBarDataSet data = new SingeBarDataSet();

    public SingeBarDataSet getData() {
        return this.data;
    }

    public void setData(SingeBarDataSet data) {
        this.data = data;
    }

    public void setMaxValue(long max) {
        this.data.setMaxValue(max);
    }

    public long getMaxValue() {
        return this.data.getMaxValue();
    }

    public void setValue(long value) {
        this.data.setValue(value);
    }

    public long getValue() {
        return this.data.getValue();
    }

    public double getPercentValue() {
        return this.data.getPercent();
    }

    public String getPercentValueAsString() {
        return format.format(this.getPercentValue());
    }

    public String getBarHeader() {
        return this.data.getValueDescription();
    }

    public void setBarHeader(String barHeader) {
        this.data.setValueDescription(barHeader);
    }

    @Override
    public String asString() {
        StringBuilder text = new StringBuilder();
        text.append(this.getBarHeader());
        text.append(' ');
        text.append(this.getValue());
        text.append(" of ");
        text.append(this.getMaxValue());
        text.append(' ');
        text.append(format.format(this.getPercentValue()));
        return text.toString();
    }

    @Override
    public String asValueString() {
        return this.asString();
    }
}

