/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.viewer.renderer;

import com.sap.jvm.profiling.ui.graph.LineGraphChart;
import com.sap.jvm.profiling.ui.graph.LineGraphSimpleChart;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.viewer.renderer.AbstractChartRendererNode;
import java.util.ArrayList;
import java.util.List;

public class LineChartNode
extends AbstractChartRendererNode<LineGraphSimpleChart, LineChartNode> {
    private double xRangeMin = 0.0;
    private double xRangeMax = 100.0;
    private double yRangeMin = 0.0;
    private double yRangeMax = 100.0;
    private ArrayList<LineGraphDataSet> dataSets = new ArrayList();
    private LineGraphDataSet currentDataSet = null;
    private String title;

    public LineChartNode() {
        this.addDataSet(LineGraphChart.createDataSet(""));
    }

    public void setData(LineGraphDataSet data) {
        this.removeAll();
        this.addDataSet(data);
    }

    public String getTitle() {
        return this.title != null ? this.title : this.dataSets.get(0).getName();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<LineGraphDataSet> getData() {
        return this.dataSets;
    }

    public void addDataSet(LineGraphDataSet data) {
        this.dataSets.add(data);
        this.currentDataSet = data;
    }

    public void addValue(double x, double y) {
        this.currentDataSet.addValue(x, y);
    }

    public void removeAll() {
        this.dataSets.clear();
    }

    public void setXValueRange(double min, double max) {
        this.xRangeMin = min;
        this.xRangeMax = max;
    }

    public void setYValueRange(double min, double max) {
        this.yRangeMin = min;
        this.yRangeMax = max;
    }

    public void adaptRangeToData() {
        this.xRangeMin = Double.MAX_VALUE;
        this.yRangeMin = Double.MAX_VALUE;
        this.xRangeMax = Double.MIN_VALUE;
        this.yRangeMax = Double.MIN_VALUE;
        for (LineGraphDataSet set : this.dataSets) {
            if (set.isEmpty()) continue;
            this.xRangeMin = Math.min(set.getMinX(), this.xRangeMin);
            this.xRangeMax = Math.max(set.getMaxX(), this.xRangeMax);
            this.yRangeMin = Math.min(set.getMinY(), this.yRangeMin);
            this.yRangeMax = Math.max(set.getMaxY(), this.yRangeMax);
        }
        if (this.xRangeMin == Double.MAX_VALUE) {
            this.xRangeMin = 0.0;
            this.xRangeMax = 10.0;
        }
        if (this.yRangeMin == Double.MAX_VALUE) {
            this.yRangeMin = 0.0;
            this.yRangeMax = 10.0;
        }
    }

    public double getXRangeMin() {
        return this.xRangeMin;
    }

    public double getXRangeMax() {
        return this.xRangeMax;
    }

    public double getYRangeMin() {
        return this.yRangeMin;
    }

    public double getYRangeMax() {
        return this.yRangeMax;
    }

    public void copyValues(LineChartNode other) {
        assert (false);
    }

    @Override
    public String asString() {
        StringBuilder text = new StringBuilder("Line Chart with ");
        text.append(this.dataSets.size());
        text.append(" data sets");
        return text.toString();
    }

    @Override
    public String asValueString() {
        return this.asString();
    }
}

