/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.viewer.renderer;

import com.sap.jvm.profiling.ui.graph.PieGraphChart;
import com.sap.jvm.profiling.ui.graph.dataset.PieGraphDataSet;
import com.sap.jvm.profiling.viewer.renderer.AbstractChartRendererNode;

public class PieChartNode
extends AbstractChartRendererNode<PieGraphChart, PieChartNode> {
    private PieGraphDataSet pieGraphDataSet = new PieGraphDataSet();
    private boolean enableLegend;
    private boolean enableLegendItemsWithPercent;

    public PieGraphDataSet getData() {
        return this.pieGraphDataSet;
    }

    public void setData(PieGraphDataSet data) {
        this.pieGraphDataSet = data;
    }

    public void addValue(double value) {
        this.pieGraphDataSet.addValue(value, "");
    }

    public void addValue(double value, String description) {
        this.pieGraphDataSet.addValue(value, description);
    }

    public int getValuesCount() {
        return this.pieGraphDataSet.getPieces().size();
    }

    public double getValueAt(int pos) {
        return this.pieGraphDataSet.getPiece(pos).getValue();
    }

    public void copyValues(PieChartNode other) {
        this.pieGraphDataSet.clear();
        for (PieGraphDataSet.PiePiece p : other.pieGraphDataSet.getPieces()) {
            this.pieGraphDataSet.addValue(p.getValue(), p.getName());
        }
        this.pieGraphDataSet.changeName(other.pieGraphDataSet.getName());
        this.enableLegend = other.enableLegend;
    }

    public void setTitle(String title) {
        this.pieGraphDataSet.changeName(title);
    }

    public String getTitle() {
        return this.pieGraphDataSet.getName();
    }

    public void setLegendEnabled(boolean enabled) {
        this.enableLegend = enabled;
    }

    public boolean isLegendEnabled() {
        return this.enableLegend;
    }

    public void setLegendItemsWithPercentEnabled(boolean enable) {
        this.enableLegendItemsWithPercent = enable;
    }

    public boolean isLegendItemsWithPercentEnabled() {
        return this.enableLegendItemsWithPercent;
    }

    @Override
    public String asString() {
        StringBuilder text = new StringBuilder("Pie Chart ");
        text.append(this.getValuesCount());
        text.append(" pieces");
        return text.toString();
    }

    @Override
    public String asValueString() {
        return this.asString();
    }
}

