/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.viewer.renderer;

import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.AlignNode;
import com.sap.jvm.profiling.viewer.renderer.AlternateNode;
import com.sap.jvm.profiling.viewer.renderer.BarChartNode;
import com.sap.jvm.profiling.viewer.renderer.ChangeBoldNode;
import com.sap.jvm.profiling.viewer.renderer.ChangeItalicsNode;
import com.sap.jvm.profiling.viewer.renderer.ColorNode;
import com.sap.jvm.profiling.viewer.renderer.FixedWidthNode;
import com.sap.jvm.profiling.viewer.renderer.FontSizeChangeNode;
import com.sap.jvm.profiling.viewer.renderer.ImageNode;
import com.sap.jvm.profiling.viewer.renderer.LineChartNode;
import com.sap.jvm.profiling.viewer.renderer.LinkNode;
import com.sap.jvm.profiling.viewer.renderer.LongAndShortTextNode;
import com.sap.jvm.profiling.viewer.renderer.MultiChildNode;
import com.sap.jvm.profiling.viewer.renderer.NumberNode;
import com.sap.jvm.profiling.viewer.renderer.OrderedMultiChildNode;
import com.sap.jvm.profiling.viewer.renderer.OverlayImageNode;
import com.sap.jvm.profiling.viewer.renderer.PercentageBarNode;
import com.sap.jvm.profiling.viewer.renderer.PieChartNode;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.SeparatorNode;
import com.sap.jvm.profiling.viewer.renderer.SpaceNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public class RendererNodeUtils {
    public static RendererNode copy(ModelViewer viewer, RendererNode toCopy) {
        if (toCopy == null) {
            return null;
        }
        if (toCopy instanceof AlignNode) {
            AlignNode alignNode = (AlignNode)toCopy;
            return viewer.newAlignNode(alignNode.getAlignment(), RendererNodeUtils.copy(viewer, alignNode.getChild()));
        }
        if (toCopy instanceof AlternateNode) {
            AlternateNode alternateNode = (AlternateNode)toCopy;
            RendererNode[] origChildren = alternateNode.getNodes();
            RendererNode[] children = new RendererNode[origChildren.length];
            for (int i = 0; i < children.length; ++i) {
                children[i] = RendererNodeUtils.copy(viewer, origChildren[i]);
            }
            return viewer.newAlternateNode(alternateNode.getIndex(), children);
        }
        if (toCopy instanceof ChangeBoldNode) {
            ChangeBoldNode boldNode = (ChangeBoldNode)toCopy;
            return viewer.newChangeBoldNode(boldNode.isBold(), RendererNodeUtils.copy(viewer, boldNode.getChild()));
        }
        if (toCopy instanceof ChangeItalicsNode) {
            ChangeItalicsNode italicsNode = (ChangeItalicsNode)toCopy;
            return viewer.newChangeBoldNode(italicsNode.isItalics(), RendererNodeUtils.copy(viewer, italicsNode.getChild()));
        }
        if (toCopy instanceof ColorNode) {
            ColorNode colorNode = (ColorNode)toCopy;
            return viewer.newColorNode(colorNode.getColor1(), colorNode.getColor2(), colorNode.getColor3(), colorNode.getColor4(), colorNode.getColor5(), colorNode.getColor6(), colorNode.getColor7(), RendererNodeUtils.copy(viewer, colorNode.getChild()));
        }
        if (toCopy instanceof FixedWidthNode) {
            FixedWidthNode widthNode = (FixedWidthNode)toCopy;
            return viewer.newFixedWidthNode(widthNode.getWidth(), RendererNodeUtils.copy(viewer, widthNode.getChild()));
        }
        if (toCopy instanceof FontSizeChangeNode) {
            FontSizeChangeNode fontNode = (FontSizeChangeNode)toCopy;
            return viewer.newFontSizeChangeNode(fontNode.getIncrement(), RendererNodeUtils.copy(viewer, fontNode.getChild()));
        }
        if (toCopy instanceof ImageNode) {
            ImageNode imageNode = (ImageNode)toCopy;
            return viewer.newImageNode(imageNode.getImage(), imageNode.getAccessibleString());
        }
        if (toCopy instanceof LinkNode) {
            LinkNode linkNode = (LinkNode)toCopy;
            return viewer.newLinkNode(linkNode.getData(), linkNode.getLinkType(), (RendererNode)linkNode.getChild());
        }
        if (toCopy instanceof LongAndShortTextNode) {
            LongAndShortTextNode textNode = (LongAndShortTextNode)toCopy;
            LongAndShortTextNode result = viewer.newLongAndShortTextNode();
            result.setShortText(textNode.getShortText());
            result.setLongText(textNode.getLongText());
            return result;
        }
        if (toCopy instanceof MultiChildNode) {
            MultiChildNode multiNode = (MultiChildNode)toCopy;
            RendererNode[] origChildren = multiNode.getChildren();
            RendererNode[] children = new RendererNode[origChildren.length];
            for (int i = 0; i < children.length; ++i) {
                children[i] = RendererNodeUtils.copy(viewer, origChildren[i]);
            }
            return viewer.newMultiChildNode(children);
        }
        if (toCopy instanceof NumberNode) {
            NumberNode numberNode = (NumberNode)toCopy;
            NumberNode result = viewer.newNumberNode();
            result.setNumber(numberNode.getNumber(), numberNode.getRawFormattedNumber());
            return result;
        }
        if (toCopy instanceof OrderedMultiChildNode) {
            OrderedMultiChildNode multiNode = (OrderedMultiChildNode)toCopy;
            RendererNode[] origChildren = multiNode.getChildren();
            RendererNode[] children = new RendererNode[origChildren.length];
            for (int i = 0; i < children.length; ++i) {
                children[i] = RendererNodeUtils.copy(viewer, origChildren[i]);
            }
            return viewer.newOrderedMultiChildNode((int[])multiNode.getOrder().clone(), children);
        }
        if (toCopy instanceof OverlayImageNode) {
            OverlayImageNode overlayImageNode = (OverlayImageNode)toCopy;
            return viewer.newOverlayImageNode(overlayImageNode.getImages(), overlayImageNode.getIndices(), overlayImageNode.getAccessibleString());
        }
        if (toCopy instanceof PercentageBarNode) {
            PercentageBarNode percentageNode = (PercentageBarNode)toCopy;
            PercentageBarNode result = viewer.newPercentageBarNode();
            result.setPercentage(percentageNode.getPercentage1(), percentageNode.getPercentage2(), percentageNode.getPercentage3(), percentageNode.getPercentage4(), percentageNode.getPercentage5(), percentageNode.getPercentage6());
            return result;
        }
        if (toCopy instanceof SeparatorNode) {
            return viewer.newSeparatorNode();
        }
        if (toCopy instanceof SpaceNode) {
            SpaceNode spaceNode = (SpaceNode)toCopy;
            return viewer.newSpaceNode(spaceNode.getWidth());
        }
        if (toCopy instanceof TextNode) {
            TextNode textNode = (TextNode)toCopy;
            return viewer.newTextNode(textNode.getText());
        }
        if (toCopy instanceof BarChartNode) {
            BarChartNode chartNode = (BarChartNode)toCopy;
            BarChartNode result = viewer.newBarChartNode();
            result.setBarHeader(chartNode.getBarHeader());
            result.setMaxValue(chartNode.getMaxValue());
            result.setValue(chartNode.getValue());
            return result;
        }
        if (toCopy instanceof LineChartNode) {
            LineChartNode chartNode = (LineChartNode)toCopy;
            LineChartNode result = viewer.newLineChartNode();
            result.copyValues(chartNode);
            result.setXValueRange(chartNode.getXRangeMin(), chartNode.getXRangeMax());
            result.setYValueRange(chartNode.getYRangeMin(), chartNode.getYRangeMax());
            return result;
        }
        if (toCopy instanceof PieChartNode) {
            PieChartNode chartNode = (PieChartNode)toCopy;
            PieChartNode result = viewer.newPieChartNode();
            result.copyValues(chartNode);
            return result;
        }
        throw new RuntimeException("Invalid renderer node " + toCopy);
    }

    public static RendererNode getFirstContentNode(RendererNode node) {
        if (node instanceof AlignNode) {
            AlignNode alignNode = (AlignNode)node;
            return RendererNodeUtils.getFirstContentNode(alignNode.getChild());
        }
        if (node instanceof AlternateNode) {
            AlternateNode alternateNode = (AlternateNode)node;
            return RendererNodeUtils.getFirstContentNode(alternateNode.getSelected());
        }
        if (node instanceof ChangeBoldNode) {
            ChangeBoldNode boldNode = (ChangeBoldNode)node;
            return RendererNodeUtils.getFirstContentNode(boldNode.getChild());
        }
        if (node instanceof ChangeItalicsNode) {
            ChangeItalicsNode italicsNode = (ChangeItalicsNode)node;
            return RendererNodeUtils.getFirstContentNode(italicsNode.getChild());
        }
        if (node instanceof ColorNode) {
            ColorNode colorNode = (ColorNode)node;
            return RendererNodeUtils.getFirstContentNode(colorNode.getChild());
        }
        if (node instanceof FixedWidthNode) {
            FixedWidthNode widthNode = (FixedWidthNode)node;
            return RendererNodeUtils.getFirstContentNode(widthNode.getChild());
        }
        if (node instanceof FontSizeChangeNode) {
            FontSizeChangeNode fontNode = (FontSizeChangeNode)node;
            return RendererNodeUtils.getFirstContentNode(fontNode.getChild());
        }
        if (node instanceof ImageNode) {
            return node;
        }
        if (node instanceof LinkNode) {
            LinkNode linkNode = (LinkNode)node;
            return RendererNodeUtils.getFirstContentNode(linkNode.getChild());
        }
        if (node instanceof LongAndShortTextNode) {
            return node;
        }
        if (node instanceof MultiChildNode) {
            MultiChildNode multiNode = (MultiChildNode)node;
            for (RendererNode child : multiNode.getChildren()) {
                if (RendererNodeUtils.getFirstContentNode(child) == null) continue;
                return RendererNodeUtils.getFirstContentNode(child);
            }
            return null;
        }
        if (node instanceof NumberNode) {
            return node;
        }
        if (node instanceof OrderedMultiChildNode) {
            OrderedMultiChildNode multiNode = (OrderedMultiChildNode)node;
            RendererNode[] children = multiNode.getChildren();
            for (int index : multiNode.getOrder()) {
                if (RendererNodeUtils.getFirstContentNode(children[index]) == null) continue;
                return RendererNodeUtils.getFirstContentNode(children[index]);
            }
            return null;
        }
        if (node instanceof OverlayImageNode) {
            return node;
        }
        if (node instanceof PercentageBarNode) {
            return node;
        }
        if (node instanceof SeparatorNode) {
            return null;
        }
        if (node instanceof SpaceNode) {
            return null;
        }
        if (node instanceof TextNode) {
            return node;
        }
        if (node instanceof BarChartNode) {
            return node;
        }
        if (node instanceof LineChartNode) {
            return node;
        }
        if (node instanceof PieChartNode) {
            return node;
        }
        throw new RuntimeException("Invalid renderer node " + node);
    }

    public static boolean firstIsImage(RendererNode node) {
        RendererNode first = RendererNodeUtils.getFirstContentNode(node);
        return first instanceof ImageNode || first instanceof OverlayImageNode;
    }
}

