/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.viewer.tree;

import com.sap.jvm.profiling.viewer.tree.PlaceholderItem;
import com.sap.jvm.profiling.viewer.tree.TreeModel;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;

public final class TreeModelBackwardIterator {
    private TreeModelItem item;
    private final TreeModel model;

    public TreeModelBackwardIterator(TreeModel model) {
        TreeModelItem[] roots = model.getRootItems();
        this.model = model;
        this.item = roots.length == 0 ? null : this.getLastItem(roots[roots.length - 1]);
    }

    public TreeModelBackwardIterator(TreeModel model, TreeModelItem item) {
        this.model = model;
        this.item = item;
    }

    public boolean hasPrev() {
        return this.item != null;
    }

    public TreeModelItem prev() {
        assert (this.model.isValid(this.item));
        TreeModelItem result = this.item;
        do {
            this.advance();
        } while (this.item != null && this.item instanceof PlaceholderItem);
        return result;
    }

    private void advance() {
        TreeModelItem[] siblings = this.item.getSiblings(this.model);
        this.item = this.item.getIndex() > 0 ? this.getLastItem(siblings[this.item.getIndex() - 1]) : this.item.getParent();
    }

    private final TreeModelItem getLastItem(TreeModelItem start) {
        TreeModelItem curr = start;
        while (curr.isExpanded()) {
            TreeModelItem[] items = curr.getSubsOrChildren();
            curr = items[items.length - 1];
        }
        return curr;
    }
}

