/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.viewer.tree;

import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.tree.MultiItem;
import com.sap.jvm.profiling.viewer.tree.NormalItem;
import com.sap.jvm.profiling.viewer.tree.PlaceholderItem;
import com.sap.jvm.profiling.viewer.tree.TreeModel;
import com.sap.jvm.profiling.viewer.tree.TreeModelForwardIterator;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;
import com.sap.jvm.profiling.viewer.tree.TreeModelListener;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.threads.RunWaiter;
import com.sap.jvm.util.threads.ThreadRunner;
import com.sap.jvm.util.threads.VoidRunnable;
import java.util.HashSet;

public class TreeModelExpander {
    private final HashSet<Object> nodesToExpand = new HashSet();
    private final TreeModel model;
    private TreeModelForwardIterator it;
    private final RunWaiter<Boolean> waiter;
    private final TreeModelListener listener;
    private volatile boolean stop;
    private final int maxDepth;
    private boolean invalid;

    public TreeModelExpander(TreeModel model, TreeModelItem[] toExpand, int maxDepth) {
        this.model = model;
        this.listener = new Listener();
        model.addListener(this.listener);
        this.maxDepth = maxDepth;
        this.it = new TreeModelForwardIterator(model);
        for (TreeModelItem item : toExpand) {
            this.addNodes(item);
        }
        this.waiter = new ThreadRunner().run((VoidRunnable)new VoidRunnable<Boolean>(){

            public Boolean run() throws Exception {
                while (!TreeModelExpander.this.stop && TreeModelExpander.this.it.hasNext()) {
                    TreeModelItem item = TreeModelExpander.this.it.peek();
                    TreeModelExpander.this.expandItemIfNeeded(item);
                    if (TreeModelExpander.this.stop) continue;
                    TreeModelExpander.this.it.next();
                }
                TreeModelExpander.this.model.removeListener(TreeModelExpander.this.listener);
                return TreeModelExpander.this.stop;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stop = true;
        TreeModelListener treeModelListener = this.listener;
        synchronized (treeModelListener) {
            this.listener.notifyAll();
        }
        this.waitUntilFinished();
    }

    public boolean waitUntilFinished() {
        boolean result = (Boolean)this.waiter.getResult();
        if (this.invalid) {
            Trace.warn((String)"Expanding failed due to invalid item");
        }
        if (this.waiter.getThrowable() != null) {
            Trace.warn((Throwable)this.waiter.getThrowable(), (String)"Expanding failed with exception");
        }
        return result;
    }

    private void addNodes(TreeModelItem item) {
        if (item instanceof NormalItem) {
            NormalItem normalItem = (NormalItem)item;
            this.nodesToExpand.add(normalItem.getNode());
        } else if (item instanceof MultiItem) {
            MultiItem multiItem = (MultiItem)item;
            for (Object node : multiItem.getNodes()) {
                this.nodesToExpand.add(node);
            }
        }
    }

    private void expandItemIfNeeded(TreeModelItem item) {
        block7: {
            block6: {
                if (this.getDepth(item) > this.maxDepth) {
                    return;
                }
                if (!(item instanceof NormalItem)) break block6;
                NormalItem normalItem = (NormalItem)item;
                if (!this.nodesToExpand.contains(normalItem.getNode())) break block7;
                this.nodesToExpand.remove(normalItem.getNode());
                if (!normalItem.isExpanded() && normalItem.isExpandable()) {
                    this.expandItemAndWait(normalItem);
                } else {
                    for (TreeModelItem child : item.getSubsOrChildren()) {
                        this.addNodes(child);
                    }
                }
                break block7;
            }
            if (item instanceof MultiItem) {
                MultiItem multiItem = (MultiItem)item;
                for (Object node : multiItem.getNodes()) {
                    if (!this.nodesToExpand.contains(node)) continue;
                    this.model.toggleItem(multiItem, false);
                    this.it = new TreeModelForwardIterator(this.model, item.getParent());
                }
            }
        }
    }

    private int getDepth(TreeModelItem item) {
        int depth = 1;
        for (TreeModelItem curr = item; curr != null; curr = curr.getParent()) {
            ++depth;
        }
        return depth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void expandItemAndWait(final NormalItem item) {
        this.model.getViewer().getTaskManager().performForegroundTask(new Runnable(){

            @Override
            public void run() {
                TreeModelExpander.this.model.expandItem(item, false, false);
            }
        });
        var2_2 = this.listener;
        synchronized (var2_2) {
            block6: {
                do lbl-1000:
                // 3 sources

                {
                    block7: {
                        if (!this.model.isValid(item)) {
                            this.stop = true;
                            this.invalid = true;
                            return;
                        }
                        if (item.isExpanded()) break block7;
                        if (this.waitForItemChange()) ** GOTO lbl-1000
                        return;
                    }
                    children = item.getSubsOrChildren();
                    if (children.length != 0 && !(children[0] instanceof PlaceholderItem)) break block6;
                } while (this.waitForItemChange());
                return;
            }
            for (TreeModelItem child : children) {
                this.addNodes(child);
            }
            return;
        }
    }

    private boolean waitForItemChange() {
        try {
            this.listener.wait();
        }
        catch (InterruptedException e) {
            this.stop = true;
        }
        return !this.stop;
    }

    private class Listener
    implements TreeModelListener {
        private Listener() {
        }

        @Override
        public synchronized void columnsChanged(TreeModel dummy) {
            this.notifyAll();
        }

        @Override
        public void columnsOrderChanged(TreeModel dummy) {
        }

        @Override
        public synchronized void itemChanged(TreeModel dummy, TreeModelItem item, Exception excetpion) {
            this.notifyAll();
        }

        @Override
        public synchronized void rootsCreated(TreeModel dummy, Exception excetpion) {
            this.notifyAll();
        }

        @Override
        public synchronized void selectionChanged(TreeModel dummy, TreeModelItem[] selectedItems) {
            this.notifyAll();
        }

        @Override
        public synchronized void sortingChanged(TreeModel dummy) {
            this.notifyAll();
        }

        @Override
        public synchronized void treeChanged(TreeModel dummy) {
            this.notifyAll();
        }

        @Override
        public void viewerChanged(TreeModel dummy, ModelViewer oldViewer, ModelViewer newViewer) {
            TreeModelExpander.this.stop = true;
        }
    }
}

