/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.viewer.tree;

import com.sap.jvm.profiling.viewer.tree.PlaceholderItem;
import com.sap.jvm.profiling.viewer.tree.TreeModel;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;

public final class TreeModelForwardIterator {
    private TreeModelItem item;
    private final TreeModel model;

    public TreeModelForwardIterator(TreeModel model) {
        TreeModelItem[] roots = model.getRootItems();
        this.model = model;
        this.item = roots.length == 0 ? null : roots[0];
    }

    public TreeModelForwardIterator(TreeModel model, TreeModelItem item) {
        this.model = model;
        this.item = item;
    }

    public boolean hasNext() {
        return this.item != null;
    }

    public TreeModelItem next() {
        assert (this.model.isValid(this.item));
        TreeModelItem result = this.item;
        do {
            this.advance();
        } while (this.item != null && this.item instanceof PlaceholderItem);
        return result;
    }

    public TreeModelItem peek() {
        assert (this.model.isValid(this.item));
        return this.item;
    }

    private void advance() {
        if (this.item.isExpanded()) {
            this.item = this.item.getSubsOrChildren()[0];
            return;
        }
        while (this.item != null) {
            TreeModelItem[] items = this.item.getSiblings(this.model);
            if (this.item.getIndex() + 1 < items.length) {
                this.item = items[this.item.getIndex() + 1];
                return;
            }
            this.item = this.item.getParent();
        }
    }
}

