/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;

public class DirectoryComparator {
    public static void main(String[] args) throws IOException, NoSuchAlgorithmException {
        if (args.length != 3) {
            System.out.println("DirectoryComparator  [-c|-v] <dir> <result-file>");
            System.out.println();
            System.out.println("-c: the result file is created for the directory");
            System.out.println("-v: the result file is compared agains the directory");
            System.exit(1);
        }
        MessageDigest digest = MessageDigest.getInstance("MD5");
        Object[] files = DirectoryComparator.getFiles(new File(args[1]));
        Arrays.sort(files);
        if ("-c".equals(args[0])) {
            PrintStream out = new PrintStream(new FileOutputStream(args[2]));
            for (Object file : files) {
                out.println(((File)file).getCanonicalPath());
                out.println(((File)file).lastModified());
                out.println(DirectoryComparator.getHash(digest, (File)file));
            }
            out.close();
        } else if ("-v".equals(args[0])) {
            BufferedReader reader = new BufferedReader(new FileReader(args[2]));
            File otherFile = null;
            for (Object file : files) {
                String otherHash;
                String hash;
                String otherModDate;
                String modDate;
                otherFile = new File(reader.readLine());
                if (!otherFile.equals(otherFile)) {
                    System.out.println("Expected " + ((File)file).getCanonicalPath() + " but got " + otherFile.getCanonicalPath());
                    reader.close();
                    System.exit(1);
                }
                if (!(modDate = reader.readLine()).equals(otherModDate = "" + otherFile.lastModified())) {
                    System.out.println("Different mod date for " + ((File)file).getCanonicalPath() + ": " + modDate + " vs. " + otherModDate);
                    reader.close();
                    System.exit(1);
                }
                if ((hash = reader.readLine()).equals(otherHash = DirectoryComparator.getHash(digest, otherFile))) continue;
                System.out.println("Different hash for " + ((File)file).getCanonicalPath() + ": " + hash + " vs. " + otherHash);
                reader.close();
                System.exit(1);
            }
            try {
                otherFile = new File(reader.readLine());
            }
            catch (Exception e) {
                reader.close();
                System.exit(0);
            }
            System.out.println("Got additional file " + otherFile.getCanonicalPath());
            reader.close();
            System.exit(1);
        } else {
            System.out.println("Unknown option " + args[0]);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHash(MessageDigest digest, File file) throws IOException {
        digest.reset();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            byte[] buffer = new byte[16384];
            int read = 0;
            while ((read = ((InputStream)in).read(buffer)) != -1) {
                digest.update(buffer, 0, read);
            }
            String string = Arrays.toString(digest.digest());
            return string;
        }
    }

    private static File[] getFiles(File dir) {
        File[] content = dir.listFiles();
        ArrayList<File> result = new ArrayList<File>();
        for (File file : content) {
            if (file.isDirectory()) {
                result.addAll(Arrays.asList(DirectoryComparator.getFiles(file)));
                continue;
            }
            result.add(file);
        }
        return result.toArray(new File[result.size()]);
    }
}

