/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public class NetworkInterfaceInfo {
    private static HashSet<String> hostNames = new HashSet();
    private static HashSet<String> addresses = new HashSet();
    private static HashSet<String> ifNames = new HashSet();
    private static HashSet<Integer> indices = new HashSet();

    public static void main(String[] args) throws Exception {
        NetworkInterface nif;
        NetworkInterface nif2;
        boolean full = false;
        if (args.length > 0) {
            if ("-full".equals(args[0])) {
                full = true;
            } else if ("-name".equals(args[0])) {
                if (args.length > 1) {
                    NetworkInterface nif3 = NetworkInterface.getByName(args[1]);
                    NetworkInterfaceInfo.printNetworkInterface(nif3);
                    return;
                }
                System.out.println("Missing interface name");
                System.exit(1);
            } else if ("-addr".equals(args[0])) {
                if (args.length > 1) {
                    InetAddress ia = InetAddress.getByName(args[1]);
                    NetworkInterface nif4 = NetworkInterface.getByInetAddress(ia);
                    NetworkInterfaceInfo.printNetworkInterface(nif4);
                    return;
                }
                System.out.println("Missing interface name");
                System.exit(1);
            } else {
                System.out.println("NetworkInterfaceInfo [-full|-name <name>|-addr <addr>]");
                System.out.println();
                System.out.println("-full: Do a full scan");
                System.out.println("-name: Display an interface by name");
                System.out.println("-addr: Display an interface by address");
                System.exit(1);
            }
        }
        System.out.println("*** Displaying the network interfaces as returned by getNetworkInterfaces() ***");
        Enumeration nifs = NetworkInterface.getNetworkInterfaces();
        int nr = 0;
        while (nifs.hasMoreElements()) {
            nif2 = nifs.nextElement();
            System.out.println("Network interface nr. " + ++nr + ":");
            NetworkInterfaceInfo.printNetworkInterface(nif2);
        }
        System.out.println("*** Displaying the network interfaces as returned by getSubInterfaces() ***");
        nr = 0;
        while (nifs.hasMoreElements()) {
            ++nr;
            try {
                Method m = NetworkInterface.class.getMethod("getSubInterfaces", new Class[0]);
                if (m != null) {
                    nifs = (Enumeration)m.invoke(null, new Object[0]);
                }
            }
            catch (Exception m) {
                // empty catch block
            }
            nif2 = nifs.nextElement();
            System.out.println("Network interface nr. " + nr + ":");
            NetworkInterfaceInfo.printNetworkInterface(nif2);
        }
        if (!full) {
            return;
        }
        System.out.println("*** Displaying the network interfaces for all seen indices ***");
        Iterator<Object> iterator = indices.iterator();
        while (iterator.hasNext()) {
            int ni = iterator.next();
            nif = null;
            try {
                Method m = NetworkInterface.class.getMethod("getByIndex", Integer.TYPE);
                if (m != null) {
                    nif = (NetworkInterface)m.invoke(null, ni);
                }
            }
            catch (Exception m) {
                // empty catch block
            }
            System.out.println("Network interface for index " + ni + ":");
            NetworkInterfaceInfo.printNetworkInterface(nif);
        }
        System.out.println("*** Displaying the network interfaces for all seen interface names ***");
        for (String in : ifNames) {
            nif = NetworkInterface.getByName(in);
            System.out.println("Network interface for name " + in + ":");
            NetworkInterfaceInfo.printNetworkInterface(nif);
        }
        System.out.println("*** Displaying the network interfaces for all seen addresses ***");
        for (String ian : addresses) {
            InetAddress ia = InetAddress.getByName(ian);
            NetworkInterface nif5 = NetworkInterface.getByInetAddress(ia);
            System.out.println("Network interface for address " + ia + ":");
            NetworkInterfaceInfo.printNetworkInterface(nif5);
        }
        System.out.println("*** Displaying the network interfaces for all seen host names ***");
        for (String hn : hostNames) {
            System.out.println("Displaying interfaces for host " + hn);
            for (InetAddress ia : InetAddress.getAllByName(hn)) {
                NetworkInterface nif6 = NetworkInterface.getByInetAddress(ia);
                System.out.println("Network interface for address " + ia + ":");
                NetworkInterfaceInfo.printNetworkInterface(nif6);
            }
        }
    }

    private static void printNetworkInterface(NetworkInterface nif) {
        Method m2;
        if (nif == null) {
            System.out.println("NetworkInterface not found");
            return;
        }
        ifNames.add(nif.getName());
        System.out.println(nif.getDisplayName() + " (" + nif.getName() + ")");
        Enumeration<InetAddress> ias = nif.getInetAddresses();
        try {
            m2 = nif.getClass().getMethod("getHardwareAddress", new Class[0]);
            if (m2 != null) {
                System.out.println("MAC: " + Arrays.toString((byte[])m2.invoke((Object)nif, new Object[0])));
            }
        }
        catch (Exception m2) {
            // empty catch block
        }
        try {
            m2 = nif.getClass().getMethod("getMTU", new Class[0]);
            if (m2 != null) {
                System.out.println("MTU: " + m2.invoke((Object)nif, new Object[0]));
            }
        }
        catch (Exception m3) {
            // empty catch block
        }
        try {
            m2 = nif.getClass().getMethod("getIndex", new Class[0]);
            if (m2 != null) {
                int ii = (Integer)m2.invoke((Object)nif, new Object[0]);
                System.out.println("Index: " + ii);
            }
        }
        catch (Exception m4) {
            // empty catch block
        }
        try {
            m2 = nif.getClass().getMethod("isLoopback", new Class[0]);
            if (m2 != null) {
                System.out.println("loopback: " + m2.invoke((Object)nif, new Object[0]));
            }
        }
        catch (Exception m5) {
            // empty catch block
        }
        try {
            m2 = nif.getClass().getMethod("isPointToPoint", new Class[0]);
            if (m2 != null) {
                System.out.println("point2point: " + m2.invoke((Object)nif, new Object[0]));
            }
        }
        catch (Exception m6) {
            // empty catch block
        }
        try {
            m2 = nif.getClass().getMethod("IsUp", new Class[0]);
            if (m2 != null) {
                System.out.println("up: " + m2.invoke((Object)nif, new Object[0]));
            }
        }
        catch (Exception m7) {
            // empty catch block
        }
        try {
            m2 = nif.getClass().getMethod("supportsMulticast", new Class[0]);
            if (m2 != null) {
                System.out.println("multicast supported: " + m2.invoke((Object)nif, new Object[0]));
            }
        }
        catch (Exception m8) {
            // empty catch block
        }
        try {
            m2 = nif.getClass().getMethod("isVirtual", new Class[0]);
            if (m2 != null) {
                System.out.println("virtual: " + m2.invoke((Object)nif, new Object[0]));
            }
        }
        catch (Exception m9) {
            // empty catch block
        }
        int index = 0;
        while (ias.hasMoreElements()) {
            ++index;
            InetAddress ia = ias.nextElement();
            hostNames.add(ia.getHostName());
            addresses.add(ia.getHostAddress());
            System.out.println("    Inetaddress nr. " + index + ":");
            System.out.println("    host adddress: " + ia.getHostAddress());
            System.out.println("    host name: " + ia.getHostName());
            System.out.println("    canonical host name: " + ia.getCanonicalHostName());
            System.out.println("    is any local address: " + ia.isAnyLocalAddress());
            System.out.println("    is link local address: " + ia.isLinkLocalAddress());
            System.out.println("    is loopback address: " + ia.isLoopbackAddress());
            System.out.println("    is MC: " + ia.isMulticastAddress());
            System.out.println("    is MC global: " + ia.isMCGlobal());
            System.out.println("    is MC link local: " + ia.isMCLinkLocal());
            System.out.println("    is MC node local: " + ia.isMCNodeLocal());
            System.out.println("    is MC org local: " + ia.isMCOrgLocal());
            System.out.println("    is MC site local: " + ia.isMCSiteLocal());
            System.out.println("    is site local: " + ia.isSiteLocalAddress());
        }
    }
}

