/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.console;

import com.sap.jdk.ext.util.Console;
import com.sap.jvm.tools.console.Completor;
import com.sap.jvm.tools.console.CursorBuffer;
import com.sap.jvm.tools.console.History;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedList;

public class ConsoleReader {
    private static final String prompt = "$ ";
    private static final char BACKSPACE = '\b';
    private static final char RESET_LINE = '\r';
    private static final String CR = System.getProperty("line.separator");
    private final Writer out;
    private final CursorBuffer buf = new CursorBuffer();
    private final History history = new History();
    Completor completor;

    public ConsoleReader(Completor completor) {
        this.out = new PrintWriter(System.out);
        this.completor = completor;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public synchronized void start() {
                Console.get().setMode(Console.Mode.DEFAULT);
            }
        });
    }

    public String readLine(boolean rawMode) throws IOException {
        Console console = Console.get();
        try {
            console.setMode(Console.Mode.NON_CANONICAL);
            if (!rawMode) {
                this.out.write(prompt);
                this.out.flush();
            }
            while (true) {
                int c;
                if ((c = console.readChar()) == -1) {
                    String string = null;
                    return string;
                }
                switch (c) {
                    case 4: {
                        String string = null;
                        return string;
                    }
                    case 3: {
                        String string = null;
                        return string;
                    }
                    case 9: {
                        if (rawMode) break;
                        this.complete();
                        break;
                    }
                    case 1: {
                        this.setCursorPosition(0);
                        break;
                    }
                    case 11: {
                        this.killLine();
                        break;
                    }
                    case 10: 
                    case 13: {
                        this.printNewline();
                        String string = this.finishBuffer(rawMode);
                        return string;
                    }
                    case 8: {
                        this.backspace();
                        break;
                    }
                    case 127: {
                        this.deleteCurrentCharacter();
                        break;
                    }
                    case 5: {
                        this.moveToEnd();
                        break;
                    }
                    case 331: {
                        this.moveCursor(-1);
                        break;
                    }
                    case 333: {
                        this.moveCursor(1);
                        break;
                    }
                    case 336: {
                        if (rawMode) break;
                        this.moveHistory(true);
                        break;
                    }
                    case 328: {
                        if (rawMode) break;
                        this.moveHistory(false);
                        break;
                    }
                    case 27: {
                        this.moveInternal(-this.buf.cursor);
                        this.killLine();
                        break;
                    }
                    default: {
                        if (c == 0) break;
                        this.putChar(c);
                    }
                }
                this.flushConsole();
            }
        }
        finally {
            console.setMode(Console.Mode.DEFAULT);
        }
    }

    public String readLine() throws IOException {
        return this.readLine(true);
    }

    private final boolean moveHistory(boolean next) throws IOException {
        if (next && !this.history.next()) {
            return false;
        }
        if (!next && !this.history.previous()) {
            return false;
        }
        this.setBuffer(this.history.current());
        return true;
    }

    public boolean killLine() throws IOException {
        int len;
        int cp = this.buf.cursor > 0 ? this.buf.cursor : 0;
        if (cp >= (len = this.buf.buffer.length())) {
            return false;
        }
        int num = this.buf.buffer.length() - cp;
        this.clearAhead(num);
        for (int i = 0; i < num; ++i) {
            this.buf.buffer.deleteCharAt(len - i - 1);
        }
        return true;
    }

    private final boolean complete() throws IOException {
        if (this.completor == null) {
            return false;
        }
        LinkedList<String> candidates = new LinkedList<String>();
        String bufstr = this.buf.buffer.toString();
        this.completor.complete(bufstr, candidates);
        String candidate = "";
        if (candidates.size() == 0) {
            return false;
        }
        if (candidates.size() == 1) {
            candidate = (String)candidates.get(0);
            if (candidate.equals(this.buf.toString())) {
                return false;
            }
            this.setBuffer(candidate);
            return true;
        }
        if (candidates.size() > 1) {
            String first = (String)candidates.get(0);
            for (int i = 0; i < first.length(); ++i) {
                String sub = first.substring(0, i + 1);
                boolean isMatch = true;
                for (int j = 1; j < candidates.size(); ++j) {
                    if (((String)candidates.get(j)).startsWith(sub)) continue;
                    isMatch = false;
                    break;
                }
                if (!isMatch) break;
                candidate = candidate + first.charAt(i);
            }
        }
        if (candidate.equals(this.buf.toString())) {
            this.printNewline();
            for (int i = 0; i < candidates.size(); ++i) {
                this.out.write((String)candidates.get(i) + "\n");
            }
            this.drawLine();
        }
        this.setBuffer(candidate);
        return true;
    }

    public final boolean setCursorPosition(int position) throws IOException {
        return this.moveCursor(position - this.buf.cursor) != 0;
    }

    private final void setBuffer(String buffer) throws IOException {
        if (buffer.equals(this.buf.buffer.toString())) {
            return;
        }
        int sameIndex = 0;
        int l1 = buffer.length();
        int l2 = this.buf.buffer.length();
        for (int i = 0; i < l1 && i < l2 && buffer.charAt(i) == this.buf.buffer.charAt(i); ++i) {
            ++sameIndex;
        }
        int diff = this.buf.buffer.length() - sameIndex;
        this.backspace(diff);
        this.killLine();
        this.buf.buffer.setLength(sameIndex);
        this.putString(buffer.substring(sameIndex));
    }

    public final void redrawLine() throws IOException {
        this.printCharacter(13);
        this.flushConsole();
        this.drawLine();
    }

    public final void drawLine() throws IOException {
        if (prompt != null) {
            this.printString(prompt);
        }
        this.printString(this.buf.buffer.toString());
        if (this.buf.length() != this.buf.cursor) {
            this.back(this.buf.length() - this.buf.cursor);
        }
    }

    public final void printNewline() throws IOException {
        this.printString(CR);
        this.flushConsole();
    }

    public final void putString(String str) throws IOException {
        this.buf.write(str);
        this.printString(str);
        this.drawBuffer();
    }

    private final String finishBuffer(boolean rawMode) {
        String str = this.buf.buffer.toString();
        if (!rawMode) {
            if (str.length() > 0) {
                this.history.addToHistory(str);
            }
            this.history.moveToEnd();
        }
        this.buf.buffer.setLength(0);
        this.buf.cursor = 0;
        return str;
    }

    public final void printString(String str) throws IOException {
        this.printCharacters(str.toCharArray());
    }

    private final void putChar(int c) throws IOException {
        this.buf.write((char)c);
        this.printCharacter(c);
        this.drawBuffer();
    }

    private final void drawBuffer(int clear) throws IOException {
        char[] chars = this.buf.buffer.substring(this.buf.cursor).toCharArray();
        this.printCharacters(chars);
        this.clearAhead(clear);
        this.back(chars.length);
        this.flushConsole();
    }

    private final void drawBuffer() throws IOException {
        this.drawBuffer(0);
    }

    private final void clearAhead(int num) throws IOException {
        if (num == 0) {
            return;
        }
        this.printCharacters(' ', num);
        this.flushConsole();
        this.back(num);
        this.flushConsole();
    }

    private final void back(int num) throws IOException {
        this.printCharacters('\b', num);
        this.flushConsole();
    }

    private final void printCharacter(int c) throws IOException {
        this.out.write(c);
    }

    private final void printCharacters(char[] c) throws IOException {
        this.out.write(c);
    }

    private final void printCharacters(char c, int num) throws IOException {
        if (num == 1) {
            this.printCharacter(c);
        } else {
            char[] chars = new char[num];
            Arrays.fill(chars, c);
            this.printCharacters(chars);
        }
    }

    public final void flushConsole() throws IOException {
        this.out.flush();
    }

    private final int backspace(int num) throws IOException {
        if (this.buf.cursor == 0) {
            return 0;
        }
        int count = 0;
        count = this.moveCursor(-1 * num) * -1;
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + count);
        this.drawBuffer(count);
        return count;
    }

    public final boolean backspace() throws IOException {
        return this.backspace(1) == 1;
    }

    private final boolean moveToEnd() throws IOException {
        if (this.moveCursor(1) == 0) {
            return false;
        }
        while (this.moveCursor(1) != 0) {
        }
        return true;
    }

    private final boolean deleteCurrentCharacter() throws IOException {
        boolean success;
        boolean bl = success = this.buf.buffer.length() > 0;
        if (!success) {
            return false;
        }
        if (this.buf.cursor == this.buf.buffer.length()) {
            return false;
        }
        this.buf.buffer.deleteCharAt(this.buf.cursor);
        this.drawBuffer(1);
        return true;
    }

    private final int moveCursor(int num) throws IOException {
        int where = num;
        if (this.buf.cursor == 0 && where < 0) {
            return 0;
        }
        if (this.buf.cursor == this.buf.buffer.length() && where > 0) {
            return 0;
        }
        if (this.buf.cursor + where < 0) {
            where = -this.buf.cursor;
        } else if (this.buf.cursor + where > this.buf.buffer.length()) {
            where = this.buf.buffer.length() - this.buf.cursor;
        }
        this.moveInternal(where);
        return where;
    }

    private final void moveInternal(int where) throws IOException {
        char c;
        this.buf.cursor += where;
        if (where < 0) {
            c = '\b';
        } else {
            if (this.buf.cursor == 0) {
                return;
            }
            c = this.buf.buffer.charAt(this.buf.cursor - 1);
        }
        this.printCharacters(c, Math.abs(where));
    }

    public boolean isHistoryCommand(String line) {
        return this.history.isHistoryCommand(line);
    }

    public String getHistoryCommand(String line) {
        return this.history.getHistoryCommand(line);
    }

    public String[] getHistory() {
        return this.history.getHistory();
    }
}

