/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.console;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class ConsoleWriter {
    private PrintWriter theWriter = null;
    private String fileName = null;
    private boolean ansiConsole = false;

    public ConsoleWriter() {
        this(System.out);
    }

    public ConsoleWriter(OutputStream outputStream) {
        this.theWriter = new PrintWriter(outputStream);
        this.fileName = null;
        this.determineIfANSIConsole();
    }

    public ConsoleWriter(String fileName, boolean append) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(fileName, append);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        this.theWriter = new PrintWriter(bos);
        this.fileName = fileName;
        this.determineIfANSIConsole();
    }

    private void determineIfANSIConsole() {
        if (this.fileName != null) {
            return;
        }
        if (!"/".equals(System.getProperty("file.separator"))) {
            return;
        }
        Method getConsole = null;
        try {
            getConsole = System.class.getMethod("console", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (getConsole == null) {
            return;
        }
        Object console = null;
        try {
            console = getConsole.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (console == null) {
            return;
        }
        this.ansiConsole = true;
    }

    public String getDumpFileName() {
        return this.fileName;
    }

    public boolean hasDumpFile() {
        return this.fileName != null;
    }

    public boolean isANSIConsole() {
        return this.ansiConsole;
    }

    public PrintWriter getPrintWriter() {
        return this.theWriter;
    }
}

