/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.console;

public final class CursorBuffer {
    public int cursor = 0;
    public final StringBuffer buffer = new StringBuffer();

    public int length() {
        return this.buffer.length();
    }

    public char current() {
        if (this.cursor <= 0) {
            return '\u0000';
        }
        return this.buffer.charAt(this.cursor - 1);
    }

    public boolean clearBuffer() {
        if (this.buffer.length() == 0) {
            return false;
        }
        this.buffer.delete(0, this.buffer.length());
        this.cursor = 0;
        return true;
    }

    public void write(char c) {
        this.buffer.insert(this.cursor++, c);
    }

    public void write(String str) {
        if (this.buffer.length() == 0) {
            this.buffer.append(str);
        } else {
            this.buffer.insert(this.cursor, str);
        }
        this.cursor += str.length();
    }

    public String toString() {
        return this.buffer.toString();
    }
}

